<?php
use DealerDirect\Generic\Category\CallStatus;
use DealerDirect\Generic\Category\Color;
use DealerDirect\Generic\Category\Country;
use DealerDirect\Generic\Category\DistanceUnit;
use DealerDirect\Generic\Category\EnginePower;
use DealerDirect\Generic\Category\Fuel;
use DealerDirect\Generic\Category\PaintworkType;
use DealerDirect\Generic\Category\ValueAddedTax;

return [
    'callstatus' => [
        CallStatus::BEING_PROCESSED => 'in behandeling',
        CallStatus::CALL_AGAIN => 'opnieuw bellen',
        CallStatus::CALL_BACK_AFTER_AUCTION => 'na veiling terugbellen',
        CallStatus::CALL_DIRECT => 'direct bellen',
        CallStatus::CALLED => 'gebeld',
        CallStatus::LEFT_VOICE_MAIL_MESSAGE => 'voicemail ingesproken',
        CallStatus::LOT_DISCUSSED_WITH_CONSUMER => 'kavel doorgenomen',
        CallStatus::NO_ANSWER => 'geen gehoor',
        CallStatus::NOT_INTERESTED => 'geen interesse',
        CallStatus::REACTIVATED => 'opnieuw geactiveerd',
        CallStatus::REQUEST_CONTACT_INFORMATION => 'verzoek contact gegevens',
        CallStatus::RESPECT_THE_CHANNEL => 'RTC',
        CallStatus::SOLD_BY_CONSUMER => 'zelf verkocht',
        CallStatus::SOLD_UNDER_OTHER_LOT => 'verkocht op andere kavel',
        CallStatus::TURBO_AUCTION => 'turboveiling'
    ],
    'color' => [
        Color::BEIGE => 'beige',
        Color::BLUE => 'blauw',
        Color::GREEN => 'groen',
        Color::BROWN => 'bruin',
        Color::YELLOW => 'geel',
        Color::GRAY => 'grijs',
        Color::ORANGE => 'oranje',
        Color::PURPLE => 'paars',
        Color::RED => 'rood',
        Color::PINK => 'rose',
        Color::WHITE => 'wit',
        Color::SILVER_GRAY => 'zilvergrijs',
        Color::BLACK => 'zwart'
    ],
    'country' => [
        Country::NETHERLANDS => 'Nederland',
        Country::BELGIUM => 'België',
        Country::GERMANY => 'Duitsland',
        Country::FRANCE => 'Frankrijk',
        Country::SWEDEN => 'Zweden',
        Country::DENMARK => 'Denemarken',
        Country::NORWAY => 'Noorwegen',
        Country::POLAND => 'Polen',
        Country::AUSTRIA => 'Oostenrijk',
        Country::LUXEMBOURG => 'Luxemburg',
        Country::SWITZERLAND => 'Zwitserland'
    ],
    'distanceunit' => [
        DistanceUnit::NOT_SPECIFIED => 'km',
        DistanceUnit::KM => 'km',
        DistanceUnit::MILES => 'mijlen',
    ],
    'enginepower' => [
        EnginePower::UNIT_KW => 'kW',
        EnginePower::UNIT_HP => 'PK'
    ],
    'fuel' => [
        Fuel::UNKNOWN => 'Onbekend',
        Fuel::GASOLINE => 'Benzine',
        Fuel::DIESEL => 'Diesel',
        Fuel::ELECTRICITY => 'Electriciteit',
        Fuel::LPG => 'LPG',
        Fuel::LPG_G3 => 'LPG-G3',
        Fuel::CRYOGENIC => 'Cryogeen',
        Fuel::CNG => 'CNG',
        Fuel::HYDROGEN => 'Waterstof',
        Fuel::HYBRID_GASOLINE => 'Hybride-Benzine',
        Fuel::HYBRID_DIESEL => 'Hybride-Diesel',
    ],
    'paintworktype' => [
        PaintworkType::UNKNOWN => 'Onbekend',
        PaintworkType::REGULAR => 'Gewone lak',
        PaintworkType::METALLIC => 'Metallic lak',
        PaintworkType::PEARL => 'Pareleffect',
    ],
    'valueaddedtax' => [
        ValueAddedTax::UNKNOWN => 'Onbekend',
        ValueAddedTax::UNKNOWN_3 => 'Onbekend(3)',
        ValueAddedTax::DEDUCTIBLE => 'BTW',
        ValueAddedTax::NON_DEDUCTIBLE => 'Marge'
    ]
];
