<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Repository;

/**
 * Immutable class to hold values of generic properties
 */
final class GenericProperties implements Repository
{
    ////////////////////////////// CLASS PROPERTIES \\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /** @var Locale */
    private $locale;
    /** @var string */
    private $vehicleType;

    //////////////////////////// SETTERS AND GETTERS \\\\\\\\\\\\\\\\\\\\\\\\\\\
    /**
     * @deprecated Use Locale instead
     *
     * @return string
     */
    public function getCountry()
    {
        return $this->locale->getTerritory();
    }
    /** @return Locale */
    public function getLocale()
    {
        return (string) $this->locale;
    }

    /** @return string */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }

    //////////////////////////////// PUBLIC API \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /**
     * Instantiate a GenericProperties object based on Category values
     *
     * @param Locale $locale
     * @param string $vehicleType
     *
     * @throws \InvalidArgumentException
     */
    final public function __construct(Locale $locale, $vehicleType)
    {
        $this->locale = $locale;
        VehicleType::assertExists($vehicleType);
        $this->vehicleType = (string) $vehicleType;
    }
}

/*EOF*/
