<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\Repository;

/**
 * Immutable object holding the value of a Token
 */
class Token implements Repository
{
    ////////////////////////////// CLASS PROPERTIES \\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /** @var string */
    private $token;

    //////////////////////////// SETTERS AND GETTERS \\\\\\\\\\\\\\\\\\\\\\\\\\\
    /** @return string */
    final public function getToken()
    {
        return $this->token;
    }

    //////////////////////////////// PUBLIC API \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /**
     * @param string $token
     */
    final public function __construct($token)
    {
        $this->token = (string) $token;
    }

    /** @return string */
    final public function __toString()
    {
        return (string) $this->getToken(); 
    }
}

/*EOF*/
