<?php

namespace DealerDirect\Generic\Category;

/**
 * Class VehicleTypeMotorCondition
 *
 * Motorcycle condition values
 *
 * Note that the values are *not* consistent with the values in VehicleTypeCarCondition
 *
 * @package DealerDirect\Generic\Category
 */
class VehicleTypeMotorCondition extends AbstractEnum
{
    // Condition not specified/unknown
    public const UNKNOWN = 0;
    public const NOT_SPECIFIED = 0;
    /**
     * Vehicle condition, "as good as *NEW*"
     */
    public const AS_NEW = 1;
    public const AS_NEW_CONDITION = 1;
    /**
     * Vehicle in *good* condition ("goed")
     */
    public const GOOD = 2;
    public const GOOD_CONDITION = 2;
    /**
     * Vehicle in *average* condition ("redelijk")
     */
    public const AVERAGE = 3;
    public const AVERAGE_CONDITION = 3;
    /**
     * Vehicle in *poor* condition ("matig")
     */
    public const POOR = 4;
    public const POOR_CONDITION = 4;
    /**
     * Vehicle in *bad* condition ("slecht")
     */
    public const BAD = 5;
    public const BAD_CONDITION = 5;
}
