<?php

namespace Dealerdirect\Generic;

use PHPUnit\Framework\TestCase;

abstract class AbstractTestCase extends TestCase
{
    /**
     * @param $categoryClass Catogory Enum class to load key value pairs from
     * @param $keyPrefix
     *
     * @return array Dataprovider result array
     */
    protected static function getCategoriesAsDataProvider($categoryClass, $keyPrefix)
    {
        $catKeys = $categoryClass::getAll();

        $data = [];
        array_walk($catKeys, function ($value) use (&$data, $categoryClass, $keyPrefix) {
            $key = $categoryClass::getKey($value);
            $data['(' . $keyPrefix . $key . ')'] = [$value];
        });

        ksort($data);

        return $data;
    }
}
