<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\Category\VehicleType;

/**
 * Immutable class to hold values of generic properties
 */
final class GenericProperties implements ImmutableInterface
{
    ////////////////////////////// CLASS PROPERTIES \\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /** @var Locale */
    private $locale;
    /** @var string */
    private $vehicleType;

    //////////////////////////// SETTERS AND GETTERS \\\\\\\\\\\\\\\\\\\\\\\\\\\
    /**
     * @deprecated Use Locale instead
     *
     * @return string
     */
    public function getCountry()
    {
        return $this->locale->getTerritory();
    }
    /** @return string */
    public function getLocale()
    {
        return (string) $this->locale;
    }

    /**
     * Retrieve actual Locale object instance (to keep backwards compatibility of getLocale())
     *
     * @return Locale
     */
    public function getLocaleInstance()
    {
        return $this->locale;
    }

    /** @return string */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }

    //////////////////////////////// PUBLIC API \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /**
     * Instantiate a GenericProperties object based on Category values
     *
     * @param Locale $locale A Locale object instance
     * @param string $vehicleType
     *
     * @throws \InvalidArgumentException
     */
    public function __construct(Locale $locale, $vehicleType)
    {
        $this->locale = $locale;
        VehicleType::assertExists($vehicleType);
        $this->vehicleType = (string) $vehicleType;
    }
}
