<?php

namespace DealerDirect\Generic\Category;

/**
 * RFC-5646 compliant "Tag for Identifying Languages"
 *
 * The locale format is:
 *
 *      language[_territory][.codeset][@modifier]
 *
 * @see http://demo.icu-project.org/icu-bin/locexp#region
 */
final class Locale extends AbstractEnum
{
    public const AF = 'af'; // Afrikaans
    public const AF_NA = 'af_NA'; // Afrikaans (Namibia)
    public const AF_ZA = 'af_ZA'; // Afrikaans (South Africa)
    public const AK = 'ak'; // Akan
    public const AK_GH = 'ak_GH'; // Akan (Ghana)
    public const SQ = 'sq'; // Albanian
    public const SQ_AL = 'sq_AL'; // Albanian (Albania)
    public const SQ_XK = 'sq_XK'; // Albanian (Kosovo)
    public const SQ_MK = 'sq_MK'; // Albanian (Macedonia)
    public const AM = 'am'; // Amharic
    public const AM_ET = 'am_ET'; // Amharic (Ethiopia)
    public const AR = 'ar'; // Arabic
    public const AR_DZ = 'ar_DZ'; // Arabic (Algeria)
    public const AR_BH = 'ar_BH'; // Arabic (Bahrain)
    public const AR_TD = 'ar_TD'; // Arabic (Chad)
    public const AR_KM = 'ar_KM'; // Arabic (Comoros)
    public const AR_DJ = 'ar_DJ'; // Arabic (Djibouti)
    public const AR_EG = 'ar_EG'; // Arabic (Egypt)
    public const AR_ER = 'ar_ER'; // Arabic (Eritrea)
    public const AR_IQ = 'ar_IQ'; // Arabic (Iraq)
    public const AR_IL = 'ar_IL'; // Arabic (Israel)
    public const AR_JO = 'ar_JO'; // Arabic (Jordan)
    public const AR_KW = 'ar_KW'; // Arabic (Kuwait)
    public const AR_LB = 'ar_LB'; // Arabic (Lebanon)
    public const AR_LY = 'ar_LY'; // Arabic (Libya)
    public const AR_MR = 'ar_MR'; // Arabic (Mauritania)
    public const AR_MA = 'ar_MA'; // Arabic (Morocco)
    public const AR_OM = 'ar_OM'; // Arabic (Oman)
    public const AR_PS = 'ar_PS'; // Arabic (Palestinian Territories)
    public const AR_QA = 'ar_QA'; // Arabic (Qatar)
    public const AR_SA = 'ar_SA'; // Arabic (Saudi Arabia)
    public const AR_SO = 'ar_SO'; // Arabic (Somalia)
    public const AR_SS = 'ar_SS'; // Arabic (South Sudan)
    public const AR_SD = 'ar_SD'; // Arabic (Sudan)
    public const AR_SY = 'ar_SY'; // Arabic (Syria)
    public const AR_TN = 'ar_TN'; // Arabic (Tunisia)
    public const AR_AE = 'ar_AE'; // Arabic (United Arab Emirates)
    public const AR_EH = 'ar_EH'; // Arabic (Western Sahara)
    public const AR_YE = 'ar_YE'; // Arabic (Yemen)
    public const HY = 'hy'; // Armenian
    public const HY_AM = 'hy_AM'; // Armenian (Armenia)
    public const AS_ = 'as'; // Assamese
    public const AS_IN = 'as_IN'; // Assamese (India)
    public const AZ = 'az'; // Azerbaijani
    public const AZ_AZ = 'az_AZ'; // Azerbaijani (Azerbaijan)
    public const AZ_CYRL_AZ = 'az_Cyrl_AZ'; // Azerbaijani (Cyrillic, Azerbaijan)
    public const AZ_CYRL = 'az_Cyrl'; // Azerbaijani (Cyrillic)
    public const AZ_LATN_AZ = 'az_Latn_AZ'; // Azerbaijani (Latin, Azerbaijan)
    public const AZ_LATN = 'az_Latn'; // Azerbaijani (Latin)
    public const BM = 'bm'; // Bambara
    public const BM_LATN_ML = 'bm_Latn_ML'; // Bambara (Latin, Mali)
    public const BM_LATN = 'bm_Latn'; // Bambara (Latin)
    public const EU = 'eu'; // Basque
    public const EU_ES = 'eu_ES'; // Basque (Spain)
    public const BE = 'be'; // Belarusian
    public const BE_BY = 'be_BY'; // Belarusian (Belarus)
    public const BN = 'bn'; // Bengali
    public const BN_BD = 'bn_BD'; // Bengali (Bangladesh)
    public const BN_IN = 'bn_IN'; // Bengali (India)
    public const BS = 'bs'; // Bosnian
    public const BS_BA = 'bs_BA'; // Bosnian (Bosnia & Herzegovina)
    public const BS_CYRL_BA = 'bs_Cyrl_BA'; // Bosnian (Cyrillic, Bosnia & Herzegovina)
    public const BS_CYRL = 'bs_Cyrl'; // Bosnian (Cyrillic)
    public const BS_LATN_BA = 'bs_Latn_BA'; // Bosnian (Latin, Bosnia & Herzegovina)
    public const BS_LATN = 'bs_Latn'; // Bosnian (Latin)
    public const BR = 'br'; // Breton
    public const BR_FR = 'br_FR'; // Breton (France)
    public const BG = 'bg'; // Bulgarian
    public const BG_BG = 'bg_BG'; // Bulgarian (Bulgaria)
    public const MY = 'my'; // Burmese
    public const MY_MM = 'my_MM'; // Burmese (Myanmar (Burma))
    public const CA = 'ca'; // Catalan
    public const CA_AD = 'ca_AD'; // Catalan (Andorra)
    public const CA_FR = 'ca_FR'; // Catalan (France)
    public const CA_IT = 'ca_IT'; // Catalan (Italy)
    public const CA_ES = 'ca_ES'; // Catalan (Spain)
    public const ZH = 'zh'; // Chinese
    public const ZH_CN = 'zh_CN'; // Chinese (China)
    public const ZH_HK = 'zh_HK'; // Chinese (Hong Kong SAR China)
    public const ZH_MO = 'zh_MO'; // Chinese (Macau SAR China)
    public const ZH_HANS_CN = 'zh_Hans_CN'; // Chinese (Simplified, China)
    public const ZH_HANS_HK = 'zh_Hans_HK'; // Chinese (Simplified, Hong Kong SAR China)
    public const ZH_HANS_MO = 'zh_Hans_MO'; // Chinese (Simplified, Macau SAR China)
    public const ZH_HANS_SG = 'zh_Hans_SG'; // Chinese (Simplified, Singapore)
    public const ZH_HANS = 'zh_Hans'; // Chinese (Simplified)
    public const ZH_SG = 'zh_SG'; // Chinese (Singapore)
    public const ZH_TW = 'zh_TW'; // Chinese (Taiwan)
    public const ZH_HANT_HK = 'zh_Hant_HK'; // Chinese (Traditional, Hong Kong SAR China)
    public const ZH_HANT_MO = 'zh_Hant_MO'; // Chinese (Traditional, Macau SAR China)
    public const ZH_HANT_TW = 'zh_Hant_TW'; // Chinese (Traditional, Taiwan)
    public const ZH_HANT = 'zh_Hant'; // Chinese (Traditional)
    public const KW = 'kw'; // Cornish
    public const KW_GB = 'kw_GB'; // Cornish (United Kingdom)
    public const HR = 'hr'; // Croatian
    public const HR_BA = 'hr_BA'; // Croatian (Bosnia & Herzegovina)
    public const HR_HR = 'hr_HR'; // Croatian (Croatia)
    public const CS = 'cs'; // Czech
    public const CS_CZ = 'cs_CZ'; // Czech (Czech Republic)
    public const DA = 'da'; // Danish
    public const DA_DK = 'da_DK'; // Danish (Denmark)
    public const DA_GL = 'da_GL'; // Danish (Greenland)
    public const NL = 'nl'; // Dutch
    public const NL_AW = 'nl_AW'; // Dutch (Aruba)
    public const NL_BE = 'nl_BE'; // Dutch (Belgium)
    public const NL_BQ = 'nl_BQ'; // Dutch (Caribbean Netherlands)
    public const NL_CW = 'nl_CW'; // Dutch (Curaçao)
    public const NL_NL = 'nl_NL'; // Dutch (Netherlands)
    public const NL_SX = 'nl_SX'; // Dutch (Sint Maarten)
    public const NL_SR = 'nl_SR'; // Dutch (Suriname)
    public const DZ = 'dz'; // Dzongkha
    public const DZ_BT = 'dz_BT'; // Dzongkha (Bhutan)
    public const EN = 'en'; // English
    public const EN_AS = 'en_AS'; // English (American Samoa)
    public const EN_AI = 'en_AI'; // English (Anguilla)
    public const EN_AG = 'en_AG'; // English (Antigua & Barbuda)
    public const EN_AU = 'en_AU'; // English (Australia)
    public const EN_BS = 'en_BS'; // English (Bahamas)
    public const EN_BB = 'en_BB'; // English (Barbados)
    public const EN_BE = 'en_BE'; // English (Belgium)
    public const EN_BZ = 'en_BZ'; // English (Belize)
    public const EN_BM = 'en_BM'; // English (Bermuda)
    public const EN_BW = 'en_BW'; // English (Botswana)
    public const EN_IO = 'en_IO'; // English (British Indian Ocean Territory)
    public const EN_VG = 'en_VG'; // English (British Virgin Islands)
    public const EN_CM = 'en_CM'; // English (Cameroon)
    public const EN_CA = 'en_CA'; // English (Canada)
    public const EN_KY = 'en_KY'; // English (Cayman Islands)
    public const EN_CX = 'en_CX'; // English (Christmas Island)
    public const EN_CC = 'en_CC'; // English (Cocos (Keeling) Islands)
    public const EN_CK = 'en_CK'; // English (Cook Islands)
    public const EN_DG = 'en_DG'; // English (Diego Garcia)
    public const EN_DM = 'en_DM'; // English (Dominica)
    public const EN_ER = 'en_ER'; // English (Eritrea)
    public const EN_FK = 'en_FK'; // English (Falkland Islands)
    public const EN_FJ = 'en_FJ'; // English (Fiji)
    public const EN_GM = 'en_GM'; // English (Gambia)
    public const EN_GH = 'en_GH'; // English (Ghana)
    public const EN_GI = 'en_GI'; // English (Gibraltar)
    public const EN_GD = 'en_GD'; // English (Grenada)
    public const EN_GU = 'en_GU'; // English (Guam)
    public const EN_GG = 'en_GG'; // English (Guernsey)
    public const EN_GY = 'en_GY'; // English (Guyana)
    public const EN_HK = 'en_HK'; // English (Hong Kong SAR China)
    public const EN_IN = 'en_IN'; // English (India)
    public const EN_IE = 'en_IE'; // English (Ireland)
    public const EN_IM = 'en_IM'; // English (Isle of Man)
    public const EN_JM = 'en_JM'; // English (Jamaica)
    public const EN_JE = 'en_JE'; // English (Jersey)
    public const EN_KE = 'en_KE'; // English (Kenya)
    public const EN_KI = 'en_KI'; // English (Kiribati)
    public const EN_LS = 'en_LS'; // English (Lesotho)
    public const EN_LR = 'en_LR'; // English (Liberia)
    public const EN_MO = 'en_MO'; // English (Macau SAR China)
    public const EN_MG = 'en_MG'; // English (Madagascar)
    public const EN_MW = 'en_MW'; // English (Malawi)
    public const EN_MY = 'en_MY'; // English (Malaysia)
    public const EN_MT = 'en_MT'; // English (Malta)
    public const EN_MH = 'en_MH'; // English (Marshall Islands)
    public const EN_MU = 'en_MU'; // English (Mauritius)
    public const EN_FM = 'en_FM'; // English (Micronesia)
    public const EN_MS = 'en_MS'; // English (Montserrat)
    public const EN_NA = 'en_NA'; // English (Namibia)
    public const EN_NR = 'en_NR'; // English (Nauru)
    public const EN_NZ = 'en_NZ'; // English (New Zealand)
    public const EN_NG = 'en_NG'; // English (Nigeria)
    public const EN_NU = 'en_NU'; // English (Niue)
    public const EN_NF = 'en_NF'; // English (Norfolk Island)
    public const EN_MP = 'en_MP'; // English (Northern Mariana Islands)
    public const EN_PK = 'en_PK'; // English (Pakistan)
    public const EN_PW = 'en_PW'; // English (Palau)
    public const EN_PG = 'en_PG'; // English (Papua New Guinea)
    public const EN_PH = 'en_PH'; // English (Philippines)
    public const EN_PN = 'en_PN'; // English (Pitcairn Islands)
    public const EN_PR = 'en_PR'; // English (Puerto Rico)
    public const EN_RW = 'en_RW'; // English (Rwanda)
    public const EN_WS = 'en_WS'; // English (Samoa)
    public const EN_SC = 'en_SC'; // English (Seychelles)
    public const EN_SL = 'en_SL'; // English (Sierra Leone)
    public const EN_SG = 'en_SG'; // English (Singapore)
    public const EN_SX = 'en_SX'; // English (Sint Maarten)
    public const EN_SB = 'en_SB'; // English (Solomon Islands)
    public const EN_ZA = 'en_ZA'; // English (South Africa)
    public const EN_SS = 'en_SS'; // English (South Sudan)
    public const EN_SH = 'en_SH'; // English (St. Helena)
    public const EN_KN = 'en_KN'; // English (St. Kitts & Nevis)
    public const EN_LC = 'en_LC'; // English (St. Lucia)
    public const EN_VC = 'en_VC'; // English (St. Vincent & Grenadines)
    public const EN_SD = 'en_SD'; // English (Sudan)
    public const EN_SZ = 'en_SZ'; // English (Swaziland)
    public const EN_TZ = 'en_TZ'; // English (Tanzania)
    public const EN_TK = 'en_TK'; // English (Tokelau)
    public const EN_TO = 'en_TO'; // English (Tonga)
    public const EN_TT = 'en_TT'; // English (Trinidad & Tobago)
    public const EN_TC = 'en_TC'; // English (Turks & Caicos Islands)
    public const EN_TV = 'en_TV'; // English (Tuvalu)
    public const EN_UM = 'en_UM'; // English (U.S. Outlying Islands)
    public const EN_VI = 'en_VI'; // English (U.S. Virgin Islands)
    public const EN_UG = 'en_UG'; // English (Uganda)
    public const EN_GB = 'en_GB'; // English (United Kingdom)
    public const EN_US = 'en_US'; // English (United States)
    public const EN_VU = 'en_VU'; // English (Vanuatu)
    public const EN_ZM = 'en_ZM'; // English (Zambia)
    public const EN_ZW = 'en_ZW'; // English (Zimbabwe)
    public const EO = 'eo'; // Esperanto
    public const ET = 'et'; // Estonian
    public const ET_EE = 'et_EE'; // Estonian (Estonia)
    public const EE = 'ee'; // Ewe
    public const EE_GH = 'ee_GH'; // Ewe (Ghana)
    public const EE_TG = 'ee_TG'; // Ewe (Togo)
    public const FO = 'fo'; // Faroese
    public const FO_FO = 'fo_FO'; // Faroese (Faroe Islands)
    public const FI = 'fi'; // Finnish
    public const FI_FI = 'fi_FI'; // Finnish (Finland)
    public const FR = 'fr'; // French
    public const FR_DZ = 'fr_DZ'; // French (Algeria)
    public const FR_BE = 'fr_BE'; // French (Belgium)
    public const FR_BJ = 'fr_BJ'; // French (Benin)
    public const FR_BF = 'fr_BF'; // French (Burkina Faso)
    public const FR_BI = 'fr_BI'; // French (Burundi)
    public const FR_CM = 'fr_CM'; // French (Cameroon)
    public const FR_CA = 'fr_CA'; // French (Canada)
    public const FR_CF = 'fr_CF'; // French (Central African Republic)
    public const FR_TD = 'fr_TD'; // French (Chad)
    public const FR_KM = 'fr_KM'; // French (Comoros)
    public const FR_CG = 'fr_CG'; // French (Congo - Brazzaville)
    public const FR_CD = 'fr_CD'; // French (Congo - Kinshasa)
    public const FR_CI = 'fr_CI'; // French (Côte d’Ivoire)
    public const FR_DJ = 'fr_DJ'; // French (Djibouti)
    public const FR_GQ = 'fr_GQ'; // French (Equatorial Guinea)
    public const FR_FR = 'fr_FR'; // French (France)
    public const FR_GF = 'fr_GF'; // French (French Guiana)
    public const FR_PF = 'fr_PF'; // French (French Polynesia)
    public const FR_GA = 'fr_GA'; // French (Gabon)
    public const FR_GP = 'fr_GP'; // French (Guadeloupe)
    public const FR_GN = 'fr_GN'; // French (Guinea)
    public const FR_HT = 'fr_HT'; // French (Haiti)
    public const FR_LU = 'fr_LU'; // French (Luxembourg)
    public const FR_MG = 'fr_MG'; // French (Madagascar)
    public const FR_ML = 'fr_ML'; // French (Mali)
    public const FR_MQ = 'fr_MQ'; // French (Martinique)
    public const FR_MR = 'fr_MR'; // French (Mauritania)
    public const FR_MU = 'fr_MU'; // French (Mauritius)
    public const FR_YT = 'fr_YT'; // French (Mayotte)
    public const FR_MC = 'fr_MC'; // French (Monaco)
    public const FR_MA = 'fr_MA'; // French (Morocco)
    public const FR_NC = 'fr_NC'; // French (New Caledonia)
    public const FR_NE = 'fr_NE'; // French (Niger)
    public const FR_RE = 'fr_RE'; // French (Réunion)
    public const FR_RW = 'fr_RW'; // French (Rwanda)
    public const FR_SN = 'fr_SN'; // French (Senegal)
    public const FR_SC = 'fr_SC'; // French (Seychelles)
    public const FR_BL = 'fr_BL'; // French (St. Barthélemy)
    public const FR_MF = 'fr_MF'; // French (St. Martin)
    public const FR_PM = 'fr_PM'; // French (St. Pierre & Miquelon)
    public const FR_CH = 'fr_CH'; // French (Switzerland)
    public const FR_SY = 'fr_SY'; // French (Syria)
    public const FR_TG = 'fr_TG'; // French (Togo)
    public const FR_TN = 'fr_TN'; // French (Tunisia)
    public const FR_VU = 'fr_VU'; // French (Vanuatu)
    public const FR_WF = 'fr_WF'; // French (Wallis & Futuna)
    public const FF = 'ff'; // Fulah
    public const FF_CM = 'ff_CM'; // Fulah (Cameroon)
    public const FF_GN = 'ff_GN'; // Fulah (Guinea)
    public const FF_MR = 'ff_MR'; // Fulah (Mauritania)
    public const FF_SN = 'ff_SN'; // Fulah (Senegal)
    public const GL = 'gl'; // Galician
    public const GL_ES = 'gl_ES'; // Galician (Spain)
    public const LG = 'lg'; // Ganda
    public const LG_UG = 'lg_UG'; // Ganda (Uganda)
    public const KA = 'ka'; // Georgian
    public const KA_GE = 'ka_GE'; // Georgian (Georgia)
    public const DE = 'de'; // German
    public const DE_AT = 'de_AT'; // German (Austria)
    public const DE_BE = 'de_BE'; // German (Belgium)
    public const DE_DE = 'de_DE'; // German (Germany)
    public const DE_LI = 'de_LI'; // German (Liechtenstein)
    public const DE_LU = 'de_LU'; // German (Luxembourg)
    public const DE_CH = 'de_CH'; // German (Switzerland)
    public const EL = 'el'; // Greek
    public const EL_CY = 'el_CY'; // Greek (Cyprus)
    public const EL_GR = 'el_GR'; // Greek (Greece)
    public const GU = 'gu'; // Gujarati
    public const GU_IN = 'gu_IN'; // Gujarati (India)
    public const HA = 'ha'; // Hausa
    public const HA_GH = 'ha_GH'; // Hausa (Ghana)
    public const HA_LATN_GH = 'ha_Latn_GH'; // Hausa (Latin, Ghana)
    public const HA_LATN_NE = 'ha_Latn_NE'; // Hausa (Latin, Niger)
    public const HA_LATN_NG = 'ha_Latn_NG'; // Hausa (Latin, Nigeria)
    public const HA_LATN = 'ha_Latn'; // Hausa (Latin)
    public const HA_NE = 'ha_NE'; // Hausa (Niger)
    public const HA_NG = 'ha_NG'; // Hausa (Nigeria)
    public const HE = 'he'; // Hebrew
    public const HE_IL = 'he_IL'; // Hebrew (Israel)
    public const HI = 'hi'; // Hindi
    public const HI_IN = 'hi_IN'; // Hindi (India)
    public const HU = 'hu'; // Hungarian
    public const HU_HU = 'hu_HU'; // Hungarian (Hungary)
    public const IS = 'is'; // Icelandic
    public const IS_IS = 'is_IS'; // Icelandic (Iceland)
    public const IG = 'ig'; // Igbo
    public const IG_NG = 'ig_NG'; // Igbo (Nigeria)
    public const ID = 'id'; // Indonesian
    public const ID_ID = 'id_ID'; // Indonesian (Indonesia)
    public const GA = 'ga'; // Irish
    public const GA_IE = 'ga_IE'; // Irish (Ireland)
    public const IT = 'it'; // Italian
    public const IT_IT = 'it_IT'; // Italian (Italy)
    public const IT_SM = 'it_SM'; // Italian (San Marino)
    public const IT_CH = 'it_CH'; // Italian (Switzerland)
    public const JA = 'ja'; // Japanese
    public const JA_JP = 'ja_JP'; // Japanese (Japan)
    public const KL = 'kl'; // Kalaallisut
    public const KL_GL = 'kl_GL'; // Kalaallisut (Greenland)
    public const KN = 'kn'; // Kannada
    public const KN_IN = 'kn_IN'; // Kannada (India)
    public const KS = 'ks'; // Kashmiri
    public const KS_ARAB_IN = 'ks_Arab_IN'; // Kashmiri (Arabic, India)
    public const KS_ARAB = 'ks_Arab'; // Kashmiri (Arabic)
    public const KS_IN = 'ks_IN'; // Kashmiri (India)
    public const KK = 'kk'; // Kazakh
    public const KK_CYRL_KZ = 'kk_Cyrl_KZ'; // Kazakh (Cyrillic, Kazakhstan)
    public const KK_CYRL = 'kk_Cyrl'; // Kazakh (Cyrillic)
    public const KK_KZ = 'kk_KZ'; // Kazakh (Kazakhstan)
    public const KM = 'km'; // Khmer
    public const KM_KH = 'km_KH'; // Khmer (Cambodia)
    public const KI = 'ki'; // Kikuyu
    public const KI_KE = 'ki_KE'; // Kikuyu (Kenya)
    public const RW = 'rw'; // Kinyarwanda
    public const RW_RW = 'rw_RW'; // Kinyarwanda (Rwanda)
    public const KO = 'ko'; // Korean
    public const KO_KP = 'ko_KP'; // Korean (North Korea)
    public const KO_KR = 'ko_KR'; // Korean (South Korea)
    public const KY = 'ky'; // Kyrgyz
    public const KY_CYRL_KG = 'ky_Cyrl_KG'; // Kyrgyz (Cyrillic, Kyrgyzstan)
    public const KY_CYRL = 'ky_Cyrl'; // Kyrgyz (Cyrillic)
    public const KY_KG = 'ky_KG'; // Kyrgyz (Kyrgyzstan)
    public const LO = 'lo'; // Lao
    public const LO_LA = 'lo_LA'; // Lao (Laos)
    public const LV = 'lv'; // Latvian
    public const LV_LV = 'lv_LV'; // Latvian (Latvia)
    public const LN = 'ln'; // Lingala
    public const LN_AO = 'ln_AO'; // Lingala (Angola)
    public const LN_CF = 'ln_CF'; // Lingala (Central African Republic)
    public const LN_CG = 'ln_CG'; // Lingala (Congo - Brazzaville)
    public const LN_CD = 'ln_CD'; // Lingala (Congo - Kinshasa)
    public const LT = 'lt'; // Lithuanian
    public const LT_LT = 'lt_LT'; // Lithuanian (Lithuania)
    public const LU = 'lu'; // Luba-Katanga
    public const LU_CD = 'lu_CD'; // Luba-Katanga (Congo - Kinshasa)
    public const LB = 'lb'; // Luxembourgish
    public const LB_LU = 'lb_LU'; // Luxembourgish (Luxembourg)
    public const MK = 'mk'; // Macedonian
    public const MK_MK = 'mk_MK'; // Macedonian (Macedonia)
    public const MG = 'mg'; // Malagasy
    public const MG_MG = 'mg_MG'; // Malagasy (Madagascar)
    public const MS = 'ms'; // Malay
    public const MS_BN = 'ms_BN'; // Malay (Brunei)
    public const MS_LATN_BN = 'ms_Latn_BN'; // Malay (Latin, Brunei)
    public const MS_LATN_MY = 'ms_Latn_MY'; // Malay (Latin, Malaysia)
    public const MS_LATN_SG = 'ms_Latn_SG'; // Malay (Latin, Singapore)
    public const MS_LATN = 'ms_Latn'; // Malay (Latin)
    public const MS_MY = 'ms_MY'; // Malay (Malaysia)
    public const MS_SG = 'ms_SG'; // Malay (Singapore)
    public const ML = 'ml'; // Malayalam
    public const ML_IN = 'ml_IN'; // Malayalam (India)
    public const MT = 'mt'; // Maltese
    public const MT_MT = 'mt_MT'; // Maltese (Malta)
    public const GV = 'gv'; // Manx
    public const GV_IM = 'gv_IM'; // Manx (Isle of Man)
    public const MR = 'mr'; // Marathi
    public const MR_IN = 'mr_IN'; // Marathi (India)
    public const MN = 'mn'; // Mongolian
    public const MN_CYRL_MN = 'mn_Cyrl_MN'; // Mongolian (Cyrillic, Mongolia)
    public const MN_CYRL = 'mn_Cyrl'; // Mongolian (Cyrillic)
    public const MN_MN = 'mn_MN'; // Mongolian (Mongolia)
    public const NE = 'ne'; // Nepali
    public const NE_IN = 'ne_IN'; // Nepali (India)
    public const NE_NP = 'ne_NP'; // Nepali (Nepal)
    public const ND = 'nd'; // North Ndebele
    public const ND_ZW = 'nd_ZW'; // North Ndebele (Zimbabwe)
    public const SE = 'se'; // Northern Sami
    public const SE_FI = 'se_FI'; // Northern Sami (Finland)
    public const SE_NO = 'se_NO'; // Northern Sami (Norway)
    public const SE_SE = 'se_SE'; // Northern Sami (Sweden)
    public const NO = 'no'; // Norwegian
    public const NO_NO = 'no_NO'; // Norwegian (Norway)
    public const NB = 'nb'; // Norwegian Bokmål
    public const NB_NO = 'nb_NO'; // Norwegian Bokmål (Norway)
    public const NB_SJ = 'nb_SJ'; // Norwegian Bokmål (Svalbard & Jan Mayen)
    public const NN = 'nn'; // Norwegian Nynorsk
    public const NN_NO = 'nn_NO'; // Norwegian Nynorsk (Norway)
    public const OR_ = 'or'; // Oriya
    public const OR_IN = 'or_IN'; // Oriya (India)
    public const OM = 'om'; // Oromo
    public const OM_ET = 'om_ET'; // Oromo (Ethiopia)
    public const OM_KE = 'om_KE'; // Oromo (Kenya)
    public const OS = 'os'; // Ossetic
    public const OS_GE = 'os_GE'; // Ossetic (Georgia)
    public const OS_RU = 'os_RU'; // Ossetic (Russia)
    public const PS = 'ps'; // Pashto
    public const PS_AF = 'ps_AF'; // Pashto (Afghanistan)
    public const FA = 'fa'; // Persian
    public const FA_AF = 'fa_AF'; // Persian (Afghanistan)
    public const FA_IR = 'fa_IR'; // Persian (Iran)
    public const PL = 'pl'; // Polish
    public const PL_PL = 'pl_PL'; // Polish (Poland)
    public const PT = 'pt'; // Portuguese
    public const PT_AO = 'pt_AO'; // Portuguese (Angola)
    public const PT_BR = 'pt_BR'; // Portuguese (Brazil)
    public const PT_CV = 'pt_CV'; // Portuguese (Cape Verde)
    public const PT_GW = 'pt_GW'; // Portuguese (Guinea-Bissau)
    public const PT_MO = 'pt_MO'; // Portuguese (Macau SAR China)
    public const PT_MZ = 'pt_MZ'; // Portuguese (Mozambique)
    public const PT_PT = 'pt_PT'; // Portuguese (Portugal)
    public const PT_ST = 'pt_ST'; // Portuguese (São Tomé & Príncipe)
    public const PT_TL = 'pt_TL'; // Portuguese (Timor-Leste)
    public const PA = 'pa'; // Punjabi
    public const PA_ARAB_PK = 'pa_Arab_PK'; // Punjabi (Arabic, Pakistan)
    public const PA_ARAB = 'pa_Arab'; // Punjabi (Arabic)
    public const PA_GURU_IN = 'pa_Guru_IN'; // Punjabi (Gurmukhi, India)
    public const PA_GURU = 'pa_Guru'; // Punjabi (Gurmukhi)
    public const PA_IN = 'pa_IN'; // Punjabi (India)
    public const PA_PK = 'pa_PK'; // Punjabi (Pakistan)
    public const QU = 'qu'; // Quechua
    public const QU_BO = 'qu_BO'; // Quechua (Bolivia)
    public const QU_EC = 'qu_EC'; // Quechua (Ecuador)
    public const QU_PE = 'qu_PE'; // Quechua (Peru)
    public const RO = 'ro'; // Romanian
    public const RO_MD = 'ro_MD'; // Romanian (Moldova)
    public const RO_RO = 'ro_RO'; // Romanian (Romania)
    public const RM = 'rm'; // Romansh
    public const RM_CH = 'rm_CH'; // Romansh (Switzerland)
    public const RN = 'rn'; // Rundi
    public const RN_BI = 'rn_BI'; // Rundi (Burundi)
    public const RU = 'ru'; // Russian
    public const RU_BY = 'ru_BY'; // Russian (Belarus)
    public const RU_KZ = 'ru_KZ'; // Russian (Kazakhstan)
    public const RU_KG = 'ru_KG'; // Russian (Kyrgyzstan)
    public const RU_MD = 'ru_MD'; // Russian (Moldova)
    public const RU_RU = 'ru_RU'; // Russian (Russia)
    public const RU_UA = 'ru_UA'; // Russian (Ukraine)
    public const SG = 'sg'; // Sango
    public const SG_CF = 'sg_CF'; // Sango (Central African Republic)
    public const GD = 'gd'; // Scottish Gaelic
    public const GD_GB = 'gd_GB'; // Scottish Gaelic (United Kingdom)
    public const SR = 'sr'; // Serbian
    public const SR_BA = 'sr_BA'; // Serbian (Bosnia & Herzegovina)
    public const SR_CYRL_BA = 'sr_Cyrl_BA'; // Serbian (Cyrillic, Bosnia & Herzegovina)
    public const SR_CYRL_XK = 'sr_Cyrl_XK'; // Serbian (Cyrillic, Kosovo)
    public const SR_CYRL_ME = 'sr_Cyrl_ME'; // Serbian (Cyrillic, Montenegro)
    public const SR_CYRL_RS = 'sr_Cyrl_RS'; // Serbian (Cyrillic, Serbia)
    public const SR_CYRL = 'sr_Cyrl'; // Serbian (Cyrillic)
    public const SR_XK = 'sr_XK'; // Serbian (Kosovo)
    public const SR_LATN_BA = 'sr_Latn_BA'; // Serbian (Latin, Bosnia & Herzegovina)
    public const SR_LATN_XK = 'sr_Latn_XK'; // Serbian (Latin, Kosovo)
    public const SR_LATN_ME = 'sr_Latn_ME'; // Serbian (Latin, Montenegro)
    public const SR_LATN_RS = 'sr_Latn_RS'; // Serbian (Latin, Serbia)
    public const SR_LATN = 'sr_Latn'; // Serbian (Latin)
    public const SR_ME = 'sr_ME'; // Serbian (Montenegro)
    public const SR_RS = 'sr_RS'; // Serbian (Serbia)
    public const SH = 'sh'; // Serbo-Croatian
    public const SH_BA = 'sh_BA'; // Serbo-Croatian (Bosnia & Herzegovina)
    public const SN = 'sn'; // Shona
    public const SN_ZW = 'sn_ZW'; // Shona (Zimbabwe)
    public const II = 'ii'; // Sichuan Yi
    public const II_CN = 'ii_CN'; // Sichuan Yi (China)
    public const SI = 'si'; // Sinhala
    public const SI_LK = 'si_LK'; // Sinhala (Sri Lanka)
    public const SK = 'sk'; // Slovak
    public const SK_SK = 'sk_SK'; // Slovak (Slovakia)
    public const SL = 'sl'; // Slovenian
    public const SL_SI = 'sl_SI'; // Slovenian (Slovenia)
    public const SO = 'so'; // Somali
    public const SO_DJ = 'so_DJ'; // Somali (Djibouti)
    public const SO_ET = 'so_ET'; // Somali (Ethiopia)
    public const SO_KE = 'so_KE'; // Somali (Kenya)
    public const SO_SO = 'so_SO'; // Somali (Somalia)
    public const ES = 'es'; // Spanish
    public const ES_AR = 'es_AR'; // Spanish (Argentina)
    public const ES_BO = 'es_BO'; // Spanish (Bolivia)
    public const ES_IC = 'es_IC'; // Spanish (Canary Islands)
    public const ES_EA = 'es_EA'; // Spanish (Ceuta & Melilla)
    public const ES_CL = 'es_CL'; // Spanish (Chile)
    public const ES_CO = 'es_CO'; // Spanish (Colombia)
    public const ES_CR = 'es_CR'; // Spanish (Costa Rica)
    public const ES_CU = 'es_CU'; // Spanish (Cuba)
    public const ES_DO = 'es_DO'; // Spanish (Dominican Republic)
    public const ES_EC = 'es_EC'; // Spanish (Ecuador)
    public const ES_SV = 'es_SV'; // Spanish (El Salvador)
    public const ES_GQ = 'es_GQ'; // Spanish (Equatorial Guinea)
    public const ES_GT = 'es_GT'; // Spanish (Guatemala)
    public const ES_HN = 'es_HN'; // Spanish (Honduras)
    public const ES_MX = 'es_MX'; // Spanish (Mexico)
    public const ES_NI = 'es_NI'; // Spanish (Nicaragua)
    public const ES_PA = 'es_PA'; // Spanish (Panama)
    public const ES_PY = 'es_PY'; // Spanish (Paraguay)
    public const ES_PE = 'es_PE'; // Spanish (Peru)
    public const ES_PH = 'es_PH'; // Spanish (Philippines)
    public const ES_PR = 'es_PR'; // Spanish (Puerto Rico)
    public const ES_ES = 'es_ES'; // Spanish (Spain)
    public const ES_US = 'es_US'; // Spanish (United States)
    public const ES_UY = 'es_UY'; // Spanish (Uruguay)
    public const ES_VE = 'es_VE'; // Spanish (Venezuela)
    public const SW = 'sw'; // Swahili
    public const SW_KE = 'sw_KE'; // Swahili (Kenya)
    public const SW_TZ = 'sw_TZ'; // Swahili (Tanzania)
    public const SW_UG = 'sw_UG'; // Swahili (Uganda)
    public const SV = 'sv'; // Swedish
    public const SV_AX = 'sv_AX'; // Swedish (Åland Islands)
    public const SV_FI = 'sv_FI'; // Swedish (Finland)
    public const SV_SE = 'sv_SE'; // Swedish (Sweden)
    public const TL = 'tl'; // Tagalog
    public const TL_PH = 'tl_PH'; // Tagalog (Philippines)
    public const TA = 'ta'; // Tamil
    public const TA_IN = 'ta_IN'; // Tamil (India)
    public const TA_MY = 'ta_MY'; // Tamil (Malaysia)
    public const TA_SG = 'ta_SG'; // Tamil (Singapore)
    public const TA_LK = 'ta_LK'; // Tamil (Sri Lanka)
    public const TE = 'te'; // Telugu
    public const TE_IN = 'te_IN'; // Telugu (India)
    public const TH = 'th'; // Thai
    public const TH_TH = 'th_TH'; // Thai (Thailand)
    public const BO = 'bo'; // Tibetan
    public const BO_CN = 'bo_CN'; // Tibetan (China)
    public const BO_IN = 'bo_IN'; // Tibetan (India)
    public const TI = 'ti'; // Tigrinya
    public const TI_ER = 'ti_ER'; // Tigrinya (Eritrea)
    public const TI_ET = 'ti_ET'; // Tigrinya (Ethiopia)
    public const TO = 'to'; // Tongan
    public const TO_TO = 'to_TO'; // Tongan (Tonga)
    public const TR = 'tr'; // Turkish
    public const TR_CY = 'tr_CY'; // Turkish (Cyprus)
    public const TR_TR = 'tr_TR'; // Turkish (Turkey)
    public const UK = 'uk'; // Ukrainian
    public const UK_UA = 'uk_UA'; // Ukrainian (Ukraine)
    public const UR = 'ur'; // Urdu
    public const UR_IN = 'ur_IN'; // Urdu (India)
    public const UR_PK = 'ur_PK'; // Urdu (Pakistan)
    public const UG = 'ug'; // Uyghur
    public const UG_ARAB_CN = 'ug_Arab_CN'; // Uyghur (Arabic, China)
    public const UG_ARAB = 'ug_Arab'; // Uyghur (Arabic)
    public const UG_CN = 'ug_CN'; // Uyghur (China)
    public const UZ = 'uz'; // Uzbek
    public const UZ_AF = 'uz_AF'; // Uzbek (Afghanistan)
    public const UZ_ARAB_AF = 'uz_Arab_AF'; // Uzbek (Arabic, Afghanistan)
    public const UZ_ARAB = 'uz_Arab'; // Uzbek (Arabic)
    public const UZ_CYRL_UZ = 'uz_Cyrl_UZ'; // Uzbek (Cyrillic, Uzbekistan)
    public const UZ_CYRL = 'uz_Cyrl'; // Uzbek (Cyrillic)
    public const UZ_LATN_UZ = 'uz_Latn_UZ'; // Uzbek (Latin, Uzbekistan)
    public const UZ_LATN = 'uz_Latn'; // Uzbek (Latin)
    public const UZ_UZ = 'uz_UZ'; // Uzbek (Uzbekistan)
    public const VI = 'vi'; // Vietnamese
    public const VI_VN = 'vi_VN'; // Vietnamese (Vietnam)
    public const CY = 'cy'; // Welsh
    public const CY_GB = 'cy_GB'; // Welsh (United Kingdom)
    public const FY = 'fy'; // Western Frisian
    public const FY_NL = 'fy_NL'; // Western Frisian (Netherlands)
    public const YI = 'yi'; // Yiddish
    public const YO = 'yo'; // Yoruba
    public const YO_BJ = 'yo_BJ'; // Yoruba (Benin)
    public const YO_NG = 'yo_NG'; // Yoruba (Nigeria)
    public const ZU = 'zu'; // Zulu
    public const ZU_ZA = 'zu_ZA'; // Zulu (South Africa)
}

/*EOF*/
