<?php

namespace Dealerdirect\Generic\Util\HealthCheck\Request;

use Dealerdirect\Generic\Category\ResponseCode;
use Dealerdirect\Generic\Util\HealthCheck\Response;

class Soap
{
    ////////////////////////////// CLASS PROPERTIES \\\\\\\\\\\\\\\\\\\\\\\\\\\\

    /** @var \nusoap_client */
    private $client;
    /** @var Response\Soap */
    private $response;

    //////////////////////////////// PUBLIC API \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

    final public function __construct(\nusoap_client $client, Response\Soap $response)
    {
        $this->client = $client;
        $this->response = $response;
    }

    final public function call($function)
    {
        $response = $this->callSoap($function);

        /*/ Output response /*/
        $statusCode = $response->getStatusCode();
        $output = $response->createOutput();
        $response = json_decode($output, true);

        if (
            $statusCode === ResponseCode::HTTP_OK
            && is_array($response) === true
            && isset($response['data']['status'])
        ) {
            /* @NOTE: in case of success scenario only the message should be output */
            $output = $response['data']['status'];
        }

        http_response_code($statusCode);

        return $output;
    }

    ////////////////////////////// UTILITY METHODS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\

    /**
     * @param string $function
     *
     * @return Response\Soap
     *
     * @throws \ErrorException
     */
    private function callSoap($function)
    {
        $client = $this->client;
        $response = $this->response;

        /*/ Convert all errors to exceptions /*/
        /** @noinspection MoreThanThreeArgumentsInspection */
        set_error_handler(function ($severity, $message, $file, $line) {
            throw new \ErrorException($message, 0, $severity, $file, $line);
        });

        /*/ Convert any uncaught exceptions to REST message/*/
        set_exception_handler($response->getExceptionHandler($client));

        /*/ Make SOAP call /*/
        try {
            $soapResponse = $client->call($function);
        } catch (\Exception $exception) {
            $soapResponse = $exception;
        }

        /*/ Parse SOAP Response /*/
        $response->buildResponse($client, $soapResponse);

        return $response;
    }
}

/*EOF*/
