<?php

namespace Dealerdirect\Generic\Storage;

class StorageFactory
{
    ////////////////////////////// CLASS PROPERTIES \\\\\\\\\\\\\\\\\\\\\\\\\\\\

    const ERROR_ENV_NOT_SET = 'The storage location "%s" has not been set in the environment';
    const ERROR_NOT_CREATED = 'Could not create %s for "%s" ';
    const ERROR_WRONG_CLASS = 'Given class "%s" MUST extend "%s"';

    /** @var string */
    private $class;
    /** @var string */
    private $envKey;

    //////////////////////////////// PUBLIC API \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

    final public static function getInstance($class, $envKey)
    {
        $instance = new self($class, $envKey);

        return $instance->create();
    }

    final public function __construct($class, $envKey)
    {
        $parent = '\Dealerdirect\Generic\Storage\AbstractStorage';

        if (is_subclass_of($class, $parent) === false) {
            $message = sprintf(
                self::ERROR_WRONG_CLASS,
                $class,
                $parent
            );
            throw new \InvalidArgumentException($message);
        }

        $this->class = $class;
        $this->envKey = $envKey;
    }

    final public function create()
    {
        $error = '';
        $filesystem = null;

        $location = getenv($this->envKey);

        if ($location === false) {
            $error = sprintf(self::ERROR_ENV_NOT_SET, $this->envKey);
        } else {
            try {
                $filesystem = \MJRider\FlysystemFactory\create($location);
            } catch (\Exception $exception) {
            }

            if ($filesystem === null) {
                $error = sprintf(self::ERROR_NOT_CREATED, 'file-system', $location);

                if (isset($exception)) {
                    $error = $exception->getMessage();
                }
            }
        }

        $class = $this->class;

        $instance = new $class($filesystem);

        $this->logError($error);

        return $instance;
    }

    ////////////////////////////// UTILITY METHODS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\

    /**
     * @param string $error
     *
     * @return bool
     */
    private function logError($error)
    {
        $result = true;

        if ($error !== '') {
            $result = error_log($error);
        }

        return $result;
    }
}

/*EOF*/
