<?php

namespace Dealerdirect\Generic\Util\HealthCheck;

class SoapClientFactory
{
    ////////////////////////////// CLASS PROPERTIES \\\\\\\\\\\\\\\\\\\\\\\\\\\\

    /** @var array */
    private $environment;
    /** @var string */
    private $path;

    //////////////////////////////// PUBLIC API \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

    /**
     * @param array $environment
     * @param string $path
     */
    public function __construct(array $environment, $path)
    {
        $this->environment = $environment;
        $this->path = $path;
    }

    /**
     * @return \nusoap_client
     */
    public function create()
    {
        $endpoint = $this->createEndpoint();

        $client = new \nusoap_client($endpoint, false);

        /* @NOTE: A persistent connection is needed so the HTTP Status Code can be retrieved */
        $client->persistentConnection = true;

        return $client;
    }

    ////////////////////////////// UTILITY METHODS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\

    /**
     * @return string
     */
    private function createEndpoint()
    {
        $environment = $this->environment;

        $server = $this->getServerFromEnvironment($environment);

        return 'https://' . $server . '/' . $this->path;
    }

    /**
     * @param $environment
     *
     * @return string
     */
    private function getServerFromEnvironment($environment)
    {
        $server = 'localhost';

        /* @NOTE: Keys are in reverse, that is to say, the last key wins */
        $keys = [
            'SERVER_NAME',
            'HTTP_HOST',
        ];

        array_walk($keys, function ($key) use (&$server, $environment) {
            if (array_key_exists($key, $environment) === true) {
                $server = $environment[$key];
            }
        });

        return $server;
    }
}
