<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\Category\Territory;
use DealerDirect\Generic\Category\Locale;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Repository;

/**
 * Immutable class to hold values of generic properties
 */
final class GenericProperties implements Repository
{
    /** @var string */
    private $country;
    /** @var string */
    private $locale;
    /** @var string */
    private $vehicleType;

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @return string
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * @return string
     */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }

    /**
     * Instantiate a GenericProperties object based on Category values
     *
     * @param string $country
     * @param string $vehicleType
     * @param string $locale
     *
     * @throws \InvalidArgumentException
     */
    final public function __construct($country, $vehicleType, $locale = '')
    {
        Territory::assertExists($country);
        VehicleType::assertExists($vehicleType);

        $this->country = (string) $country;
        $this->vehicleType = (string) $vehicleType;

        $locale = (string) $locale;
        if ($locale !== '') {
            Locale::assertExists($locale);
            $this->locale = $locale;
        }
    }
}

/*EOF*/
