<?php

namespace DealerDirect\Generic;

/**
 * Interface for classes that should function purely as Data-Container/Immutable object
 *
 * This root class exists so that container classes can be easily found and
 * tested for undesired behaviour.
 *
 * Any data-container/immutable object should adhere to the following pattern:
 *
 * - The class exist purely of a constructor, properties and getter method(s)
 * - The properties can _only_ be set through the constructor, using one parameter per property
 * - There is a getter for each property
 * - Other than (simple) validation of constructor parameters there is _no_ logic
 */
interface Repository {}

/*EOF*/
