<?php

namespace DealerDirect\Generic\Category;

use PHPUnit\Framework\TestCase;
use DealerDirect\Generic\Repository\Locale;
use DealerDirect\Generic\Repository\GenericProperties;
use DealerDirect\Generic\Repository\Translator;
use ReflectionClass;

/**
 * Class VehicleTypeOptionsTest
 *
 * @uses \DealerDirect\Generic\Category\AbstractEnum
 * @uses \DealerDirect\Generic\Repository\GenericProperties
 * @uses \DealerDirect\Generic\Repository\Locale
 */
class VehicleTypeOptionsTest extends TestCase
{
    /**
     * @covers \DealerDirect\Generic\Category\VehicleTypeCarOptions
     */
    public function testUniqueVehicleTypeCarIds()
    {
        $carReflection = new ReflectionClass('DealerDirect\\Generic\\Category\\VehicleTypeCarOptions');
        foreach (array_count_values($carReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }

    /**
     * @covers \DealerDirect\Generic\Category\VehicleTypeMotorOptions
     */
    public function testUniqueVehicleTypeMotorIds()
    {
        $motorReflection = new ReflectionClass('DealerDirect\\Generic\\Category\\VehicleTypeMotorOptions');
        foreach (array_count_values($motorReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }

    /**
     * @covers \DealerDirect\Generic\Category\VehicleTypeRecreationalOptions
     */
    public function testUniqueVehicleTypeRecreationalIds()
    {
        $recreationalReflection = new ReflectionClass(
            'DealerDirect\\Generic\\Category\\VehicleTypeRecreationalOptions'
        );
        foreach (array_count_values($recreationalReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }

    /**
     * @covers \DealerDirect\Generic\Repository\Translator
     * @covers \DealerDirect\Generic\Repository\CommonTranslator
     * @covers \DealerDirect\Generic\Repository\CommonTranslator::getTranslations()
     * @covers \DealerDirect\Generic\Repository\CommonTranslator::loadTranslations()
     */
    public function testGermanAircoTranslation()
    {
        $locale = new Locale(Language::DE, Territory::DE);
        $genericProperties = new GenericProperties($locale, VehicleType::CAR);
        $translator = new Translator($genericProperties);
        $translatedValues = $translator->get(TranslationTypes::OPTIONS, [
            VehicleTypeCarOptions::AIRCO,
        ]);
        $this->assertEquals($translatedValues[0], "Klimaanlage");
    }

    /**
     * @covers \DealerDirect\Generic\Repository\Translator
     * @covers \DealerDirect\Generic\Repository\CommonTranslator
     * @covers \DealerDirect\Generic\Repository\CommonTranslator::getTranslations()
     * @covers \DealerDirect\Generic\Repository\CommonTranslator::loadTranslations()
     */
    public function testWrongTranslationTranslation()
    {
        $locale = new Locale(Language::DE, Territory::DE);
        $genericProperties = new GenericProperties($locale, VehicleType::CAR);
        $translator = new Translator($genericProperties);
        $translatedValues = $translator->get(TranslationTypes::OPTIONS, [
            'wrong_value',
        ]);
        $this->assertEquals($translatedValues[0], "Unbekannt");
    }
}
