<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\RepositoryInterface;

/**
 * Immutable object holding the value of credentials (username/password combination).
 */
class Credentials implements RepositoryInterface
{
    ////////////////////////////// CLASS PROPERTIES \\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /** @var string */
    private $username;
    /** @var string */
    private $password;

    //////////////////////////// SETTERS AND GETTERS \\\\\\\\\\\\\\\\\\\\\\\\\\\
    /** @return string */
    final public function getUsername()
    {
        return $this->username;
    }

    /** @return string */
    final public function getPassword()
    {
        return $this->password;
    }

    //////////////////////////////// PUBLIC API \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /**
     * @param string $username
     * @param string $password
     */
    final public function __construct($username, $password)
    {
        $this->username = (string) $username;
        $this->password = (string) $password;
    }
}

/*EOF*/
