<?php

namespace DealerDirect\Generic\Category;

/**
 * Full country names for ISO 3166-1 alpha-2 territory codes.
 *
 * Please note that hard-coded values (those not using the `Territory` class)
 * are not supported (i.e. no consumer- or dealer-site is available).
 */
class CountryTerritoryCode extends AbstractEnum
{
    public const AUSTRIA = 'AT';
    public const BELGIUM = Territory::BE;
    public const BULGARIA = 'BG';
    public const CROATIA = 'HR';
    public const CYPRUS = 'CY';
    public const CZECH_REPUBLIC = 'CZ';
    public const DENMARK = 'DK';
    public const ESTONIA = 'EE';
    public const FINLAND = 'FI';
    public const FRANCE = Territory::FR;
    public const GERMANY = Territory::DE;
    public const GREECE = 'GR';
    public const HUNGARY = 'HU';
    public const IRELAND = 'IE';
    public const ITALY = 'IT';
    public const LATVIA = 'LV';
    public const LITHUANIA = 'LT';
    public const LUXEMBOURG = 'LU';
    public const NETHERLANDS = Territory::NL;
    public const NORWAY = 'NO';
    public const POLAND = 'PL';
    public const PORTUGAL = 'PT';
    public const ROMANIA = 'RO';
    public const SLOVAKIA = 'SK';
    public const SLOVENIA = 'SI';
    public const SPAIN = 'ES';
    public const SWEDEN = Territory::SE;
    public const SWITZERLAND = 'CH';
}
