<?php

namespace Dealerdirect\Pricing;

class Vehicle
{
    public const BRAND_ID = 'brandId';
    public const MODEL_ID = 'modelId';
    public const BRAND = 'brand';
    public const MODEL = 'model';
    public const TYPE = 'vehicleType';
    public const CONSTRUCTION_YEAR = 'constructionYear';
    public const POWER = 'power';
    public const FUEL = 'fuelType';
    public const ENGINE_CAPACITY = 'engineCapacity';
    public const LICENSE_PLATE = 'licensePlate';

    private $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function get($key)
    {
        return $this->data[$key] ?? null;
    }

    public function toArray()
    {
        return $this->data;
    }
}
