<?php

namespace Dealerdirect\Pricing\Tests\Feature;

// use Dealerdirect\BusinessLogic\Actions\GetPricingData;
// use Dealerdirect\BusinessLogic\Jobs\Pricing;
// use Dealerdirect\BusinessLogic\Models\Lot;
// use Dealerdirect\BusinessLogic\Models\Person;
// use Dealerdirect\BusinessLogic\Models\Vehicle;
// use Dealerdirect\BusinessLogic\Models\VehicleValue;
// use Dealerdirect\BusinessLogic\Pricing\Providers\BidHistoryProvider;
// use Dealerdirect\BusinessLogic\Pricing\Providers\DataWorks4YouProvider;
// use Dealerdirect\Pricing\Tests\TestCase;
// use Illuminate\Foundation\Testing\WithFaker;
// use Illuminate\Support\Facades\DB;

// class PricingTest extends TestCase
// {
//     use WithFaker;

//     /**
//      * @covers GetPricingData
//      */
//     public function testGetPricingDataAction()
//     {
//         Person::factory()->count(3)->has(
//             Lot::factory()->state(['state' => 'submission'])
//                 ->has(
//                     Vehicle::factory()->sequence(
//                         fn () => ['type' => 'scooter'],
//                         fn () => ['type' => 'motorbike'],
//                         fn () => ['type' => 'car'],
//                     )->has(
//                         VehicleValue::factory()->count(2)->sequence(
//                             fn() => ['name' => (new BidHistoryProvider())->getName()],
//                             fn() => ['name' => (new DataWorks4YouProvider())->getName()],
//                         )
//                     )
//                 )
//         )->create();

//         $action = new GetPricingData();
//         $actual = $action();

//         $this->assertArrayHasKey('sources', $actual);
//         $this->assertArrayHasKey((new BidHistoryProvider())->getName(), $actual['sources']);
//         $this->assertArrayHasKey((new DataWorks4YouProvider())->getName(), $actual['sources']);
//     }

//     /**
//      * @covers Pricing
//      */
//     public function testJob()
//     {
//         Person::factory()->count(3)->has(
//             Lot::factory()->state(['state' => 'submission'])
//                 ->has(
//                     Vehicle::factory()->car()->state([
//                         'data' => [
//                             'power' => $this->faker->numberBetween(80, 200),
//                             'engine_capacity' => $this->faker->numberBetween(800, 4000),
//                         ]
//                     ])
//                 )
//         )->create();


//         DB::shouldReceive('select')->andReturn(
//             $this->getBidHistoryData(
//                 $this->faker->numberBetween(2, 50)
//             )
//         );

//         Pricing::dispatch();

//         $actual = VehicleValue::all();
//         $this->assertCount(3, $actual);

//         // $this->assertDatabaseCount(VehicleValue::TABLE, 3);
//     }

//     private function getBidHistoryData(int $num): array
//     {
//         $data = [];
//         for ($i = 0; $i < $num; $i++) {
//             $data[] = (object) [
//                 'bid' => $this->faker->randomNumber(5),
//                 'dealer_id' => $this->faker->randomNumber(6),
//                 'bid_date' => $this->faker->dateTimeBetween('- 1 year'),
//                 'lot_id' => $this->faker->randomNumber(6),
//             ];
//         }

//         return $data;
//     }
// }
