<?php

namespace Dealerdirect\Pricing\Tests;

use Dealerdirect\Pricing\PricingServiceProvider;

class TestCase extends \Orchestra\Testbench\TestCase
{
    // use DatabaseTransactions;

    // protected $connectionsToTransact = ['mysql'];

    protected function getPackageProviders($app)
    {
        return [
            PricingServiceProvider::class,
        ];
    }

    protected function getEnvironmentSetup($app)
    {
        $app['config']->set('pricing.JPCars.token', 'fake_token');
        $app['config']->set('database.default', 'legacy');
        $app['config']->set('database.connections.legacy', [
            'driver' => 'mysql',
            'host' => $_ENV['DEALERDIRECT_DATABASE_MAIN_HOST'] ?? 'aio.test',
            'database' => $_ENV['DEALERDIRECT_DATABASE_MAIN_DATABASE'] ?? 'dealer01_ddmain',
            'username' => $_ENV['DEALERDIRECT_DATABASE_MAIN_USER'] ?? 'vagrant',
            'password' => $_ENV['DEALERDIRECT_DATABASE_MAIN_PASSWORD'] ?? 'vagrant',
            'charset' => 'utf8',
            'collation' => 'utf8_unicode_ci',
            'prefix' => '',
        ]);
    }

    protected function getApplicationTimezone($app)
    {
        return 'Europe/Amsterdam';
    }
}
