<?php

namespace Dealerdirect\Pricing\Providers;

use Dealerdirect\Pricing\Providers\Provider;
use Dealerdirect\Pricing\Vehicle;
use Dealerdirect\Generic\Category\VehicleType;
use Illuminate\Validation\Rule;

class ExampleProvider extends Provider
{
    public function getName(): string
    {
        return 'Test';
    }

    public function getRequirements(): array
    {
        return [
            Vehicle::LICENSE_PLATE => ['required', 'string'],
            Vehicle::TYPE => ['required', 'string', Rule::in([
                VehicleType::CAR,
                VehicleType::CAMPER,
                VehicleType::CARAVAN,
            ])],
        ];
    }

    public function __invoke(Vehicle $vehicle): array
    {
        return [
            'average' => 2000,
            'min' => 1000, // Lowest bid found in bidhistory
            'max' => 3000, // Highest bid found in bidhistory
            'num' => 2, // Number of total bids found
            // Perhaps add some data concerning age of bids
        ];
    }

    public function isEnabled(): bool
    {
        return false;
    }

    public function isReadOnly(): bool
    {
        return true;
    }

    public function formatRawData(array $rawData, array $translations): array
    {
        return $rawData;
    }
}
