<?php

namespace Dealerdirect\Pricing;

class Vehicle
{
    public const BODY_TYPE = 'bodyType';
    public const BRAND = 'brand';
    public const BRAND_ID = 'brandId';
    public const CONSTRUCTION_YEAR = 'constructionYear';
    public const ENGINE_CAPACITY = 'engineCapacity';
    public const FUEL = 'fuelType';
    public const LICENSE_PLATE = 'licensePlate';
    public const MODEL = 'model';
    public const MODEL_ID = 'modelId';
    public const POWER = 'power';
    public const TYPE = 'vehicleType';

    private $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function get($key)
    {
        return $this->data[$key] ?? null;
    }

    public function toArray()
    {
        return $this->data;
    }
}
