<?php

namespace Dealerdirect\Pricing\Tests\Unit;

use Dealerdirect\Pricing\Tests\TestCase;
use Dealerdirect\Pricing\Vehicle;
use Exception;

/**
 * @covers Vehicle
 */
class VehicleTest extends TestCase
{
    public function testVehicleWithInvalidDataShouldThrowExceptionWithExpectedMessage()
    {
        $this->expectException(Exception::class);
        $this->expectExceptionMessage('Error, invalid data in pricing Vehicle');

        new Vehicle([
            Vehicle::BRAND => 1234,
        ]);
    }

    public function testVehicleWithNonExistingKeyShouldNotAddItToTheData()
    {
        $expected = [Vehicle::BRAND => 'Brand name'];
        $actual = (new Vehicle([
            Vehicle::BRAND => 'Brand name',
            'unkown-key' => 'Some value',
        ]))->toArray();

        $this->assertEquals($expected, $actual);
    }

    public function testVehicleHasShouldReturnFalseOnNullValues()
    {
        $expected = false;

        $vehicle = new Vehicle([Vehicle::BRAND => null]);
        $actual = $vehicle->has(Vehicle::BRAND);

        $this->assertEquals($expected, $actual);
    }

    public function testVehicleHasShouldReturnTrueOnZeroValues()
    {
        $expected = true;

        $vehicle = new Vehicle([Vehicle::BRAND_ID => 0]);
        $actual = $vehicle->has(Vehicle::BRAND_ID);

        $this->assertEquals($expected, $actual);
    }
}
