<?php

namespace Dealerdirect\Pricing;

class Vehicle
{
    public const BODY_TYPE = 'bodyType';
    public const BRAND = 'brand';
    public const BRAND_ID = 'brandId';
    public const CALLGROUP_ID = 'callgroupId';
    public const CONSTRUCTION_YEAR = 'constructionYear';
    public const COUNTRY_CODE = 'countryCode';
    public const ENGINE_CAPACITY = 'engineCapacity';
    public const FUEL = 'fuelType';
    public const LICENSE_PLATE = 'licensePlate';
    public const MODEL = 'model';
    public const MODEL_ID = 'modelId';
    public const NUMBER_OF_DOORS = 'numberOfDoors';
    public const NUMBER_OF_SEATS = 'numberOfSeats';
    public const ODOMETER = 'odometer';
    public const POWER = 'power';
    public const TRANSMISSION = 'transmission';
    public const TRIM = 'trim';
    public const TYPE = 'vehicleType';
    public const WHEEL_DRIVE = 'wheelDrive';

    private $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function get($key, $default = null)
    {
        return $this->data[$key] ?? $default;
    }

    public function toArray()
    {
        return $this->data;
    }
}
