<?php

namespace Dealerdirect\Pricing\Exceptions;

use Exception;

class JPCarsException extends Exception
{
    public const VALUATION_MIN_BUILD_ERROR_CODE = 1;

    public function __construct(
        int $statusCode,
        string $reason,
        ?string $error = null,
        ?string $errorMessage = null
    ) {
        $message = 'Request failed for JPCars pricing. Response code: "%d", Reason: "%s"';
        $params = [$statusCode, $reason];

        if (!empty($error)) {
            $message .= ' and error message: [%s] "%s"';
            array_push($params, $error, $errorMessage ?? '');

            if ($error === 'ERROR_VALUATION_MIN_BUILD') {
                $this->code = self::VALUATION_MIN_BUILD_ERROR_CODE;
            }
        }

        $this->message = vsprintf($message, $params);
    }
}
