<?php

namespace Dealerdirect\Pricing\Exceptions;

use Exception;

class JPCarsException extends Exception
{
    public const VALUATION_MIN_BUILD_ERROR_CODE = 1;
    public const VALUATION_NO_PRICING_ERROR_CODE = 2;
    public const VALUATION_MODEL_ERROR_CODE = 3;

    public function __construct(
        int $statusCode,
        string $reason,
        private ?string $error = null,
        ?string $errorMessage = null
    ) {
        $message = 'Request failed for JPCars pricing. Response code: "%d", Reason: "%s"';
        $params = [$statusCode, $reason];

        if (!empty($error)) {
            $message .= ' and error message: [%s] "%s"';
            array_push($params, $error, $errorMessage ?? '');

            $this->code = match ($error) {
                'ERROR_VALUATION_MIN_BUILD' => self::VALUATION_MIN_BUILD_ERROR_CODE,
                'NO_PRICING' => self::VALUATION_NO_PRICING_ERROR_CODE,
                'ERROR_VALUATION_MODEL' => self::VALUATION_MODEL_ERROR_CODE,
                default => 0,
            };
        }

        $this->message = vsprintf($message, $params);
    }

    public function getError(): ?string
    {
        return $this->error;
    }
}
