<?php

/**
 * AddShiftTradeRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AddShiftTradeRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AddShiftTradeRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AddShiftTradeRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'scheduleId' => 'string',
        'initiatingShiftId' => 'string',
        'receivingUserId' => 'string',
        'expiration' => '\DateTime',
        'acceptableIntervals' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'scheduleId' => 'scheduleId',
        'initiatingShiftId' => 'initiatingShiftId',
        'receivingUserId' => 'receivingUserId',
        'expiration' => 'expiration',
        'acceptableIntervals' => 'acceptableIntervals'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'scheduleId' => 'setScheduleId',
        'initiatingShiftId' => 'setInitiatingShiftId',
        'receivingUserId' => 'setReceivingUserId',
        'expiration' => 'setExpiration',
        'acceptableIntervals' => 'setAcceptableIntervals'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'scheduleId' => 'getScheduleId',
        'initiatingShiftId' => 'getInitiatingShiftId',
        'receivingUserId' => 'getReceivingUserId',
        'expiration' => 'getExpiration',
        'acceptableIntervals' => 'getAcceptableIntervals'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['scheduleId'] = isset($data['scheduleId']) ? $data['scheduleId'] : null;
        $this->container['initiatingShiftId'] = isset($data['initiatingShiftId']) ? $data['initiatingShiftId'] : null;
        $this->container['receivingUserId'] = isset($data['receivingUserId']) ? $data['receivingUserId'] : null;
        $this->container['expiration'] = isset($data['expiration']) ? $data['expiration'] : null;
        $this->container['acceptableIntervals'] = isset($data['acceptableIntervals']) ? $data['acceptableIntervals'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['scheduleId'] === null) {
            $invalid_properties[] = "'scheduleId' can't be null";
        }
        if ($this->container['initiatingShiftId'] === null) {
            $invalid_properties[] = "'initiatingShiftId' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['scheduleId'] === null) {
            return false;
        }
        if ($this->container['initiatingShiftId'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets scheduleId
     * @return string
     */
    public function getScheduleId()
    {
        return $this->container['scheduleId'];
    }

    /**
     * Sets scheduleId
     * @param string $scheduleId The ID of the schedule to which the initiating and receiving shifts belong
     * @return $this
     */
    public function setScheduleId($scheduleId)
    {
        $this->container['scheduleId'] = $scheduleId;

        return $this;
    }

    /**
     * Gets initiatingShiftId
     * @return string
     */
    public function getInitiatingShiftId()
    {
        return $this->container['initiatingShiftId'];
    }

    /**
     * Sets initiatingShiftId
     * @param string $initiatingShiftId The ID of the shift that the initiating user wants to give up
     * @return $this
     */
    public function setInitiatingShiftId($initiatingShiftId)
    {
        $this->container['initiatingShiftId'] = $initiatingShiftId;

        return $this;
    }

    /**
     * Gets receivingUserId
     * @return string
     */
    public function getReceivingUserId()
    {
        return $this->container['receivingUserId'];
    }

    /**
     * Sets receivingUserId
     * @param string $receivingUserId The ID of the user to whom to send the request (for use in direct trade requests)
     * @return $this
     */
    public function setReceivingUserId($receivingUserId)
    {
        $this->container['receivingUserId'] = $receivingUserId;

        return $this;
    }

    /**
     * Gets expiration
     * @return \DateTime
     */
    public function getExpiration()
    {
        return $this->container['expiration'];
    }

    /**
     * Sets expiration
     * @param \DateTime $expiration When this shift trade request should expire. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExpiration($expiration)
    {
        $this->container['expiration'] = $expiration;

        return $this;
    }

    /**
     * Gets acceptableIntervals
     * @return string[]
     */
    public function getAcceptableIntervals()
    {
        return $this->container['acceptableIntervals'];
    }

    /**
     * Sets acceptableIntervals
     * @param string[] $acceptableIntervals
     * @return $this
     */
    public function setAcceptableIntervals($acceptableIntervals)
    {
        $this->container['acceptableIntervals'] = $acceptableIntervals;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
