<?php

/**
 * LanguageUnderstandingApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use PureCloudSDK\Configuration;
use PureCloudSDK\ApiClient;
use PureCloudSDK\ApiException;
use PureCloudSDK\ObjectSerializer;

/**
 * LanguageUnderstandingApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class LanguageUnderstandingApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return LanguageUnderstandingApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteLanguageunderstandingDomain
     *
     * Delete an NLU Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteLanguageunderstandingDomain($domainId)
    {
        list($response) = $this->deleteLanguageunderstandingDomainWithHttpInfo($domainId);
        return $response;
    }

    /**
     * Operation deleteLanguageunderstandingDomainWithHttpInfo
     *
     * Delete an NLU Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteLanguageunderstandingDomainWithHttpInfo($domainId)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling deleteLanguageunderstandingDomain');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/languageunderstanding/domains/{domainId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteLanguageunderstandingDomainFeedbackFeedbackId
     *
     * Delete the feedback on the NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $feedbackId ID of the Feedback (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteLanguageunderstandingDomainFeedbackFeedbackId($domainId, $feedbackId)
    {
        list($response) = $this->deleteLanguageunderstandingDomainFeedbackFeedbackIdWithHttpInfo($domainId, $feedbackId);
        return $response;
    }

    /**
     * Operation deleteLanguageunderstandingDomainFeedbackFeedbackIdWithHttpInfo
     *
     * Delete the feedback on the NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $feedbackId ID of the Feedback (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteLanguageunderstandingDomainFeedbackFeedbackIdWithHttpInfo($domainId, $feedbackId)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling deleteLanguageunderstandingDomainFeedbackFeedbackId');
        }
        // verify the required parameter 'feedbackId' is set
        if ($feedbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $feedbackId when calling deleteLanguageunderstandingDomainFeedbackFeedbackId');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/feedback/{feedbackId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($feedbackId !== null) {
            $resourcePath = str_replace(
                "{" . "feedbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($feedbackId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/languageunderstanding/domains/{domainId}/feedback/{feedbackId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteLanguageunderstandingDomainVersion
     *
     * Delete an NLU Domain Version
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteLanguageunderstandingDomainVersion($domainId, $domainVersionId)
    {
        list($response) = $this->deleteLanguageunderstandingDomainVersionWithHttpInfo($domainId, $domainVersionId);
        return $response;
    }

    /**
     * Operation deleteLanguageunderstandingDomainVersionWithHttpInfo
     *
     * Delete an NLU Domain Version
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteLanguageunderstandingDomainVersionWithHttpInfo($domainId, $domainVersionId)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling deleteLanguageunderstandingDomainVersion');
        }
        // verify the required parameter 'domainVersionId' is set
        if ($domainVersionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainVersionId when calling deleteLanguageunderstandingDomainVersion');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($domainVersionId !== null) {
            $resourcePath = str_replace(
                "{" . "domainVersionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainVersionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLanguageunderstandingDomain
     *
     * Find an NLU Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @return \PureCloudSDK\NluDomain
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomain($domainId)
    {
        list($response) = $this->getLanguageunderstandingDomainWithHttpInfo($domainId);
        return $response;
    }

    /**
     * Operation getLanguageunderstandingDomainWithHttpInfo
     *
     * Find an NLU Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @return Array of \PureCloudSDK\NluDomain, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainWithHttpInfo($domainId)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling getLanguageunderstandingDomain');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomain',
                '/api/v2/languageunderstanding/domains/{domainId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomain', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomain', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLanguageunderstandingDomainFeedback
     *
     * Get all feedback in the given NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $intentName The top intent name to retrieve feedback for. (optional)
     * @param string $assessment The top assessment to retrieve feedback for. (optional)
     * @param \DateTime $dateStart Begin of time window as ISO-8601 date. (optional)
     * @param \DateTime $dateEnd End of time window as ISO-8601 date. (optional)
     * @param bool $includeDeleted Whether to include soft-deleted items in the result. (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string[] $fields Fields and properties to get, comma-separated (optional)
     * @return \PureCloudSDK\NluFeedbackListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainFeedback($domainId, $intentName = null, $assessment = null, $dateStart = null, $dateEnd = null, $includeDeleted = null, $pageNumber = null, $pageSize = null, $fields = null)
    {
        list($response) = $this->getLanguageunderstandingDomainFeedbackWithHttpInfo($domainId, $intentName, $assessment, $dateStart, $dateEnd, $includeDeleted, $pageNumber, $pageSize, $fields);
        return $response;
    }

    /**
     * Operation getLanguageunderstandingDomainFeedbackWithHttpInfo
     *
     * Get all feedback in the given NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $intentName The top intent name to retrieve feedback for. (optional)
     * @param string $assessment The top assessment to retrieve feedback for. (optional)
     * @param \DateTime $dateStart Begin of time window as ISO-8601 date. (optional)
     * @param \DateTime $dateEnd End of time window as ISO-8601 date. (optional)
     * @param bool $includeDeleted Whether to include soft-deleted items in the result. (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string[] $fields Fields and properties to get, comma-separated (optional)
     * @return Array of \PureCloudSDK\NluFeedbackListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainFeedbackWithHttpInfo($domainId, $intentName = null, $assessment = null, $dateStart = null, $dateEnd = null, $includeDeleted = null, $pageNumber = null, $pageSize = null, $fields = null)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling getLanguageunderstandingDomainFeedback');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/feedback";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($intentName !== null) {
            $queryParams['intentName'] = $this->apiClient->getSerializer()->toQueryValue($intentName);
        }
        // query params
        if ($assessment !== null) {
            $queryParams['assessment'] = $this->apiClient->getSerializer()->toQueryValue($assessment);
        }
        // query params
        if ($dateStart !== null) {
            $queryParams['dateStart'] = $this->apiClient->getSerializer()->toQueryValue($dateStart);
        }
        // query params
        if ($dateEnd !== null) {
            $queryParams['dateEnd'] = $this->apiClient->getSerializer()->toQueryValue($dateEnd);
        }
        // query params
        if ($includeDeleted !== null) {
            $queryParams['includeDeleted'] = $this->apiClient->getSerializer()->toQueryValue($includeDeleted);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if (is_array($fields)) {
            $fields = $this->apiClient->getSerializer()->serializeCollection($fields, 'multi', true);
        }
        if ($fields !== null) {
            $queryParams['fields'] = $this->apiClient->getSerializer()->toQueryValue($fields);
        }
        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluFeedbackListing',
                '/api/v2/languageunderstanding/domains/{domainId}/feedback'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluFeedbackListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluFeedbackListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLanguageunderstandingDomainFeedbackFeedbackId
     *
     * Find a Feedback
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $feedbackId ID of the Feedback (required)
     * @param string[] $fields Fields and properties to get, comma-separated (optional)
     * @return \PureCloudSDK\NluFeedbackResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainFeedbackFeedbackId($domainId, $feedbackId, $fields = null)
    {
        list($response) = $this->getLanguageunderstandingDomainFeedbackFeedbackIdWithHttpInfo($domainId, $feedbackId, $fields);
        return $response;
    }

    /**
     * Operation getLanguageunderstandingDomainFeedbackFeedbackIdWithHttpInfo
     *
     * Find a Feedback
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $feedbackId ID of the Feedback (required)
     * @param string[] $fields Fields and properties to get, comma-separated (optional)
     * @return Array of \PureCloudSDK\NluFeedbackResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainFeedbackFeedbackIdWithHttpInfo($domainId, $feedbackId, $fields = null)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling getLanguageunderstandingDomainFeedbackFeedbackId');
        }
        // verify the required parameter 'feedbackId' is set
        if ($feedbackId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $feedbackId when calling getLanguageunderstandingDomainFeedbackFeedbackId');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/feedback/{feedbackId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($fields)) {
            $fields = $this->apiClient->getSerializer()->serializeCollection($fields, 'multi', true);
        }
        if ($fields !== null) {
            $queryParams['fields'] = $this->apiClient->getSerializer()->toQueryValue($fields);
        }
        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($feedbackId !== null) {
            $resourcePath = str_replace(
                "{" . "feedbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($feedbackId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluFeedbackResponse',
                '/api/v2/languageunderstanding/domains/{domainId}/feedback/{feedbackId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluFeedbackResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluFeedbackResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLanguageunderstandingDomainVersion
     *
     * Find an NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @param bool $includeUtterances Whether utterances for intent definition should be included when marshalling response. (optional)
     * @return \PureCloudSDK\NluDomainVersion
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainVersion($domainId, $domainVersionId, $includeUtterances = null)
    {
        list($response) = $this->getLanguageunderstandingDomainVersionWithHttpInfo($domainId, $domainVersionId, $includeUtterances);
        return $response;
    }

    /**
     * Operation getLanguageunderstandingDomainVersionWithHttpInfo
     *
     * Find an NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @param bool $includeUtterances Whether utterances for intent definition should be included when marshalling response. (optional)
     * @return Array of \PureCloudSDK\NluDomainVersion, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainVersionWithHttpInfo($domainId, $domainVersionId, $includeUtterances = null)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling getLanguageunderstandingDomainVersion');
        }
        // verify the required parameter 'domainVersionId' is set
        if ($domainVersionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainVersionId when calling getLanguageunderstandingDomainVersion');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($includeUtterances !== null) {
            $queryParams['includeUtterances'] = $this->apiClient->getSerializer()->toQueryValue($includeUtterances);
        }
        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($domainVersionId !== null) {
            $resourcePath = str_replace(
                "{" . "domainVersionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainVersionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainVersion',
                '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainVersion', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLanguageunderstandingDomainVersionReport
     *
     * Retrieved quality report for the specified NLU Domain Version
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return \PureCloudSDK\NluDomainVersionQualityReport
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainVersionReport($domainId, $domainVersionId)
    {
        list($response) = $this->getLanguageunderstandingDomainVersionReportWithHttpInfo($domainId, $domainVersionId);
        return $response;
    }

    /**
     * Operation getLanguageunderstandingDomainVersionReportWithHttpInfo
     *
     * Retrieved quality report for the specified NLU Domain Version
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return Array of \PureCloudSDK\NluDomainVersionQualityReport, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainVersionReportWithHttpInfo($domainId, $domainVersionId)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling getLanguageunderstandingDomainVersionReport');
        }
        // verify the required parameter 'domainVersionId' is set
        if ($domainVersionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainVersionId when calling getLanguageunderstandingDomainVersionReport');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/report";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($domainVersionId !== null) {
            $resourcePath = str_replace(
                "{" . "domainVersionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainVersionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainVersionQualityReport',
                '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/report'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainVersionQualityReport', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersionQualityReport', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLanguageunderstandingDomainVersions
     *
     * Get all NLU Domain Versions for a given Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param bool $includeUtterances Whether utterances for intent definition should be included when marshalling response. (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\NluDomainVersionListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainVersions($domainId, $includeUtterances = null, $pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getLanguageunderstandingDomainVersionsWithHttpInfo($domainId, $includeUtterances, $pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getLanguageunderstandingDomainVersionsWithHttpInfo
     *
     * Get all NLU Domain Versions for a given Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param bool $includeUtterances Whether utterances for intent definition should be included when marshalling response. (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\NluDomainVersionListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainVersionsWithHttpInfo($domainId, $includeUtterances = null, $pageNumber = null, $pageSize = null)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling getLanguageunderstandingDomainVersions');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($includeUtterances !== null) {
            $queryParams['includeUtterances'] = $this->apiClient->getSerializer()->toQueryValue($includeUtterances);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainVersionListing',
                '/api/v2/languageunderstanding/domains/{domainId}/versions'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainVersionListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersionListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLanguageunderstandingDomains
     *
     * Get all NLU Domains.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\NluDomainListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomains($pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getLanguageunderstandingDomainsWithHttpInfo($pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getLanguageunderstandingDomainsWithHttpInfo
     *
     * Get all NLU Domains.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\NluDomainListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getLanguageunderstandingDomainsWithHttpInfo($pageNumber = null, $pageSize = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainListing',
                '/api/v2/languageunderstanding/domains'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchLanguageunderstandingDomain
     *
     * Update an NLU Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param \PureCloudSDK\NluDomain $body The updated NLU Domain. (required)
     * @return \PureCloudSDK\NluDomain
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchLanguageunderstandingDomain($domainId, $body)
    {
        list($response) = $this->patchLanguageunderstandingDomainWithHttpInfo($domainId, $body);
        return $response;
    }

    /**
     * Operation patchLanguageunderstandingDomainWithHttpInfo
     *
     * Update an NLU Domain.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param \PureCloudSDK\NluDomain $body The updated NLU Domain. (required)
     * @return Array of \PureCloudSDK\NluDomain, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchLanguageunderstandingDomainWithHttpInfo($domainId, $body)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling patchLanguageunderstandingDomain');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchLanguageunderstandingDomain');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomain',
                '/api/v2/languageunderstanding/domains/{domainId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomain', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomain', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postLanguageunderstandingDomainFeedback
     *
     * Create feedback for the NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param \PureCloudSDK\NluFeedbackRequest $body The Feedback to create. (required)
     * @return \PureCloudSDK\NluFeedbackResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainFeedback($domainId, $body)
    {
        list($response) = $this->postLanguageunderstandingDomainFeedbackWithHttpInfo($domainId, $body);
        return $response;
    }

    /**
     * Operation postLanguageunderstandingDomainFeedbackWithHttpInfo
     *
     * Create feedback for the NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param \PureCloudSDK\NluFeedbackRequest $body The Feedback to create. (required)
     * @return Array of \PureCloudSDK\NluFeedbackResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainFeedbackWithHttpInfo($domainId, $body)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling postLanguageunderstandingDomainFeedback');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postLanguageunderstandingDomainFeedback');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/feedback";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluFeedbackResponse',
                '/api/v2/languageunderstanding/domains/{domainId}/feedback'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluFeedbackResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluFeedbackResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluFeedbackResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postLanguageunderstandingDomainVersionDetect
     *
     * Detect intent, entities, etc. in the submitted text using the specified NLU domain version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @param \PureCloudSDK\NluDetectionRequest $body The input data to perform detection on. (required)
     * @return \PureCloudSDK\NluDetectionResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersionDetect($domainId, $domainVersionId, $body)
    {
        list($response) = $this->postLanguageunderstandingDomainVersionDetectWithHttpInfo($domainId, $domainVersionId, $body);
        return $response;
    }

    /**
     * Operation postLanguageunderstandingDomainVersionDetectWithHttpInfo
     *
     * Detect intent, entities, etc. in the submitted text using the specified NLU domain version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @param \PureCloudSDK\NluDetectionRequest $body The input data to perform detection on. (required)
     * @return Array of \PureCloudSDK\NluDetectionResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersionDetectWithHttpInfo($domainId, $domainVersionId, $body)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling postLanguageunderstandingDomainVersionDetect');
        }
        // verify the required parameter 'domainVersionId' is set
        if ($domainVersionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainVersionId when calling postLanguageunderstandingDomainVersionDetect');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postLanguageunderstandingDomainVersionDetect');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/detect";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($domainVersionId !== null) {
            $resourcePath = str_replace(
                "{" . "domainVersionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainVersionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDetectionResponse',
                '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/detect'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDetectionResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDetectionResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postLanguageunderstandingDomainVersionPublish
     *
     * Publish the draft NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return \PureCloudSDK\NluDomainVersion
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersionPublish($domainId, $domainVersionId)
    {
        list($response) = $this->postLanguageunderstandingDomainVersionPublishWithHttpInfo($domainId, $domainVersionId);
        return $response;
    }

    /**
     * Operation postLanguageunderstandingDomainVersionPublishWithHttpInfo
     *
     * Publish the draft NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return Array of \PureCloudSDK\NluDomainVersion, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersionPublishWithHttpInfo($domainId, $domainVersionId)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling postLanguageunderstandingDomainVersionPublish');
        }
        // verify the required parameter 'domainVersionId' is set
        if ($domainVersionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainVersionId when calling postLanguageunderstandingDomainVersionPublish');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/publish";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($domainVersionId !== null) {
            $resourcePath = str_replace(
                "{" . "domainVersionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainVersionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainVersion',
                '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/publish'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainVersion', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postLanguageunderstandingDomainVersionTrain
     *
     * Train the draft NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return \PureCloudSDK\NluDomainVersionTrainingResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersionTrain($domainId, $domainVersionId)
    {
        list($response) = $this->postLanguageunderstandingDomainVersionTrainWithHttpInfo($domainId, $domainVersionId);
        return $response;
    }

    /**
     * Operation postLanguageunderstandingDomainVersionTrainWithHttpInfo
     *
     * Train the draft NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @return Array of \PureCloudSDK\NluDomainVersionTrainingResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersionTrainWithHttpInfo($domainId, $domainVersionId)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling postLanguageunderstandingDomainVersionTrain');
        }
        // verify the required parameter 'domainVersionId' is set
        if ($domainVersionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainVersionId when calling postLanguageunderstandingDomainVersionTrain');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/train";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($domainVersionId !== null) {
            $resourcePath = str_replace(
                "{" . "domainVersionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainVersionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainVersionTrainingResponse',
                '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/train'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainVersionTrainingResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersionTrainingResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersionTrainingResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postLanguageunderstandingDomainVersions
     *
     * Create an NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param \PureCloudSDK\NluDomainVersion $body The NLU Domain Version to create. (required)
     * @return \PureCloudSDK\NluDomainVersion
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersions($domainId, $body)
    {
        list($response) = $this->postLanguageunderstandingDomainVersionsWithHttpInfo($domainId, $body);
        return $response;
    }

    /**
     * Operation postLanguageunderstandingDomainVersionsWithHttpInfo
     *
     * Create an NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param \PureCloudSDK\NluDomainVersion $body The NLU Domain Version to create. (required)
     * @return Array of \PureCloudSDK\NluDomainVersion, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainVersionsWithHttpInfo($domainId, $body)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling postLanguageunderstandingDomainVersions');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postLanguageunderstandingDomainVersions');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainVersion',
                '/api/v2/languageunderstanding/domains/{domainId}/versions'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainVersion', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postLanguageunderstandingDomains
     *
     * Create an NLU Domain.
     *
     * @param \PureCloudSDK\NluDomain $body The NLU Domain to create. (required)
     * @return \PureCloudSDK\NluDomain
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomains($body)
    {
        list($response) = $this->postLanguageunderstandingDomainsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postLanguageunderstandingDomainsWithHttpInfo
     *
     * Create an NLU Domain.
     *
     * @param \PureCloudSDK\NluDomain $body The NLU Domain to create. (required)
     * @return Array of \PureCloudSDK\NluDomain, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postLanguageunderstandingDomainsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postLanguageunderstandingDomains');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomain',
                '/api/v2/languageunderstanding/domains'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomain', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomain', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomain', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putLanguageunderstandingDomainVersion
     *
     * Update an NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @param \PureCloudSDK\NluDomainVersion $body The updated NLU Domain Version. (required)
     * @return \PureCloudSDK\NluDomainVersion
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putLanguageunderstandingDomainVersion($domainId, $domainVersionId, $body)
    {
        list($response) = $this->putLanguageunderstandingDomainVersionWithHttpInfo($domainId, $domainVersionId, $body);
        return $response;
    }

    /**
     * Operation putLanguageunderstandingDomainVersionWithHttpInfo
     *
     * Update an NLU Domain Version.
     *
     * @param string $domainId ID of the NLU domain. (required)
     * @param string $domainVersionId ID of the NLU domain version. (required)
     * @param \PureCloudSDK\NluDomainVersion $body The updated NLU Domain Version. (required)
     * @return Array of \PureCloudSDK\NluDomainVersion, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putLanguageunderstandingDomainVersionWithHttpInfo($domainId, $domainVersionId, $body)
    {
        // verify the required parameter 'domainId' is set
        if ($domainId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainId when calling putLanguageunderstandingDomainVersion');
        }
        // verify the required parameter 'domainVersionId' is set
        if ($domainVersionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $domainVersionId when calling putLanguageunderstandingDomainVersion');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putLanguageunderstandingDomainVersion');
        }
        // parse inputs
        $resourcePath = "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($domainId !== null) {
            $resourcePath = str_replace(
                "{" . "domainId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainId),
                $resourcePath
            );
        }
        // path params
        if ($domainVersionId !== null) {
            $resourcePath = str_replace(
                "{" . "domainVersionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($domainVersionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NluDomainVersion',
                '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NluDomainVersion', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NluDomainVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
