<?php

/**
 * BuRescheduleRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuRescheduleRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuRescheduleRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuRescheduleRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'agentIds' => 'string[]',
        'activityCodeIds' => 'string[]',
        'managementUnitIds' => 'string[]',
        'doNotChangeWeeklyPaidTime' => 'bool',
        'doNotChangeDailyPaidTime' => 'bool',
        'doNotChangeShiftStartTimes' => 'bool',
        'doNotChangeManuallyEditedShifts' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'agentIds' => 'agentIds',
        'activityCodeIds' => 'activityCodeIds',
        'managementUnitIds' => 'managementUnitIds',
        'doNotChangeWeeklyPaidTime' => 'doNotChangeWeeklyPaidTime',
        'doNotChangeDailyPaidTime' => 'doNotChangeDailyPaidTime',
        'doNotChangeShiftStartTimes' => 'doNotChangeShiftStartTimes',
        'doNotChangeManuallyEditedShifts' => 'doNotChangeManuallyEditedShifts'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'agentIds' => 'setAgentIds',
        'activityCodeIds' => 'setActivityCodeIds',
        'managementUnitIds' => 'setManagementUnitIds',
        'doNotChangeWeeklyPaidTime' => 'setDoNotChangeWeeklyPaidTime',
        'doNotChangeDailyPaidTime' => 'setDoNotChangeDailyPaidTime',
        'doNotChangeShiftStartTimes' => 'setDoNotChangeShiftStartTimes',
        'doNotChangeManuallyEditedShifts' => 'setDoNotChangeManuallyEditedShifts'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'agentIds' => 'getAgentIds',
        'activityCodeIds' => 'getActivityCodeIds',
        'managementUnitIds' => 'getManagementUnitIds',
        'doNotChangeWeeklyPaidTime' => 'getDoNotChangeWeeklyPaidTime',
        'doNotChangeDailyPaidTime' => 'getDoNotChangeDailyPaidTime',
        'doNotChangeShiftStartTimes' => 'getDoNotChangeShiftStartTimes',
        'doNotChangeManuallyEditedShifts' => 'getDoNotChangeManuallyEditedShifts'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['agentIds'] = isset($data['agentIds']) ? $data['agentIds'] : null;
        $this->container['activityCodeIds'] = isset($data['activityCodeIds']) ? $data['activityCodeIds'] : null;
        $this->container['managementUnitIds'] = isset($data['managementUnitIds']) ? $data['managementUnitIds'] : null;
        $this->container['doNotChangeWeeklyPaidTime'] = isset($data['doNotChangeWeeklyPaidTime']) ? $data['doNotChangeWeeklyPaidTime'] : null;
        $this->container['doNotChangeDailyPaidTime'] = isset($data['doNotChangeDailyPaidTime']) ? $data['doNotChangeDailyPaidTime'] : null;
        $this->container['doNotChangeShiftStartTimes'] = isset($data['doNotChangeShiftStartTimes']) ? $data['doNotChangeShiftStartTimes'] : null;
        $this->container['doNotChangeManuallyEditedShifts'] = isset($data['doNotChangeManuallyEditedShifts']) ? $data['doNotChangeManuallyEditedShifts'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['managementUnitIds'] === null) {
            $invalid_properties[] = "'managementUnitIds' can't be null";
        }
        if ($this->container['doNotChangeWeeklyPaidTime'] === null) {
            $invalid_properties[] = "'doNotChangeWeeklyPaidTime' can't be null";
        }
        if ($this->container['doNotChangeDailyPaidTime'] === null) {
            $invalid_properties[] = "'doNotChangeDailyPaidTime' can't be null";
        }
        if ($this->container['doNotChangeShiftStartTimes'] === null) {
            $invalid_properties[] = "'doNotChangeShiftStartTimes' can't be null";
        }
        if ($this->container['doNotChangeManuallyEditedShifts'] === null) {
            $invalid_properties[] = "'doNotChangeManuallyEditedShifts' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['managementUnitIds'] === null) {
            return false;
        }
        if ($this->container['doNotChangeWeeklyPaidTime'] === null) {
            return false;
        }
        if ($this->container['doNotChangeDailyPaidTime'] === null) {
            return false;
        }
        if ($this->container['doNotChangeShiftStartTimes'] === null) {
            return false;
        }
        if ($this->container['doNotChangeManuallyEditedShifts'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate The start of the range to reschedule.  Defaults to the beginning of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate The end of the range to reschedule.  Defaults the the end of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets agentIds
     * @return string[]
     */
    public function getAgentIds()
    {
        return $this->container['agentIds'];
    }

    /**
     * Sets agentIds
     * @param string[] $agentIds The IDs of the agents to consider for rescheduling.  Omit to consider all agents in the specified management units.Agents not in the specified management units will be ignored
     * @return $this
     */
    public function setAgentIds($agentIds)
    {
        $this->container['agentIds'] = $agentIds;

        return $this;
    }

    /**
     * Gets activityCodeIds
     * @return string[]
     */
    public function getActivityCodeIds()
    {
        return $this->container['activityCodeIds'];
    }

    /**
     * Sets activityCodeIds
     * @param string[] $activityCodeIds The IDs of the activity codes to consider for rescheduling.  Omit to consider all activity codes
     * @return $this
     */
    public function setActivityCodeIds($activityCodeIds)
    {
        $this->container['activityCodeIds'] = $activityCodeIds;

        return $this;
    }

    /**
     * Gets managementUnitIds
     * @return string[]
     */
    public function getManagementUnitIds()
    {
        return $this->container['managementUnitIds'];
    }

    /**
     * Sets managementUnitIds
     * @param string[] $managementUnitIds The IDs of the management units to reschedule
     * @return $this
     */
    public function setManagementUnitIds($managementUnitIds)
    {
        $this->container['managementUnitIds'] = $managementUnitIds;

        return $this;
    }

    /**
     * Gets doNotChangeWeeklyPaidTime
     * @return bool
     */
    public function getDoNotChangeWeeklyPaidTime()
    {
        return $this->container['doNotChangeWeeklyPaidTime'];
    }

    /**
     * Sets doNotChangeWeeklyPaidTime
     * @param bool $doNotChangeWeeklyPaidTime Instructs the scheduler whether it is allowed to change weekly paid time
     * @return $this
     */
    public function setDoNotChangeWeeklyPaidTime($doNotChangeWeeklyPaidTime)
    {
        $this->container['doNotChangeWeeklyPaidTime'] = $doNotChangeWeeklyPaidTime;

        return $this;
    }

    /**
     * Gets doNotChangeDailyPaidTime
     * @return bool
     */
    public function getDoNotChangeDailyPaidTime()
    {
        return $this->container['doNotChangeDailyPaidTime'];
    }

    /**
     * Sets doNotChangeDailyPaidTime
     * @param bool $doNotChangeDailyPaidTime Instructs the scheduler whether it is allowed to change daily paid time
     * @return $this
     */
    public function setDoNotChangeDailyPaidTime($doNotChangeDailyPaidTime)
    {
        $this->container['doNotChangeDailyPaidTime'] = $doNotChangeDailyPaidTime;

        return $this;
    }

    /**
     * Gets doNotChangeShiftStartTimes
     * @return bool
     */
    public function getDoNotChangeShiftStartTimes()
    {
        return $this->container['doNotChangeShiftStartTimes'];
    }

    /**
     * Sets doNotChangeShiftStartTimes
     * @param bool $doNotChangeShiftStartTimes Instructs the scheduler whether it is allowed to change shift start times
     * @return $this
     */
    public function setDoNotChangeShiftStartTimes($doNotChangeShiftStartTimes)
    {
        $this->container['doNotChangeShiftStartTimes'] = $doNotChangeShiftStartTimes;

        return $this;
    }

    /**
     * Gets doNotChangeManuallyEditedShifts
     * @return bool
     */
    public function getDoNotChangeManuallyEditedShifts()
    {
        return $this->container['doNotChangeManuallyEditedShifts'];
    }

    /**
     * Sets doNotChangeManuallyEditedShifts
     * @param bool $doNotChangeManuallyEditedShifts Instructs the scheduler whether it is allowed to change manually edited shifts
     * @return $this
     */
    public function setDoNotChangeManuallyEditedShifts($doNotChangeManuallyEditedShifts)
    {
        $this->container['doNotChangeManuallyEditedShifts'] = $doNotChangeManuallyEditedShifts;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
