<?php

/**
 * BuRescheduleResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuRescheduleResult Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuRescheduleResult implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuRescheduleResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'generationResults' => '\PureCloudSDK\ScheduleGenerationResult',
        'generationResultsDownloadUrl' => 'string',
        'headcountForecast' => '\PureCloudSDK\BuHeadcountForecast',
        'headcountForecastDownloadUrl' => 'string',
        'agentSchedules' => '\PureCloudSDK\BuRescheduleAgentScheduleResult[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'generationResults' => 'generationResults',
        'generationResultsDownloadUrl' => 'generationResultsDownloadUrl',
        'headcountForecast' => 'headcountForecast',
        'headcountForecastDownloadUrl' => 'headcountForecastDownloadUrl',
        'agentSchedules' => 'agentSchedules'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'generationResults' => 'setGenerationResults',
        'generationResultsDownloadUrl' => 'setGenerationResultsDownloadUrl',
        'headcountForecast' => 'setHeadcountForecast',
        'headcountForecastDownloadUrl' => 'setHeadcountForecastDownloadUrl',
        'agentSchedules' => 'setAgentSchedules'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'generationResults' => 'getGenerationResults',
        'generationResultsDownloadUrl' => 'getGenerationResultsDownloadUrl',
        'headcountForecast' => 'getHeadcountForecast',
        'headcountForecastDownloadUrl' => 'getHeadcountForecastDownloadUrl',
        'agentSchedules' => 'getAgentSchedules'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['generationResults'] = isset($data['generationResults']) ? $data['generationResults'] : null;
        $this->container['generationResultsDownloadUrl'] = isset($data['generationResultsDownloadUrl']) ? $data['generationResultsDownloadUrl'] : null;
        $this->container['headcountForecast'] = isset($data['headcountForecast']) ? $data['headcountForecast'] : null;
        $this->container['headcountForecastDownloadUrl'] = isset($data['headcountForecastDownloadUrl']) ? $data['headcountForecastDownloadUrl'] : null;
        $this->container['agentSchedules'] = isset($data['agentSchedules']) ? $data['agentSchedules'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets generationResults
     * @return \PureCloudSDK\ScheduleGenerationResult
     */
    public function getGenerationResults()
    {
        return $this->container['generationResults'];
    }

    /**
     * Sets generationResults
     * @param \PureCloudSDK\ScheduleGenerationResult $generationResults The generation results.  Note the result will always be delivered via the downloadUrl; however the schema is included for documentation
     * @return $this
     */
    public function setGenerationResults($generationResults)
    {
        $this->container['generationResults'] = $generationResults;

        return $this;
    }

    /**
     * Gets generationResultsDownloadUrl
     * @return string
     */
    public function getGenerationResultsDownloadUrl()
    {
        return $this->container['generationResultsDownloadUrl'];
    }

    /**
     * Sets generationResultsDownloadUrl
     * @param string $generationResultsDownloadUrl The download URL from which to fetch the generation results for the rescheduling run
     * @return $this
     */
    public function setGenerationResultsDownloadUrl($generationResultsDownloadUrl)
    {
        $this->container['generationResultsDownloadUrl'] = $generationResultsDownloadUrl;

        return $this;
    }

    /**
     * Gets headcountForecast
     * @return \PureCloudSDK\BuHeadcountForecast
     */
    public function getHeadcountForecast()
    {
        return $this->container['headcountForecast'];
    }

    /**
     * Sets headcountForecast
     * @param \PureCloudSDK\BuHeadcountForecast $headcountForecast The headcount forecast.  Note the result will always be delivered via the downloadUrl; however the schema is included for documentation
     * @return $this
     */
    public function setHeadcountForecast($headcountForecast)
    {
        $this->container['headcountForecast'] = $headcountForecast;

        return $this;
    }

    /**
     * Gets headcountForecastDownloadUrl
     * @return string
     */
    public function getHeadcountForecastDownloadUrl()
    {
        return $this->container['headcountForecastDownloadUrl'];
    }

    /**
     * Sets headcountForecastDownloadUrl
     * @param string $headcountForecastDownloadUrl The download URL from which to fetch the headcount forecast for the rescheduling run
     * @return $this
     */
    public function setHeadcountForecastDownloadUrl($headcountForecastDownloadUrl)
    {
        $this->container['headcountForecastDownloadUrl'] = $headcountForecastDownloadUrl;

        return $this;
    }

    /**
     * Gets agentSchedules
     * @return \PureCloudSDK\BuRescheduleAgentScheduleResult[]
     */
    public function getAgentSchedules()
    {
        return $this->container['agentSchedules'];
    }

    /**
     * Sets agentSchedules
     * @param \PureCloudSDK\BuRescheduleAgentScheduleResult[] $agentSchedules List of download links for agent schedules produced by the rescheduling run
     * @return $this
     */
    public function setAgentSchedules($agentSchedules)
    {
        $this->container['agentSchedules'] = $agentSchedules;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
