<?php

/**
 * JsonNodeSearchResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * JsonNodeSearchResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class JsonNodeSearchResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'JsonNodeSearchResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'total' => 'int',
        'pageCount' => 'int',
        'pageSize' => 'int',
        'pageNumber' => 'int',
        'previousPage' => 'string',
        'currentPage' => 'string',
        'nextPage' => 'string',
        'types' => 'string[]',
        'results' => '\PureCloudSDK\ArrayNode',
        'aggregations' => '\PureCloudSDK\ArrayNode'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'total' => 'total',
        'pageCount' => 'pageCount',
        'pageSize' => 'pageSize',
        'pageNumber' => 'pageNumber',
        'previousPage' => 'previousPage',
        'currentPage' => 'currentPage',
        'nextPage' => 'nextPage',
        'types' => 'types',
        'results' => 'results',
        'aggregations' => 'aggregations'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'total' => 'setTotal',
        'pageCount' => 'setPageCount',
        'pageSize' => 'setPageSize',
        'pageNumber' => 'setPageNumber',
        'previousPage' => 'setPreviousPage',
        'currentPage' => 'setCurrentPage',
        'nextPage' => 'setNextPage',
        'types' => 'setTypes',
        'results' => 'setResults',
        'aggregations' => 'setAggregations'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'total' => 'getTotal',
        'pageCount' => 'getPageCount',
        'pageSize' => 'getPageSize',
        'pageNumber' => 'getPageNumber',
        'previousPage' => 'getPreviousPage',
        'currentPage' => 'getCurrentPage',
        'nextPage' => 'getNextPage',
        'types' => 'getTypes',
        'results' => 'getResults',
        'aggregations' => 'getAggregations'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['total'] = isset($data['total']) ? $data['total'] : null;
        $this->container['pageCount'] = isset($data['pageCount']) ? $data['pageCount'] : null;
        $this->container['pageSize'] = isset($data['pageSize']) ? $data['pageSize'] : null;
        $this->container['pageNumber'] = isset($data['pageNumber']) ? $data['pageNumber'] : null;
        $this->container['previousPage'] = isset($data['previousPage']) ? $data['previousPage'] : null;
        $this->container['currentPage'] = isset($data['currentPage']) ? $data['currentPage'] : null;
        $this->container['nextPage'] = isset($data['nextPage']) ? $data['nextPage'] : null;
        $this->container['types'] = isset($data['types']) ? $data['types'] : null;
        $this->container['results'] = isset($data['results']) ? $data['results'] : null;
        $this->container['aggregations'] = isset($data['aggregations']) ? $data['aggregations'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['total'] === null) {
            $invalid_properties[] = "'total' can't be null";
        }
        if ($this->container['pageCount'] === null) {
            $invalid_properties[] = "'pageCount' can't be null";
        }
        if ($this->container['pageSize'] === null) {
            $invalid_properties[] = "'pageSize' can't be null";
        }
        if ($this->container['pageNumber'] === null) {
            $invalid_properties[] = "'pageNumber' can't be null";
        }
        if ($this->container['types'] === null) {
            $invalid_properties[] = "'types' can't be null";
        }
        if ($this->container['results'] === null) {
            $invalid_properties[] = "'results' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['total'] === null) {
            return false;
        }
        if ($this->container['pageCount'] === null) {
            return false;
        }
        if ($this->container['pageSize'] === null) {
            return false;
        }
        if ($this->container['pageNumber'] === null) {
            return false;
        }
        if ($this->container['types'] === null) {
            return false;
        }
        if ($this->container['results'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets total
     * @return int
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     * @param int $total The total number of results found
     * @return $this
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets pageCount
     * @return int
     */
    public function getPageCount()
    {
        return $this->container['pageCount'];
    }

    /**
     * Sets pageCount
     * @param int $pageCount The total number of pages
     * @return $this
     */
    public function setPageCount($pageCount)
    {
        $this->container['pageCount'] = $pageCount;

        return $this;
    }

    /**
     * Gets pageSize
     * @return int
     */
    public function getPageSize()
    {
        return $this->container['pageSize'];
    }

    /**
     * Sets pageSize
     * @param int $pageSize The current page size
     * @return $this
     */
    public function setPageSize($pageSize)
    {
        $this->container['pageSize'] = $pageSize;

        return $this;
    }

    /**
     * Gets pageNumber
     * @return int
     */
    public function getPageNumber()
    {
        return $this->container['pageNumber'];
    }

    /**
     * Sets pageNumber
     * @param int $pageNumber The current page number
     * @return $this
     */
    public function setPageNumber($pageNumber)
    {
        $this->container['pageNumber'] = $pageNumber;

        return $this;
    }

    /**
     * Gets previousPage
     * @return string
     */
    public function getPreviousPage()
    {
        return $this->container['previousPage'];
    }

    /**
     * Sets previousPage
     * @param string $previousPage Q64 value for the previous page of results
     * @return $this
     */
    public function setPreviousPage($previousPage)
    {
        $this->container['previousPage'] = $previousPage;

        return $this;
    }

    /**
     * Gets currentPage
     * @return string
     */
    public function getCurrentPage()
    {
        return $this->container['currentPage'];
    }

    /**
     * Sets currentPage
     * @param string $currentPage Q64 value for the current page of results
     * @return $this
     */
    public function setCurrentPage($currentPage)
    {
        $this->container['currentPage'] = $currentPage;

        return $this;
    }

    /**
     * Gets nextPage
     * @return string
     */
    public function getNextPage()
    {
        return $this->container['nextPage'];
    }

    /**
     * Sets nextPage
     * @param string $nextPage Q64 value for the next page of results
     * @return $this
     */
    public function setNextPage($nextPage)
    {
        $this->container['nextPage'] = $nextPage;

        return $this;
    }

    /**
     * Gets types
     * @return string[]
     */
    public function getTypes()
    {
        return $this->container['types'];
    }

    /**
     * Sets types
     * @param string[] $types Resource types the search was performed against
     * @return $this
     */
    public function setTypes($types)
    {
        $this->container['types'] = $types;

        return $this;
    }

    /**
     * Gets results
     * @return \PureCloudSDK\ArrayNode
     */
    public function getResults()
    {
        return $this->container['results'];
    }

    /**
     * Sets results
     * @param \PureCloudSDK\ArrayNode $results Search results
     * @return $this
     */
    public function setResults($results)
    {
        $this->container['results'] = $results;

        return $this;
    }

    /**
     * Gets aggregations
     * @return \PureCloudSDK\ArrayNode
     */
    public function getAggregations()
    {
        return $this->container['aggregations'];
    }

    /**
     * Sets aggregations
     * @param \PureCloudSDK\ArrayNode $aggregations
     * @return $this
     */
    public function setAggregations($aggregations)
    {
        $this->container['aggregations'] = $aggregations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
