<?php

/**
 * MessageData
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * MessageData Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class MessageData implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'MessageData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'providerMessageId' => 'string',
        'timestamp' => '\DateTime',
        'fromAddress' => 'string',
        'toAddress' => 'string',
        'direction' => 'string',
        'messengerType' => 'string',
        'textBody' => 'string',
        'status' => 'string',
        'media' => '\PureCloudSDK\MessageMedia[]',
        'stickers' => '\PureCloudSDK\MessageSticker[]',
        'createdBy' => '\PureCloudSDK\User',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'providerMessageId' => 'providerMessageId',
        'timestamp' => 'timestamp',
        'fromAddress' => 'fromAddress',
        'toAddress' => 'toAddress',
        'direction' => 'direction',
        'messengerType' => 'messengerType',
        'textBody' => 'textBody',
        'status' => 'status',
        'media' => 'media',
        'stickers' => 'stickers',
        'createdBy' => 'createdBy',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'providerMessageId' => 'setProviderMessageId',
        'timestamp' => 'setTimestamp',
        'fromAddress' => 'setFromAddress',
        'toAddress' => 'setToAddress',
        'direction' => 'setDirection',
        'messengerType' => 'setMessengerType',
        'textBody' => 'setTextBody',
        'status' => 'setStatus',
        'media' => 'setMedia',
        'stickers' => 'setStickers',
        'createdBy' => 'setCreatedBy',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'providerMessageId' => 'getProviderMessageId',
        'timestamp' => 'getTimestamp',
        'fromAddress' => 'getFromAddress',
        'toAddress' => 'getToAddress',
        'direction' => 'getDirection',
        'messengerType' => 'getMessengerType',
        'textBody' => 'getTextBody',
        'status' => 'getStatus',
        'media' => 'getMedia',
        'stickers' => 'getStickers',
        'createdBy' => 'getCreatedBy',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const DIRECTION_INBOUND = 'inbound';
    public const DIRECTION_OUTBOUND = 'outbound';
    public const MESSENGER_TYPE_SMS = 'sms';
    public const MESSENGER_TYPE_FACEBOOK = 'facebook';
    public const MESSENGER_TYPE_TWITTER = 'twitter';
    public const MESSENGER_TYPE_LINE = 'line';
    public const MESSENGER_TYPE_WHATSAPP = 'whatsapp';
    public const MESSENGER_TYPE_WEBMESSAGING = 'webmessaging';
    public const STATUS_QUEUED = 'queued';
    public const STATUS_SENT = 'sent';
    public const STATUS_FAILED = 'failed';
    public const STATUS_RECEIVED = 'received';
    public const STATUS_DELIVERY_SUCCESS = 'delivery-success';
    public const STATUS_DELIVERY_FAILED = 'delivery-failed';
    public const STATUS_READ = 'read';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMessengerTypeAllowableValues()
    {
        return [
            self::MESSENGER_TYPE_SMS,
            self::MESSENGER_TYPE_FACEBOOK,
            self::MESSENGER_TYPE_TWITTER,
            self::MESSENGER_TYPE_LINE,
            self::MESSENGER_TYPE_WHATSAPP,
            self::MESSENGER_TYPE_WEBMESSAGING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_QUEUED,
            self::STATUS_SENT,
            self::STATUS_FAILED,
            self::STATUS_RECEIVED,
            self::STATUS_DELIVERY_SUCCESS,
            self::STATUS_DELIVERY_FAILED,
            self::STATUS_READ,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['providerMessageId'] = isset($data['providerMessageId']) ? $data['providerMessageId'] : null;
        $this->container['timestamp'] = isset($data['timestamp']) ? $data['timestamp'] : null;
        $this->container['fromAddress'] = isset($data['fromAddress']) ? $data['fromAddress'] : null;
        $this->container['toAddress'] = isset($data['toAddress']) ? $data['toAddress'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['messengerType'] = isset($data['messengerType']) ? $data['messengerType'] : null;
        $this->container['textBody'] = isset($data['textBody']) ? $data['textBody'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['media'] = isset($data['media']) ? $data['media'] : null;
        $this->container['stickers'] = isset($data['stickers']) ? $data['stickers'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['timestamp'] === null) {
            $invalid_properties[] = "'timestamp' can't be null";
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp", "webmessaging");
        if (!in_array($this->container['messengerType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'messengerType', must be one of #{allowed_values}.";
        }

        if ($this->container['textBody'] === null) {
            $invalid_properties[] = "'textBody' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalid_properties[] = "'status' can't be null";
        }
        $allowed_values = array("queued", "sent", "failed", "received", "delivery-success", "delivery-failed", "read");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['timestamp'] === null) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp", "webmessaging");
        if (!in_array($this->container['messengerType'], $allowed_values)) {
            return false;
        }
        if ($this->container['textBody'] === null) {
            return false;
        }
        if ($this->container['status'] === null) {
            return false;
        }
        $allowed_values = array("queued", "sent", "failed", "received", "delivery-success", "delivery-failed", "read");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets providerMessageId
     * @return string
     */
    public function getProviderMessageId()
    {
        return $this->container['providerMessageId'];
    }

    /**
     * Sets providerMessageId
     * @param string $providerMessageId The unique identifier of the message from provider
     * @return $this
     */
    public function setProviderMessageId($providerMessageId)
    {
        $this->container['providerMessageId'] = $providerMessageId;

        return $this;
    }

    /**
     * Gets timestamp
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     * @param \DateTime $timestamp The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets fromAddress
     * @return string
     */
    public function getFromAddress()
    {
        return $this->container['fromAddress'];
    }

    /**
     * Sets fromAddress
     * @param string $fromAddress The sender of the text message.
     * @return $this
     */
    public function setFromAddress($fromAddress)
    {
        $this->container['fromAddress'] = $fromAddress;

        return $this;
    }

    /**
     * Gets toAddress
     * @return string
     */
    public function getToAddress()
    {
        return $this->container['toAddress'];
    }

    /**
     * Sets toAddress
     * @param string $toAddress The recipient of the text message.
     * @return $this
     */
    public function setToAddress($toAddress)
    {
        $this->container['toAddress'] = $toAddress;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The direction of the message.
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets messengerType
     * @return string
     */
    public function getMessengerType()
    {
        return $this->container['messengerType'];
    }

    /**
     * Sets messengerType
     * @param string $messengerType Type of text messenger.
     * @return $this
     */
    public function setMessengerType($messengerType)
    {
        $allowed_values = array('sms', 'facebook', 'twitter', 'line', 'whatsapp', 'webmessaging');
        if (!in_array($messengerType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'messengerType', must be one of 'sms', 'facebook', 'twitter', 'line', 'whatsapp', 'webmessaging'");
        }
        $this->container['messengerType'] = $messengerType;

        return $this;
    }

    /**
     * Gets textBody
     * @return string
     */
    public function getTextBody()
    {
        return $this->container['textBody'];
    }

    /**
     * Sets textBody
     * @param string $textBody The body of the text message.
     * @return $this
     */
    public function setTextBody($textBody)
    {
        $this->container['textBody'] = $textBody;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of the message.
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('queued', 'sent', 'failed', 'received', 'delivery-success', 'delivery-failed', 'read');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'queued', 'sent', 'failed', 'received', 'delivery-success', 'delivery-failed', 'read'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets media
     * @return \PureCloudSDK\MessageMedia[]
     */
    public function getMedia()
    {
        return $this->container['media'];
    }

    /**
     * Sets media
     * @param \PureCloudSDK\MessageMedia[] $media The media details associated to a message.
     * @return $this
     */
    public function setMedia($media)
    {
        $this->container['media'] = $media;

        return $this;
    }

    /**
     * Gets stickers
     * @return \PureCloudSDK\MessageSticker[]
     */
    public function getStickers()
    {
        return $this->container['stickers'];
    }

    /**
     * Sets stickers
     * @param \PureCloudSDK\MessageSticker[] $stickers The sticker details associated to a message.
     * @return $this
     */
    public function setStickers($stickers)
    {
        $this->container['stickers'] = $stickers;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\User
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\User $createdBy User who sent this message.
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
