<?php

/**
 * SendAgentlessOutboundMessageResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * SendAgentlessOutboundMessageResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SendAgentlessOutboundMessageResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SendAgentlessOutboundMessageResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'conversationId' => 'string',
        'fromAddress' => 'string',
        'toAddress' => 'string',
        'messengerType' => 'string',
        'textBody' => 'string',
        'timestamp' => '\DateTime',
        'selfUri' => 'string',
        'user' => '\PureCloudSDK\AddressableEntityRef'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'conversationId' => 'conversationId',
        'fromAddress' => 'fromAddress',
        'toAddress' => 'toAddress',
        'messengerType' => 'messengerType',
        'textBody' => 'textBody',
        'timestamp' => 'timestamp',
        'selfUri' => 'selfUri',
        'user' => 'user'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'conversationId' => 'setConversationId',
        'fromAddress' => 'setFromAddress',
        'toAddress' => 'setToAddress',
        'messengerType' => 'setMessengerType',
        'textBody' => 'setTextBody',
        'timestamp' => 'setTimestamp',
        'selfUri' => 'setSelfUri',
        'user' => 'setUser'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'conversationId' => 'getConversationId',
        'fromAddress' => 'getFromAddress',
        'toAddress' => 'getToAddress',
        'messengerType' => 'getMessengerType',
        'textBody' => 'getTextBody',
        'timestamp' => 'getTimestamp',
        'selfUri' => 'getSelfUri',
        'user' => 'getUser'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MESSENGER_TYPE_SMS = 'sms';
    public const MESSENGER_TYPE_FACEBOOK = 'facebook';
    public const MESSENGER_TYPE_TWITTER = 'twitter';
    public const MESSENGER_TYPE_LINE = 'line';
    public const MESSENGER_TYPE_WHATSAPP = 'whatsapp';
    public const MESSENGER_TYPE_WEBMESSAGING = 'webmessaging';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMessengerTypeAllowableValues()
    {
        return [
            self::MESSENGER_TYPE_SMS,
            self::MESSENGER_TYPE_FACEBOOK,
            self::MESSENGER_TYPE_TWITTER,
            self::MESSENGER_TYPE_LINE,
            self::MESSENGER_TYPE_WHATSAPP,
            self::MESSENGER_TYPE_WEBMESSAGING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['conversationId'] = isset($data['conversationId']) ? $data['conversationId'] : null;
        $this->container['fromAddress'] = isset($data['fromAddress']) ? $data['fromAddress'] : null;
        $this->container['toAddress'] = isset($data['toAddress']) ? $data['toAddress'] : null;
        $this->container['messengerType'] = isset($data['messengerType']) ? $data['messengerType'] : null;
        $this->container['textBody'] = isset($data['textBody']) ? $data['textBody'] : null;
        $this->container['timestamp'] = isset($data['timestamp']) ? $data['timestamp'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp", "webmessaging");
        if (!in_array($this->container['messengerType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'messengerType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp", "webmessaging");
        if (!in_array($this->container['messengerType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets conversationId
     * @return string
     */
    public function getConversationId()
    {
        return $this->container['conversationId'];
    }

    /**
     * Sets conversationId
     * @param string $conversationId The identifier of the conversation.
     * @return $this
     */
    public function setConversationId($conversationId)
    {
        $this->container['conversationId'] = $conversationId;

        return $this;
    }

    /**
     * Gets fromAddress
     * @return string
     */
    public function getFromAddress()
    {
        return $this->container['fromAddress'];
    }

    /**
     * Sets fromAddress
     * @param string $fromAddress The sender of the text message.
     * @return $this
     */
    public function setFromAddress($fromAddress)
    {
        $this->container['fromAddress'] = $fromAddress;

        return $this;
    }

    /**
     * Gets toAddress
     * @return string
     */
    public function getToAddress()
    {
        return $this->container['toAddress'];
    }

    /**
     * Sets toAddress
     * @param string $toAddress The recipient of the text message.
     * @return $this
     */
    public function setToAddress($toAddress)
    {
        $this->container['toAddress'] = $toAddress;

        return $this;
    }

    /**
     * Gets messengerType
     * @return string
     */
    public function getMessengerType()
    {
        return $this->container['messengerType'];
    }

    /**
     * Sets messengerType
     * @param string $messengerType Type of text messenger.
     * @return $this
     */
    public function setMessengerType($messengerType)
    {
        $allowed_values = array('sms', 'facebook', 'twitter', 'line', 'whatsapp', 'webmessaging');
        if (!in_array($messengerType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'messengerType', must be one of 'sms', 'facebook', 'twitter', 'line', 'whatsapp', 'webmessaging'");
        }
        $this->container['messengerType'] = $messengerType;

        return $this;
    }

    /**
     * Gets textBody
     * @return string
     */
    public function getTextBody()
    {
        return $this->container['textBody'];
    }

    /**
     * Sets textBody
     * @param string $textBody The body of the text message.
     * @return $this
     */
    public function setTextBody($textBody)
    {
        $this->container['textBody'] = $textBody;

        return $this;
    }

    /**
     * Gets timestamp
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     * @param \DateTime $timestamp The time when the message was sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\AddressableEntityRef
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\AddressableEntityRef $user Details of the user created the job
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
