<?php

/**
 * ShiftTradeMatchReviewResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ShiftTradeMatchReviewResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ShiftTradeMatchReviewResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ShiftTradeMatchReviewResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'initiatingUser' => '\PureCloudSDK\ShiftTradeMatchReviewUserResponse',
        'receivingUser' => '\PureCloudSDK\ShiftTradeMatchReviewUserResponse',
        'violations' => '\PureCloudSDK\ShiftTradeMatchViolation[]',
        'adminReviewViolations' => '\PureCloudSDK\ShiftTradeMatchViolation[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'initiatingUser' => 'initiatingUser',
        'receivingUser' => 'receivingUser',
        'violations' => 'violations',
        'adminReviewViolations' => 'adminReviewViolations'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'initiatingUser' => 'setInitiatingUser',
        'receivingUser' => 'setReceivingUser',
        'violations' => 'setViolations',
        'adminReviewViolations' => 'setAdminReviewViolations'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'initiatingUser' => 'getInitiatingUser',
        'receivingUser' => 'getReceivingUser',
        'violations' => 'getViolations',
        'adminReviewViolations' => 'getAdminReviewViolations'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['initiatingUser'] = isset($data['initiatingUser']) ? $data['initiatingUser'] : null;
        $this->container['receivingUser'] = isset($data['receivingUser']) ? $data['receivingUser'] : null;
        $this->container['violations'] = isset($data['violations']) ? $data['violations'] : null;
        $this->container['adminReviewViolations'] = isset($data['adminReviewViolations']) ? $data['adminReviewViolations'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets initiatingUser
     * @return \PureCloudSDK\ShiftTradeMatchReviewUserResponse
     */
    public function getInitiatingUser()
    {
        return $this->container['initiatingUser'];
    }

    /**
     * Sets initiatingUser
     * @param \PureCloudSDK\ShiftTradeMatchReviewUserResponse $initiatingUser Details for the initiatingUser side of the shift trade
     * @return $this
     */
    public function setInitiatingUser($initiatingUser)
    {
        $this->container['initiatingUser'] = $initiatingUser;

        return $this;
    }

    /**
     * Gets receivingUser
     * @return \PureCloudSDK\ShiftTradeMatchReviewUserResponse
     */
    public function getReceivingUser()
    {
        return $this->container['receivingUser'];
    }

    /**
     * Sets receivingUser
     * @param \PureCloudSDK\ShiftTradeMatchReviewUserResponse $receivingUser Details for the receivingUser side of the shift trade
     * @return $this
     */
    public function setReceivingUser($receivingUser)
    {
        $this->container['receivingUser'] = $receivingUser;

        return $this;
    }

    /**
     * Gets violations
     * @return \PureCloudSDK\ShiftTradeMatchViolation[]
     */
    public function getViolations()
    {
        return $this->container['violations'];
    }

    /**
     * Sets violations
     * @param \PureCloudSDK\ShiftTradeMatchViolation[] $violations Constraint violations introduced after being matched that would normally disallow a trade, but which can still be overridden by the shift trade administrator
     * @return $this
     */
    public function setViolations($violations)
    {
        $this->container['violations'] = $violations;

        return $this;
    }

    /**
     * Gets adminReviewViolations
     * @return \PureCloudSDK\ShiftTradeMatchViolation[]
     */
    public function getAdminReviewViolations()
    {
        return $this->container['adminReviewViolations'];
    }

    /**
     * Sets adminReviewViolations
     * @param \PureCloudSDK\ShiftTradeMatchViolation[] $adminReviewViolations Constraint violations associated with this shift trade which require shift trade administrator review
     * @return $this
     */
    public function setAdminReviewViolations($adminReviewViolations)
    {
        $this->container['adminReviewViolations'] = $adminReviewViolations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
