<?php

/**
 * TranscriptionSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TranscriptionSettings Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TranscriptionSettings implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TranscriptionSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'transcription' => 'string',
        'transcriptionConfidenceThreshold' => 'int',
        'contentSearchEnabled' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'transcription' => 'transcription',
        'transcriptionConfidenceThreshold' => 'transcriptionConfidenceThreshold',
        'contentSearchEnabled' => 'contentSearchEnabled'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'transcription' => 'setTranscription',
        'transcriptionConfidenceThreshold' => 'setTranscriptionConfidenceThreshold',
        'contentSearchEnabled' => 'setContentSearchEnabled'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'transcription' => 'getTranscription',
        'transcriptionConfidenceThreshold' => 'getTranscriptionConfidenceThreshold',
        'contentSearchEnabled' => 'getContentSearchEnabled'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TRANSCRIPTION_DISABLED = 'Disabled';
    public const TRANSCRIPTION_ENABLED_GLOBALLY = 'EnabledGlobally';
    public const TRANSCRIPTION_ENABLED_QUEUE_FLOW = 'EnabledQueueFlow';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTranscriptionAllowableValues()
    {
        return [
            self::TRANSCRIPTION_DISABLED,
            self::TRANSCRIPTION_ENABLED_GLOBALLY,
            self::TRANSCRIPTION_ENABLED_QUEUE_FLOW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transcription'] = isset($data['transcription']) ? $data['transcription'] : null;
        $this->container['transcriptionConfidenceThreshold'] = isset($data['transcriptionConfidenceThreshold']) ? $data['transcriptionConfidenceThreshold'] : null;
        $this->container['contentSearchEnabled'] = isset($data['contentSearchEnabled']) ? $data['contentSearchEnabled'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['transcription'] === null) {
            $invalid_properties[] = "'transcription' can't be null";
        }
        $allowed_values = array("Disabled", "EnabledGlobally", "EnabledQueueFlow");
        if (!in_array($this->container['transcription'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'transcription', must be one of #{allowed_values}.";
        }

        if ($this->container['transcriptionConfidenceThreshold'] === null) {
            $invalid_properties[] = "'transcriptionConfidenceThreshold' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['transcription'] === null) {
            return false;
        }
        $allowed_values = array("Disabled", "EnabledGlobally", "EnabledQueueFlow");
        if (!in_array($this->container['transcription'], $allowed_values)) {
            return false;
        }
        if ($this->container['transcriptionConfidenceThreshold'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets transcription
     * @return string
     */
    public function getTranscription()
    {
        return $this->container['transcription'];
    }

    /**
     * Sets transcription
     * @param string $transcription Setting to enable/disable transcription capability
     * @return $this
     */
    public function setTranscription($transcription)
    {
        $allowed_values = array('Disabled', 'EnabledGlobally', 'EnabledQueueFlow');
        if (!in_array($transcription, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'transcription', must be one of 'Disabled', 'EnabledGlobally', 'EnabledQueueFlow'");
        }
        $this->container['transcription'] = $transcription;

        return $this;
    }

    /**
     * Gets transcriptionConfidenceThreshold
     * @return int
     */
    public function getTranscriptionConfidenceThreshold()
    {
        return $this->container['transcriptionConfidenceThreshold'];
    }

    /**
     * Sets transcriptionConfidenceThreshold
     * @param int $transcriptionConfidenceThreshold Configure confidence threshold. The possible values are from 1 to 100.
     * @return $this
     */
    public function setTranscriptionConfidenceThreshold($transcriptionConfidenceThreshold)
    {
        $this->container['transcriptionConfidenceThreshold'] = $transcriptionConfidenceThreshold;

        return $this;
    }

    /**
     * Gets contentSearchEnabled
     * @return bool
     */
    public function getContentSearchEnabled()
    {
        return $this->container['contentSearchEnabled'];
    }

    /**
     * Sets contentSearchEnabled
     * @param bool $contentSearchEnabled Setting to enable/disable content search
     * @return $this
     */
    public function setContentSearchEnabled($contentSearchEnabled)
    {
        $this->container['contentSearchEnabled'] = $contentSearchEnabled;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
