<?php

/**
 * WorkforceManagementApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use PureCloudSDK\Configuration;
use PureCloudSDK\ApiClient;
use PureCloudSDK\ApiException;
use PureCloudSDK\ObjectSerializer;

/**
 * WorkforceManagementApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WorkforceManagementApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return WorkforceManagementApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunit
     *
     * Delete management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunit($muId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWithHttpInfo
     *
     * Delete management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling deleteWorkforcemanagementManagementunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitActivitycode
     *
     * Deletes an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitActivitycode($muId, $acId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitActivitycodeWithHttpInfo
     *
     * Deletes an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling deleteWorkforcemanagementManagementunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling deleteWorkforcemanagementManagementunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitSchedulingRun
     *
     * Cancel a schedule run
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitSchedulingRun($managementUnitId, $runId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitSchedulingRunWithHttpInfo
     *
     * Cancel a schedule run
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling deleteWorkforcemanagementManagementunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitServicegoalgroup
     *
     * Delete a service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId The ID of the service goal group to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitServicegoalgroup($managementUnitId, $serviceGoalGroupId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo
     *
     * Delete a service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId The ID of the service goal group to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitServicegoalgroup');
        }
        // verify the required parameter 'serviceGoalGroupId' is set
        if ($serviceGoalGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalGroupId when calling deleteWorkforcemanagementManagementunitServicegoalgroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekSchedule
     *
     * Delete a schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of theschedule to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekSchedule($managementUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekScheduleWithHttpInfo
     *
     * Delete a schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of theschedule to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling deleteWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling deleteWorkforcemanagementManagementunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekShorttermforecast
     *
     * Delete a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekShorttermforecast($managementUnitId, $weekDateId, $forecastId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWeekShorttermforecastWithHttpInfo($managementUnitId, $weekDateId, $forecastId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWeekShorttermforecastWithHttpInfo
     *
     * Delete a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId The ID of the forecast (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWeekShorttermforecastWithHttpInfo($managementUnitId, $weekDateId, $forecastId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitWeekShorttermforecast');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling deleteWorkforcemanagementManagementunitWeekShorttermforecast');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling deleteWorkforcemanagementManagementunitWeekShorttermforecast');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWorkplan
     *
     * Delete a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to delete (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWorkplan($managementUnitId, $workPlanId)
    {
        list($response) = $this->deleteWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId);
        return $response;
    }

    /**
     * Operation deleteWorkforcemanagementManagementunitWorkplanWithHttpInfo
     *
     * Delete a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to delete (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling deleteWorkforcemanagementManagementunitWorkplan');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling deleteWorkforcemanagementManagementunitWorkplan');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementAdherence
     *
     * Get a list of UserScheduleAdherence records for the requested users
     *
     * @param string[] $userId User Id(s) for which to fetch current schedule adherence information.  Min 1, Max of 100 userIds per request (required)
     * @return \PureCloudSDK\UserScheduleAdherence[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdherence($userId)
    {
        list($response) = $this->getWorkforcemanagementAdherenceWithHttpInfo($userId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementAdherenceWithHttpInfo
     *
     * Get a list of UserScheduleAdherence records for the requested users
     *
     * @param string[] $userId User Id(s) for which to fetch current schedule adherence information.  Min 1, Max of 100 userIds per request (required)
     * @return Array of \PureCloudSDK\UserScheduleAdherence[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdherenceWithHttpInfo($userId)
    {
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling getWorkforcemanagementAdherence');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/adherence";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($userId)) {
            $userId = $this->apiClient->getSerializer()->serializeCollection($userId, 'multi', true);
        }
        if ($userId !== null) {
            $queryParams['userId'] = $this->apiClient->getSerializer()->toQueryValue($userId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UserScheduleAdherence[]',
                '/api/v2/workforcemanagement/adherence'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UserScheduleAdherence[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UserScheduleAdherence[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementAdhocmodelingjob
     *
     * Get status of the modeling job
     *
     * @param string $jobId The id of the modeling job (required)
     * @return \PureCloudSDK\ModelingStatusResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdhocmodelingjob($jobId)
    {
        list($response) = $this->getWorkforcemanagementAdhocmodelingjobWithHttpInfo($jobId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementAdhocmodelingjobWithHttpInfo
     *
     * Get status of the modeling job
     *
     * @param string $jobId The id of the modeling job (required)
     * @return Array of \PureCloudSDK\ModelingStatusResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementAdhocmodelingjobWithHttpInfo($jobId)
    {
        // verify the required parameter 'jobId' is set
        if ($jobId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $jobId when calling getWorkforcemanagementAdhocmodelingjob');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/adhocmodelingjobs/{jobId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($jobId !== null) {
            $resourcePath = str_replace(
                "{" . "jobId" . "}",
                $this->apiClient->getSerializer()->toPathValue($jobId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ModelingStatusResponse',
                '/api/v2/workforcemanagement/adhocmodelingjobs/{jobId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ModelingStatusResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ModelingStatusResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunit
     *
     * Get management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $expand  (optional)
     * @return \PureCloudSDK\ManagementUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunit($muId, $expand = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWithHttpInfo($muId, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWithHttpInfo
     *
     * Get management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $expand  (optional)
     * @return Array of \PureCloudSDK\ManagementUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWithHttpInfo($muId, $expand = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunit');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnit',
                '/api/v2/workforcemanagement/managementunits/{muId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycode
     *
     * Get an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to fetch (required)
     * @return \PureCloudSDK\ActivityCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycode($muId, $acId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycodeWithHttpInfo
     *
     * Get an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to fetch (required)
     * @return Array of \PureCloudSDK\ActivityCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling getWorkforcemanagementManagementunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ActivityCode',
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ActivityCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ActivityCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycodes
     *
     * Get activity codes
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\ActivityCodeContainer
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycodes($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitActivitycodesWithHttpInfo
     *
     * Get activity codes
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\ActivityCodeContainer, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitActivitycodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ActivityCodeContainer',
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ActivityCodeContainer', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ActivityCodeContainer', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitAgent
     *
     * Get data for agent in the management unit
     *
     * @param string $managementUnitId The id of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $agentId The agent id (required)
     * @return \PureCloudSDK\WfmAgent
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAgent($managementUnitId, $agentId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitAgentWithHttpInfo($managementUnitId, $agentId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitAgentWithHttpInfo
     *
     * Get data for agent in the management unit
     *
     * @param string $managementUnitId The id of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $agentId The agent id (required)
     * @return Array of \PureCloudSDK\WfmAgent, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitAgentWithHttpInfo($managementUnitId, $agentId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitAgent');
        }
        // verify the required parameter 'agentId' is set
        if ($agentId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $agentId when calling getWorkforcemanagementManagementunitAgent');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($agentId !== null) {
            $resourcePath = str_replace(
                "{" . "agentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($agentId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmAgent',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmAgent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmAgent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitIntradayQueues
     *
     * Get intraday queues for the given date
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param string $date yyyy-MM-dd date string interpreted in the configured management unit time zone (required)
     * @return \PureCloudSDK\WfmIntradayQueueListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitIntradayQueues($muId, $date)
    {
        list($response) = $this->getWorkforcemanagementManagementunitIntradayQueuesWithHttpInfo($muId, $date);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitIntradayQueuesWithHttpInfo
     *
     * Get intraday queues for the given date
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param string $date yyyy-MM-dd date string interpreted in the configured management unit time zone (required)
     * @return Array of \PureCloudSDK\WfmIntradayQueueListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitIntradayQueuesWithHttpInfo($muId, $date)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitIntradayQueues');
        }
        // verify the required parameter 'date' is set
        if ($date === null) {
            throw new \InvalidArgumentException('Missing the required parameter $date when calling getWorkforcemanagementManagementunitIntradayQueues');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/intraday/queues";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($date !== null) {
            $queryParams['date'] = $this->apiClient->getSerializer()->toQueryValue($date);
        }
        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmIntradayQueueListing',
                '/api/v2/workforcemanagement/managementunits/{muId}/intraday/queues'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmIntradayQueueListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmIntradayQueueListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRun
     *
     * Gets the status for a specific scheduling run
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return \PureCloudSDK\SchedulingRunResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRun($managementUnitId, $runId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunWithHttpInfo
     *
     * Gets the status for a specific scheduling run
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of \PureCloudSDK\SchedulingRunResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling getWorkforcemanagementManagementunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SchedulingRunResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SchedulingRunResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SchedulingRunResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunResult
     *
     * Gets the result of a specific scheduling run
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return \PureCloudSDK\RescheduleResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunResult($managementUnitId, $runId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSchedulingRunResultWithHttpInfo($managementUnitId, $runId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunResultWithHttpInfo
     *
     * Gets the result of a specific scheduling run
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @return Array of \PureCloudSDK\RescheduleResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunResultWithHttpInfo($managementUnitId, $runId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitSchedulingRunResult');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling getWorkforcemanagementManagementunitSchedulingRunResult');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}/result";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\RescheduleResult',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}/result'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\RescheduleResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\RescheduleResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRuns
     *
     * Get the status of all the ongoing schedule runs
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @return \PureCloudSDK\SchedulingRunListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRuns($managementUnitId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSchedulingRunsWithHttpInfo($managementUnitId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSchedulingRunsWithHttpInfo
     *
     * Get the status of all the ongoing schedule runs
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @return Array of \PureCloudSDK\SchedulingRunListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSchedulingRunsWithHttpInfo($managementUnitId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitSchedulingRuns');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SchedulingRunListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SchedulingRunListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SchedulingRunListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroup
     *
     * Get a service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId The ID of the service goal group to fetch (required)
     * @return \PureCloudSDK\ServiceGoalGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroup($managementUnitId, $serviceGoalGroupId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo
     *
     * Get a service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId The ID of the service goal group to fetch (required)
     * @return Array of \PureCloudSDK\ServiceGoalGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitServicegoalgroup');
        }
        // verify the required parameter 'serviceGoalGroupId' is set
        if ($serviceGoalGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalGroupId when calling getWorkforcemanagementManagementunitServicegoalgroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalGroup',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroups
     *
     * Get service goal groups
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\ServiceGoalGroupList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroups($managementUnitId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo
     *
     * Get service goal groups
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\ServiceGoalGroupList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitServicegoalgroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalGroupList',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalGroupList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalGroupList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitSettings
     *
     * Get the settings for the requested management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\ManagementUnitSettings
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSettings($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitSettingsWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitSettingsWithHttpInfo
     *
     * Get the settings for the requested management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\ManagementUnitSettings, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitSettingsWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitSettings');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/settings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnitSettings',
                '/api/v2/workforcemanagement/managementunits/{muId}/settings'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnitSettings', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnitSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesMatched
     *
     * Gets a summary of all shift trades in the matched state
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\ShiftTradeMatchesSummaryResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesMatched($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitShifttradesMatchedWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesMatchedWithHttpInfo
     *
     * Gets a summary of all shift trades in the matched state
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\ShiftTradeMatchesSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesMatchedWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitShifttradesMatched');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/matched";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShiftTradeMatchesSummaryResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/matched'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShiftTradeMatchesSummaryResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShiftTradeMatchesSummaryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesUsers
     *
     * Gets list of users available for whom you can send direct shift trade requests
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\WfmUserEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesUsers($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitShifttradesUsersWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitShifttradesUsersWithHttpInfo
     *
     * Gets list of users available for whom you can send direct shift trade requests
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\WfmUserEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitShifttradesUsersWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitShifttradesUsers');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/users";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmUserEntityListing',
                '/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/users'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmUserEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmUserEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequest
     *
     * Get a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequest($muId, $userId, $timeOffRequestId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo
     *
     * Get a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling getWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling getWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($userId !== null) {
            $resourcePath = str_replace(
                "{" . "userId" . "}",
                $this->apiClient->getSerializer()->toPathValue($userId),
                $resourcePath
            );
        }
        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequests
     *
     * Get a list of time off requests for a given user
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return \PureCloudSDK\TimeOffRequestList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequests($muId, $userId, $recentlyReviewed = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitUserTimeoffrequestsWithHttpInfo($muId, $userId, $recentlyReviewed);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitUserTimeoffrequestsWithHttpInfo
     *
     * Get a list of time off requests for a given user
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The userId to whom the Time Off Request applies. (required)
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return Array of \PureCloudSDK\TimeOffRequestList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUserTimeoffrequestsWithHttpInfo($muId, $userId, $recentlyReviewed = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitUserTimeoffrequests');
        }
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling getWorkforcemanagementManagementunitUserTimeoffrequests');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($recentlyReviewed !== null) {
            $queryParams['recentlyReviewed'] = $this->apiClient->getSerializer()->toQueryValue($recentlyReviewed);
        }
        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($userId !== null) {
            $resourcePath = str_replace(
                "{" . "userId" . "}",
                $this->apiClient->getSerializer()->toPathValue($userId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestList',
                '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitUsers
     *
     * Get users in the management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return \PureCloudSDK\WfmUserEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUsers($muId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitUsersWithHttpInfo($muId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitUsersWithHttpInfo
     *
     * Get users in the management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @return Array of \PureCloudSDK\WfmUserEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitUsersWithHttpInfo($muId)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling getWorkforcemanagementManagementunitUsers');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmUserEntityListing',
                '/api/v2/workforcemanagement/managementunits/{muId}/users'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmUserEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmUserEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekSchedule
     *
     * Get a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to fetch (required)
     * @param string $expand Which fields, if any, to expand (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\WeekScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekSchedule($managementUnitId, $weekId, $scheduleId, $expand = null, $forceDownloadService = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $expand, $forceDownloadService);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekScheduleWithHttpInfo
     *
     * Get a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to fetch (required)
     * @param string $expand Which fields, if any, to expand (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\WeekScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $expand = null, $forceDownloadService = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getWorkforcemanagementManagementunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WeekScheduleResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WeekScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekScheduleGenerationresults
     *
     * Get week schedule generation results
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to fetch generation results (required)
     * @return \PureCloudSDK\WeekScheduleGenerationResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekScheduleGenerationresults($managementUnitId, $weekId, $scheduleId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekScheduleGenerationresultsWithHttpInfo($managementUnitId, $weekId, $scheduleId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekScheduleGenerationresultsWithHttpInfo
     *
     * Get week schedule generation results
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to fetch generation results (required)
     * @return Array of \PureCloudSDK\WeekScheduleGenerationResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekScheduleGenerationresultsWithHttpInfo($managementUnitId, $weekId, $scheduleId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekScheduleGenerationresults');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementManagementunitWeekScheduleGenerationresults');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getWorkforcemanagementManagementunitWeekScheduleGenerationresults');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WeekScheduleGenerationResult',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WeekScheduleGenerationResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WeekScheduleGenerationResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekSchedules
     *
     * Get the list of schedules in a week in management unit
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return \PureCloudSDK\WeekScheduleListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekSchedules($managementUnitId, $weekId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo
     *
     * Get the list of schedules in a week in management unit
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @return Array of \PureCloudSDK\WeekScheduleListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekSchedules');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling getWorkforcemanagementManagementunitWeekSchedules');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WeekScheduleListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WeekScheduleListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WeekScheduleListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecastFinal
     *
     * Get the final result of a short term forecast calculation with modifications applied
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId The ID of the forecast (required)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\ForecastResultResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecastFinal($managementUnitId, $weekDateId, $forecastId, $forceDownloadService = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekShorttermforecastFinalWithHttpInfo($managementUnitId, $weekDateId, $forecastId, $forceDownloadService);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecastFinalWithHttpInfo
     *
     * Get the final result of a short term forecast calculation with modifications applied
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId The ID of the forecast (required)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\ForecastResultResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecastFinalWithHttpInfo($managementUnitId, $weekDateId, $forecastId, $forceDownloadService = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekShorttermforecastFinal');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementManagementunitWeekShorttermforecastFinal');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling getWorkforcemanagementManagementunitWeekShorttermforecastFinal');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/final";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ForecastResultResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/final'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ForecastResultResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ForecastResultResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecasts
     *
     * Get short term forecasts
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @return \PureCloudSDK\ShortTermForecastListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecasts($managementUnitId, $weekDateId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo
     *
     * Get short term forecasts
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @return Array of \PureCloudSDK\ShortTermForecastListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling getWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShortTermForecastListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShortTermForecastListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplan
     *
     * Get a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to fetch (required)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplan($managementUnitId, $workPlanId)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplanWithHttpInfo
     *
     * Get a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to fetch (required)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWorkplan');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling getWorkforcemanagementManagementunitWorkplan');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplans
     *
     * Get work plans
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return \PureCloudSDK\WorkPlanListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplans($managementUnitId, $expand = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $expand);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitWorkplansWithHttpInfo
     *
     * Get work plans
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string[] $expand  (optional)
     * @return Array of \PureCloudSDK\WorkPlanListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $expand = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling getWorkforcemanagementManagementunitWorkplans');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($expand)) {
            $expand = $this->apiClient->getSerializer()->serializeCollection($expand, 'multi', true);
        }
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlanListResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlanListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlanListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunits
     *
     * Get management units
     *
     * @param int $pageSize  (optional)
     * @param int $pageNumber  (optional)
     * @param string $expand  (optional)
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return \PureCloudSDK\ManagementUnitListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunits($pageSize = null, $pageNumber = null, $expand = null, $feature = null, $divisionId = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitsWithHttpInfo($pageSize, $pageNumber, $expand, $feature, $divisionId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitsWithHttpInfo
     *
     * Get management units
     *
     * @param int $pageSize  (optional)
     * @param int $pageNumber  (optional)
     * @param string $expand  (optional)
     * @param string $feature  (optional)
     * @param string $divisionId  (optional)
     * @return Array of \PureCloudSDK\ManagementUnitListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitsWithHttpInfo($pageSize = null, $pageNumber = null, $expand = null, $feature = null, $divisionId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($feature !== null) {
            $queryParams['feature'] = $this->apiClient->getSerializer()->toQueryValue($feature);
        }
        // query params
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnitListing',
                '/api/v2/workforcemanagement/managementunits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnitListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnitListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementManagementunitsDivisionviews
     *
     * Get management units across divisions
     *
     * @param string[] $divisionId The divisionIds to filter by. If omitted, will return all divisions (optional)
     * @return \PureCloudSDK\ManagementUnitListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitsDivisionviews($divisionId = null)
    {
        list($response) = $this->getWorkforcemanagementManagementunitsDivisionviewsWithHttpInfo($divisionId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementManagementunitsDivisionviewsWithHttpInfo
     *
     * Get management units across divisions
     *
     * @param string[] $divisionId The divisionIds to filter by. If omitted, will return all divisions (optional)
     * @return Array of \PureCloudSDK\ManagementUnitListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementManagementunitsDivisionviewsWithHttpInfo($divisionId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/divisionviews";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($divisionId)) {
            $divisionId = $this->apiClient->getSerializer()->serializeCollection($divisionId, 'multi', true);
        }
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnitListing',
                '/api/v2/workforcemanagement/managementunits/divisionviews'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnitListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnitListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementNotifications
     *
     * Get a list of notifications for the current user
     *
     * @return \PureCloudSDK\NotificationsResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementNotifications()
    {
        list($response) = $this->getWorkforcemanagementNotificationsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getWorkforcemanagementNotificationsWithHttpInfo
     *
     * Get a list of notifications for the current user
     *
     * @return Array of \PureCloudSDK\NotificationsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementNotificationsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/notifications";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\NotificationsResponse',
                '/api/v2/workforcemanagement/notifications'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\NotificationsResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\NotificationsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementSchedulingjob
     *
     * Get status of the scheduling job
     *
     * @param string $jobId The id of the scheduling job (required)
     * @return \PureCloudSDK\SchedulingStatusResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementSchedulingjob($jobId)
    {
        list($response) = $this->getWorkforcemanagementSchedulingjobWithHttpInfo($jobId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementSchedulingjobWithHttpInfo
     *
     * Get status of the scheduling job
     *
     * @param string $jobId The id of the scheduling job (required)
     * @return Array of \PureCloudSDK\SchedulingStatusResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementSchedulingjobWithHttpInfo($jobId)
    {
        // verify the required parameter 'jobId' is set
        if ($jobId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $jobId when calling getWorkforcemanagementSchedulingjob');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/schedulingjobs/{jobId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($jobId !== null) {
            $resourcePath = str_replace(
                "{" . "jobId" . "}",
                $this->apiClient->getSerializer()->toPathValue($jobId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SchedulingStatusResponse',
                '/api/v2/workforcemanagement/schedulingjobs/{jobId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SchedulingStatusResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SchedulingStatusResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementShifttrades
     *
     * Gets all of my shift trades
     *
     * @return \PureCloudSDK\ShiftTradeListResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementShifttrades()
    {
        list($response) = $this->getWorkforcemanagementShifttradesWithHttpInfo();
        return $response;
    }

    /**
     * Operation getWorkforcemanagementShifttradesWithHttpInfo
     *
     * Gets all of my shift trades
     *
     * @return Array of \PureCloudSDK\ShiftTradeListResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementShifttradesWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/shifttrades";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShiftTradeListResponse',
                '/api/v2/workforcemanagement/shifttrades'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShiftTradeListResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShiftTradeListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequest
     *
     * Get a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequest($timeOffRequestId)
    {
        list($response) = $this->getWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequestWithHttpInfo
     *
     * Get a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId)
    {
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling getWorkforcemanagementTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequests
     *
     * Get a list of time off requests for the current user
     *
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return \PureCloudSDK\TimeOffRequestList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequests($recentlyReviewed = null)
    {
        list($response) = $this->getWorkforcemanagementTimeoffrequestsWithHttpInfo($recentlyReviewed);
        return $response;
    }

    /**
     * Operation getWorkforcemanagementTimeoffrequestsWithHttpInfo
     *
     * Get a list of time off requests for the current user
     *
     * @param bool $recentlyReviewed Limit results to requests that have been reviewed within the preceding 30 days (optional, default to false)
     * @return Array of \PureCloudSDK\TimeOffRequestList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getWorkforcemanagementTimeoffrequestsWithHttpInfo($recentlyReviewed = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($recentlyReviewed !== null) {
            $queryParams['recentlyReviewed'] = $this->apiClient->getSerializer()->toQueryValue($recentlyReviewed);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestList',
                '/api/v2/workforcemanagement/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitActivitycode
     *
     * Update an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to update (required)
     * @param \PureCloudSDK\UpdateActivityCodeRequest $body body (optional)
     * @return \PureCloudSDK\ActivityCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitActivitycode($muId, $acId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitActivitycodeWithHttpInfo
     *
     * Update an activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $acId The ID of the activity code to update (required)
     * @param \PureCloudSDK\UpdateActivityCodeRequest $body body (optional)
     * @return Array of \PureCloudSDK\ActivityCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitActivitycodeWithHttpInfo($muId, $acId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling patchWorkforcemanagementManagementunitActivitycode');
        }
        // verify the required parameter 'acId' is set
        if ($acId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $acId when calling patchWorkforcemanagementManagementunitActivitycode');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($acId !== null) {
            $resourcePath = str_replace(
                "{" . "acId" . "}",
                $this->apiClient->getSerializer()->toPathValue($acId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ActivityCode',
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ActivityCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ActivityCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSchedulingRun
     *
     * Marks a specific scheduling run as applied, allowing a new rescheduling run to be started
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @param \PureCloudSDK\UpdateSchedulingRunRequest $body body (optional)
     * @return \PureCloudSDK\RescheduleResult
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSchedulingRun($managementUnitId, $runId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSchedulingRunWithHttpInfo
     *
     * Marks a specific scheduling run as applied, allowing a new rescheduling run to be started
     *
     * @param string $managementUnitId The ID of the management unit. (required)
     * @param string $runId The ID of the schedule run (required)
     * @param \PureCloudSDK\UpdateSchedulingRunRequest $body body (optional)
     * @return Array of \PureCloudSDK\RescheduleResult, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSchedulingRunWithHttpInfo($managementUnitId, $runId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitSchedulingRun');
        }
        // verify the required parameter 'runId' is set
        if ($runId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $runId when calling patchWorkforcemanagementManagementunitSchedulingRun');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($runId !== null) {
            $resourcePath = str_replace(
                "{" . "runId" . "}",
                $this->apiClient->getSerializer()->toPathValue($runId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\RescheduleResult',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\RescheduleResult', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\RescheduleResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitServicegoalgroup
     *
     * Update a service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId The ID of the service goal group to update (required)
     * @param \PureCloudSDK\ServiceGoalGroup $body body (optional)
     * @return \PureCloudSDK\ServiceGoalGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitServicegoalgroup($managementUnitId, $serviceGoalGroupId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo
     *
     * Update a service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $serviceGoalGroupId The ID of the service goal group to update (required)
     * @param \PureCloudSDK\ServiceGoalGroup $body body (optional)
     * @return Array of \PureCloudSDK\ServiceGoalGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitServicegoalgroupWithHttpInfo($managementUnitId, $serviceGoalGroupId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitServicegoalgroup');
        }
        // verify the required parameter 'serviceGoalGroupId' is set
        if ($serviceGoalGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $serviceGoalGroupId when calling patchWorkforcemanagementManagementunitServicegoalgroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($serviceGoalGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "serviceGoalGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($serviceGoalGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalGroup',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSettings
     *
     * Patch the settings for the requested management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\ManagementUnitSettings $body config (optional)
     * @return \PureCloudSDK\ManagementUnitSettings
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSettings($muId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitSettingsWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitSettingsWithHttpInfo
     *
     * Patch the settings for the requested management unit
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\ManagementUnitSettings $body config (optional)
     * @return Array of \PureCloudSDK\ManagementUnitSettings, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitSettingsWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling patchWorkforcemanagementManagementunitSettings');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/settings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnitSettings',
                '/api/v2/workforcemanagement/managementunits/{muId}/settings'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnitSettings', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnitSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitUserTimeoffrequest
     *
     * Update a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The id of the user the requested time off request belongs to (required)
     * @param string $timeOffRequestId The id of the time off request to update (required)
     * @param \PureCloudSDK\AdminTimeOffRequestPatch $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitUserTimeoffrequest($muId, $userId, $timeOffRequestId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo
     *
     * Update a time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $userId The id of the user the requested time off request belongs to (required)
     * @param string $timeOffRequestId The id of the time off request to update (required)
     * @param \PureCloudSDK\AdminTimeOffRequestPatch $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitUserTimeoffrequestWithHttpInfo($muId, $userId, $timeOffRequestId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling patchWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'userId' is set
        if ($userId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $userId when calling patchWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling patchWorkforcemanagementManagementunitUserTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // path params
        if ($userId !== null) {
            $resourcePath = str_replace(
                "{" . "userId" . "}",
                $this->apiClient->getSerializer()->toPathValue($userId),
                $resourcePath
            );
        }
        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWeekSchedule
     *
     * Update a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to update. Use partial uploads of user schedules if activity count in schedule is greater than 17500 (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\UpdateWeekScheduleRequest $body body (optional)
     * @return \PureCloudSDK\AsyncWeekScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWeekSchedule($managementUnitId, $weekId, $scheduleId, $forceAsync = null, $forceDownloadService = null, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $forceAsync, $forceDownloadService, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWeekScheduleWithHttpInfo
     *
     * Update a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to update. Use partial uploads of user schedules if activity count in schedule is greater than 17500 (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\UpdateWeekScheduleRequest $body body (optional)
     * @return Array of \PureCloudSDK\AsyncWeekScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWeekScheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $forceAsync = null, $forceDownloadService = null, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling patchWorkforcemanagementManagementunitWeekSchedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling patchWorkforcemanagementManagementunitWeekSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AsyncWeekScheduleResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AsyncWeekScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncWeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWorkplan
     *
     * Update a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to update (required)
     * @param \PureCloudSDK\WorkPlan $body body (optional)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWorkplan($managementUnitId, $workPlanId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementManagementunitWorkplanWithHttpInfo
     *
     * Update a work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to update (required)
     * @param \PureCloudSDK\WorkPlan $body body (optional)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementManagementunitWorkplanWithHttpInfo($managementUnitId, $workPlanId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling patchWorkforcemanagementManagementunitWorkplan');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling patchWorkforcemanagementManagementunitWorkplan');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchWorkforcemanagementTimeoffrequest
     *
     * Update a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @param \PureCloudSDK\AgentTimeOffRequestPatch $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementTimeoffrequest($timeOffRequestId, $body = null)
    {
        list($response) = $this->patchWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId, $body);
        return $response;
    }

    /**
     * Operation patchWorkforcemanagementTimeoffrequestWithHttpInfo
     *
     * Update a time off request for the current user
     *
     * @param string $timeOffRequestId Time Off Request Id (required)
     * @param \PureCloudSDK\AgentTimeOffRequestPatch $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchWorkforcemanagementTimeoffrequestWithHttpInfo($timeOffRequestId, $body = null)
    {
        // verify the required parameter 'timeOffRequestId' is set
        if ($timeOffRequestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $timeOffRequestId when calling patchWorkforcemanagementTimeoffrequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($timeOffRequestId !== null) {
            $resourcePath = str_replace(
                "{" . "timeOffRequestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($timeOffRequestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementAdherenceHistorical
     *
     * Request a historical adherence report for users across management units
     *
     * @param \PureCloudSDK\WfmHistoricalAdherenceQueryForUsers $body body (optional)
     * @return \PureCloudSDK\WfmHistoricalAdherenceResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementAdherenceHistorical($body = null)
    {
        list($response) = $this->postWorkforcemanagementAdherenceHistoricalWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementAdherenceHistoricalWithHttpInfo
     *
     * Request a historical adherence report for users across management units
     *
     * @param \PureCloudSDK\WfmHistoricalAdherenceQueryForUsers $body body (optional)
     * @return Array of \PureCloudSDK\WfmHistoricalAdherenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementAdherenceHistoricalWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/adherence/historical";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmHistoricalAdherenceResponse',
                '/api/v2/workforcemanagement/adherence/historical'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmHistoricalAdherenceResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmHistoricalAdherenceResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitActivitycodes
     *
     * Create a new activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateActivityCodeRequest $body body (optional)
     * @return \PureCloudSDK\ActivityCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitActivitycodes($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitActivitycodesWithHttpInfo
     *
     * Create a new activity code
     *
     * @param string $muId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateActivityCodeRequest $body body (optional)
     * @return Array of \PureCloudSDK\ActivityCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitActivitycodesWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitActivitycodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/activitycodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ActivityCode',
                '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ActivityCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ActivityCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitHistoricaladherencequery
     *
     * Request a historical adherence report
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param \PureCloudSDK\WfmHistoricalAdherenceQuery $body body (optional)
     * @return \PureCloudSDK\WfmHistoricalAdherenceResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitHistoricaladherencequery($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitHistoricaladherencequeryWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitHistoricaladherencequeryWithHttpInfo
     *
     * Request a historical adherence report
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param \PureCloudSDK\WfmHistoricalAdherenceQuery $body body (optional)
     * @return Array of \PureCloudSDK\WfmHistoricalAdherenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitHistoricaladherencequeryWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitHistoricaladherencequery');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/historicaladherencequery";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WfmHistoricalAdherenceResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/historicaladherencequery'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WfmHistoricalAdherenceResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WfmHistoricalAdherenceResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitIntraday
     *
     * Get intraday data for the given date for the requested queueIds
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param \PureCloudSDK\IntradayQueryDataCommand $body body (optional)
     * @return \PureCloudSDK\IntradayResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitIntraday($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitIntradayWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitIntradayWithHttpInfo
     *
     * Get intraday data for the given date for the requested queueIds
     *
     * @param string $muId The management unit ID of the management unit (required)
     * @param \PureCloudSDK\IntradayQueryDataCommand $body body (optional)
     * @return Array of \PureCloudSDK\IntradayResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitIntradayWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitIntraday');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/intraday";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\IntradayResponse',
                '/api/v2/workforcemanagement/managementunits/{muId}/intraday'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\IntradayResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\IntradayResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitSchedulesSearch
     *
     * Query published schedules for given given time range for set of users
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\UserListScheduleRequestBody $body body (optional)
     * @return \PureCloudSDK\UserScheduleContainer
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitSchedulesSearch($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitSchedulesSearchWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitSchedulesSearchWithHttpInfo
     *
     * Query published schedules for given given time range for set of users
     *
     * @param string $muId The management unit ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\UserListScheduleRequestBody $body body (optional)
     * @return Array of \PureCloudSDK\UserScheduleContainer, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitSchedulesSearchWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitSchedulesSearch');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/schedules/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UserScheduleContainer',
                '/api/v2/workforcemanagement/managementunits/{muId}/schedules/search'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UserScheduleContainer', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UserScheduleContainer', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitServicegoalgroups
     *
     * Create a new service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateServiceGoalGroupRequest $body body (optional)
     * @return \PureCloudSDK\ServiceGoalGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitServicegoalgroups($managementUnitId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo
     *
     * Create a new service goal group
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateServiceGoalGroupRequest $body body (optional)
     * @return Array of \PureCloudSDK\ServiceGoalGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitServicegoalgroupsWithHttpInfo($managementUnitId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitServicegoalgroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ServiceGoalGroup',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ServiceGoalGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ServiceGoalGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequests
     *
     * Create a new time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateAdminTimeOffRequest $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequests($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitTimeoffrequestsWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsWithHttpInfo
     *
     * Create a new time off request
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateAdminTimeOffRequest $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitTimeoffrequests');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestList',
                '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsFetchdetails
     *
     * Gets a list of time off requests from lookup ids
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestLookupList $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestEntityList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsFetchdetails($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitTimeoffrequestsFetchdetailsWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsFetchdetailsWithHttpInfo
     *
     * Gets a list of time off requests from lookup ids
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestLookupList $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestEntityList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsFetchdetailsWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitTimeoffrequestsFetchdetails');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/fetchdetails";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestEntityList',
                '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/fetchdetails'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestEntityList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestEntityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsQuery
     *
     * Gets the lookup ids to fetch the specified set of requests
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestQueryBody $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestLookupList
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsQuery($muId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitTimeoffrequestsQueryWithHttpInfo($muId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitTimeoffrequestsQueryWithHttpInfo
     *
     * Gets the lookup ids to fetch the specified set of requests
     *
     * @param string $muId The muId of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\TimeOffRequestQueryBody $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestLookupList, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitTimeoffrequestsQueryWithHttpInfo($muId, $body = null)
    {
        // verify the required parameter 'muId' is set
        if ($muId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $muId when calling postWorkforcemanagementManagementunitTimeoffrequestsQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($muId !== null) {
            $resourcePath = str_replace(
                "{" . "muId" . "}",
                $this->apiClient->getSerializer()->toPathValue($muId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestLookupList',
                '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestLookupList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestLookupList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleCopy
     *
     * Copy a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to copy from (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\CopyWeekScheduleRequest $body body (optional)
     * @return \PureCloudSDK\AsyncWeekScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleCopy($managementUnitId, $weekId, $scheduleId, $forceAsync = null, $forceDownloadService = null, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekScheduleCopyWithHttpInfo($managementUnitId, $weekId, $scheduleId, $forceAsync, $forceDownloadService, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleCopyWithHttpInfo
     *
     * Copy a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to copy from (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\CopyWeekScheduleRequest $body body (optional)
     * @return Array of \PureCloudSDK\AsyncWeekScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleCopyWithHttpInfo($managementUnitId, $weekId, $scheduleId, $forceAsync = null, $forceDownloadService = null, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekScheduleCopy');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekScheduleCopy');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling postWorkforcemanagementManagementunitWeekScheduleCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AsyncWeekScheduleResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AsyncWeekScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncWeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncWeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleReschedule
     *
     * Start a scheduling run to compute the reschedule. When the scheduling run finishes, a client can get the reschedule changes and then the client can apply them to the schedule, save the schedule, and mark the scheduling run as applied
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to re-optimize (required)
     * @param \PureCloudSDK\RescheduleRequest $body body (optional)
     * @return \PureCloudSDK\AsyncWeekScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleReschedule($managementUnitId, $weekId, $scheduleId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekScheduleRescheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekScheduleRescheduleWithHttpInfo
     *
     * Start a scheduling run to compute the reschedule. When the scheduling run finishes, a client can get the reschedule changes and then the client can apply them to the schedule, save the schedule, and mark the scheduling run as applied
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param string $scheduleId The ID of the schedule to re-optimize (required)
     * @param \PureCloudSDK\RescheduleRequest $body body (optional)
     * @return Array of \PureCloudSDK\AsyncWeekScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekScheduleRescheduleWithHttpInfo($managementUnitId, $weekId, $scheduleId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekScheduleReschedule');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekScheduleReschedule');
        }
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling postWorkforcemanagementManagementunitWeekScheduleReschedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AsyncWeekScheduleResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AsyncWeekScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncWeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedules
     *
     * Add a schedule for a week in management unit using imported data. Use partial uploads of user schedules if activity count in schedule is greater than 17500
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\ImportWeekScheduleRequest $body body (optional)
     * @return \PureCloudSDK\AsyncWeekScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedules($managementUnitId, $weekId, $forceAsync = null, $forceDownloadService = null, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId, $forceAsync, $forceDownloadService, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo
     *
     * Add a schedule for a week in management unit using imported data. Use partial uploads of user schedules if activity count in schedule is greater than 17500
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @param bool $forceDownloadService Force the result of this operation to be sent via download service.  For testing/app development purposes (optional)
     * @param \PureCloudSDK\ImportWeekScheduleRequest $body body (optional)
     * @return Array of \PureCloudSDK\AsyncWeekScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesWithHttpInfo($managementUnitId, $weekId, $forceAsync = null, $forceDownloadService = null, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekSchedules');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekSchedules');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // query params
        if ($forceDownloadService !== null) {
            $queryParams['forceDownloadService'] = $this->apiClient->getSerializer()->toQueryValue($forceDownloadService);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AsyncWeekScheduleResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AsyncWeekScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncWeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AsyncWeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesGenerate
     *
     * Generate a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param \PureCloudSDK\GenerateWeekScheduleRequest $body body (optional)
     * @return \PureCloudSDK\GenerateWeekScheduleResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesGenerate($managementUnitId, $weekId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekSchedulesGenerateWithHttpInfo($managementUnitId, $weekId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesGenerateWithHttpInfo
     *
     * Generate a week schedule
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param \PureCloudSDK\GenerateWeekScheduleRequest $body body (optional)
     * @return Array of \PureCloudSDK\GenerateWeekScheduleResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesGenerateWithHttpInfo($managementUnitId, $weekId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekSchedulesGenerate');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekSchedulesGenerate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/generate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\GenerateWeekScheduleResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/generate'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\GenerateWeekScheduleResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\GenerateWeekScheduleResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesPartialupload
     *
     * Partial upload of user schedules where activity count is greater than 17500
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param \PureCloudSDK\UserSchedulesPartialUploadRequest $body body (optional)
     * @return \PureCloudSDK\PartialUploadResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesPartialupload($managementUnitId, $weekId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekSchedulesPartialuploadWithHttpInfo($managementUnitId, $weekId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekSchedulesPartialuploadWithHttpInfo
     *
     * Partial upload of user schedules where activity count is greater than 17500
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $weekId First day of schedule week in yyyy-MM-dd format. (required)
     * @param \PureCloudSDK\UserSchedulesPartialUploadRequest $body body (optional)
     * @return Array of \PureCloudSDK\PartialUploadResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekSchedulesPartialuploadWithHttpInfo($managementUnitId, $weekId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekSchedulesPartialupload');
        }
        // verify the required parameter 'weekId' is set
        if ($weekId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekId when calling postWorkforcemanagementManagementunitWeekSchedulesPartialupload');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/partialupload";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekId !== null) {
            $resourcePath = str_replace(
                "{" . "weekId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PartialUploadResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/partialupload'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PartialUploadResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PartialUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastCopy
     *
     * Copy a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId The ID of the forecast to copy (required)
     * @param \PureCloudSDK\CopyShortTermForecastRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\ShortTermForecastResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastCopy($managementUnitId, $weekDateId, $forecastId, $body, $forceAsync = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastCopyWithHttpInfo($managementUnitId, $weekDateId, $forecastId, $body, $forceAsync);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastCopyWithHttpInfo
     *
     * Copy a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param string $forecastId The ID of the forecast to copy (required)
     * @param \PureCloudSDK\CopyShortTermForecastRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\ShortTermForecastResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastCopyWithHttpInfo($managementUnitId, $weekDateId, $forecastId, $body, $forceAsync = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'forecastId' is set
        if ($forecastId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $forecastId when calling postWorkforcemanagementManagementunitWeekShorttermforecastCopy');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShorttermforecastCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // path params
        if ($forecastId !== null) {
            $resourcePath = str_replace(
                "{" . "forecastId" . "}",
                $this->apiClient->getSerializer()->toPathValue($forecastId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShortTermForecastResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShortTermForecastResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecasts
     *
     * Import a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param \PureCloudSDK\ImportShortTermForecastRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\ShortTermForecastResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecasts($managementUnitId, $weekDateId, $body, $forceAsync = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId, $body, $forceAsync);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo
     *
     * Import a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param \PureCloudSDK\ImportShortTermForecastRequest $body body (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\ShortTermForecastResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsWithHttpInfo($managementUnitId, $weekDateId, $body, $forceAsync = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShorttermforecasts');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ShortTermForecastResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ShortTermForecastResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate
     *
     * Generate a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param \PureCloudSDK\GenerateShortTermForecastRequest $body  (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return \PureCloudSDK\GenerateShortTermForecastResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate($managementUnitId, $weekDateId, $body, $forceAsync = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastsGenerateWithHttpInfo($managementUnitId, $weekDateId, $body, $forceAsync);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsGenerateWithHttpInfo
     *
     * Generate a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param \PureCloudSDK\GenerateShortTermForecastRequest $body  (required)
     * @param bool $forceAsync Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes (optional)
     * @return Array of \PureCloudSDK\GenerateShortTermForecastResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsGenerateWithHttpInfo($managementUnitId, $weekDateId, $body, $forceAsync = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShorttermforecastsGenerate');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/generate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($forceAsync !== null) {
            $queryParams['forceAsync'] = $this->apiClient->getSerializer()->toQueryValue($forceAsync);
        }
        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\GenerateShortTermForecastResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/generate'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\GenerateShortTermForecastResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\GenerateShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ShortTermForecastResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload
     *
     * Import a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param \PureCloudSDK\RouteGroupList $body body (required)
     * @return \PureCloudSDK\PartialUploadResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload($managementUnitId, $weekDateId, $body)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWeekShorttermforecastsPartialuploadWithHttpInfo($managementUnitId, $weekDateId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWeekShorttermforecastsPartialuploadWithHttpInfo
     *
     * Import a short term forecast
     *
     * @param string $managementUnitId The management unit ID of the management unit to which the forecast belongs (required)
     * @param string $weekDateId The week start date of the forecast in yyyy-MM-dd format (required)
     * @param \PureCloudSDK\RouteGroupList $body body (required)
     * @return Array of \PureCloudSDK\PartialUploadResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWeekShorttermforecastsPartialuploadWithHttpInfo($managementUnitId, $weekDateId, $body)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload');
        }
        // verify the required parameter 'weekDateId' is set
        if ($weekDateId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $weekDateId when calling postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postWorkforcemanagementManagementunitWeekShorttermforecastsPartialupload');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/partialupload";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($weekDateId !== null) {
            $resourcePath = str_replace(
                "{" . "weekDateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($weekDateId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PartialUploadResponse',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/partialupload'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PartialUploadResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PartialUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplanCopy
     *
     * Create a copy of work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to create a copy (required)
     * @param \PureCloudSDK\CopyWorkPlan $body body (optional)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplanCopy($managementUnitId, $workPlanId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWorkplanCopyWithHttpInfo($managementUnitId, $workPlanId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplanCopyWithHttpInfo
     *
     * Create a copy of work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param string $workPlanId The ID of the work plan to create a copy (required)
     * @param \PureCloudSDK\CopyWorkPlan $body body (optional)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplanCopyWithHttpInfo($managementUnitId, $workPlanId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWorkplanCopy');
        }
        // verify the required parameter 'workPlanId' is set
        if ($workPlanId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workPlanId when calling postWorkforcemanagementManagementunitWorkplanCopy');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}/copy";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // path params
        if ($workPlanId !== null) {
            $resourcePath = str_replace(
                "{" . "workPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workPlanId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}/copy'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplans
     *
     * Create a new work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateWorkPlan $body body (optional)
     * @return \PureCloudSDK\WorkPlan
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplans($managementUnitId, $body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitWorkplansWithHttpInfo
     *
     * Create a new work plan
     *
     * @param string $managementUnitId The ID of the management unit, or &#39;mine&#39; for the management unit of the logged-in user. (required)
     * @param \PureCloudSDK\CreateWorkPlan $body body (optional)
     * @return Array of \PureCloudSDK\WorkPlan, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitWorkplansWithHttpInfo($managementUnitId, $body = null)
    {
        // verify the required parameter 'managementUnitId' is set
        if ($managementUnitId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $managementUnitId when calling postWorkforcemanagementManagementunitWorkplans');
        }
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($managementUnitId !== null) {
            $resourcePath = str_replace(
                "{" . "managementUnitId" . "}",
                $this->apiClient->getSerializer()->toPathValue($managementUnitId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WorkPlan',
                '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WorkPlan', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WorkPlan', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementManagementunits
     *
     * Add a management unit
     *
     * @param \PureCloudSDK\CreateManagementUnitApiRequest $body body (optional)
     * @return \PureCloudSDK\ManagementUnit
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunits($body = null)
    {
        list($response) = $this->postWorkforcemanagementManagementunitsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementManagementunitsWithHttpInfo
     *
     * Add a management unit
     *
     * @param \PureCloudSDK\CreateManagementUnitApiRequest $body body (optional)
     * @return Array of \PureCloudSDK\ManagementUnit, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementManagementunitsWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/managementunits";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ManagementUnit',
                '/api/v2/workforcemanagement/managementunits'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ManagementUnit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ManagementUnit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementNotificationsUpdate
     *
     * Mark a list of notifications as read or unread
     *
     * @param \PureCloudSDK\UpdateNotificationsRequest $body body (optional)
     * @return \PureCloudSDK\UpdateNotificationsResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementNotificationsUpdate($body = null)
    {
        list($response) = $this->postWorkforcemanagementNotificationsUpdateWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementNotificationsUpdateWithHttpInfo
     *
     * Mark a list of notifications as read or unread
     *
     * @param \PureCloudSDK\UpdateNotificationsRequest $body body (optional)
     * @return Array of \PureCloudSDK\UpdateNotificationsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementNotificationsUpdateWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/notifications/update";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UpdateNotificationsResponse',
                '/api/v2/workforcemanagement/notifications/update'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UpdateNotificationsResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UpdateNotificationsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementSchedules
     *
     * Get published schedule for the current user
     *
     * @param \PureCloudSDK\CurrentUserScheduleRequestBody $body body (optional)
     * @return \PureCloudSDK\UserScheduleContainer
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementSchedules($body = null)
    {
        list($response) = $this->postWorkforcemanagementSchedulesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementSchedulesWithHttpInfo
     *
     * Get published schedule for the current user
     *
     * @param \PureCloudSDK\CurrentUserScheduleRequestBody $body body (optional)
     * @return Array of \PureCloudSDK\UserScheduleContainer, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementSchedulesWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\UserScheduleContainer',
                '/api/v2/workforcemanagement/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\UserScheduleContainer', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\UserScheduleContainer', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postWorkforcemanagementTimeoffrequests
     *
     * Create a time off request for the current user
     *
     * @param \PureCloudSDK\CreateAgentTimeOffRequest $body body (optional)
     * @return \PureCloudSDK\TimeOffRequestResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementTimeoffrequests($body = null)
    {
        list($response) = $this->postWorkforcemanagementTimeoffrequestsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postWorkforcemanagementTimeoffrequestsWithHttpInfo
     *
     * Create a time off request for the current user
     *
     * @param \PureCloudSDK\CreateAgentTimeOffRequest $body body (optional)
     * @return Array of \PureCloudSDK\TimeOffRequestResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postWorkforcemanagementTimeoffrequestsWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/workforcemanagement/timeoffrequests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\TimeOffRequestResponse',
                '/api/v2/workforcemanagement/timeoffrequests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\TimeOffRequestResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\TimeOffRequestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
