<?php

/**
 * ExternalContact
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ExternalContact Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ExternalContact implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ExternalContact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'firstName' => 'string',
        'middleName' => 'string',
        'lastName' => 'string',
        'salutation' => 'string',
        'title' => 'string',
        'workPhone' => '\PureCloudSDK\PhoneNumber',
        'cellPhone' => '\PureCloudSDK\PhoneNumber',
        'homePhone' => '\PureCloudSDK\PhoneNumber',
        'otherPhone' => '\PureCloudSDK\PhoneNumber',
        'workEmail' => 'string',
        'personalEmail' => 'string',
        'otherEmail' => 'string',
        'address' => '\PureCloudSDK\ContactAddress',
        'twitterId' => '\PureCloudSDK\TwitterId',
        'lineId' => '\PureCloudSDK\LineId',
        'whatsAppId' => '\PureCloudSDK\WhatsAppId',
        'facebookId' => '\PureCloudSDK\FacebookId',
        'modifyDate' => '\DateTime',
        'createDate' => '\DateTime',
        'externalOrganization' => '\PureCloudSDK\ExternalOrganization',
        'surveyOptOut' => 'bool',
        'externalSystemUrl' => 'string',
        'externalDataSources' => '\PureCloudSDK\ExternalDataSource[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'firstName' => 'firstName',
        'middleName' => 'middleName',
        'lastName' => 'lastName',
        'salutation' => 'salutation',
        'title' => 'title',
        'workPhone' => 'workPhone',
        'cellPhone' => 'cellPhone',
        'homePhone' => 'homePhone',
        'otherPhone' => 'otherPhone',
        'workEmail' => 'workEmail',
        'personalEmail' => 'personalEmail',
        'otherEmail' => 'otherEmail',
        'address' => 'address',
        'twitterId' => 'twitterId',
        'lineId' => 'lineId',
        'whatsAppId' => 'whatsAppId',
        'facebookId' => 'facebookId',
        'modifyDate' => 'modifyDate',
        'createDate' => 'createDate',
        'externalOrganization' => 'externalOrganization',
        'surveyOptOut' => 'surveyOptOut',
        'externalSystemUrl' => 'externalSystemUrl',
        'externalDataSources' => 'externalDataSources',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'firstName' => 'setFirstName',
        'middleName' => 'setMiddleName',
        'lastName' => 'setLastName',
        'salutation' => 'setSalutation',
        'title' => 'setTitle',
        'workPhone' => 'setWorkPhone',
        'cellPhone' => 'setCellPhone',
        'homePhone' => 'setHomePhone',
        'otherPhone' => 'setOtherPhone',
        'workEmail' => 'setWorkEmail',
        'personalEmail' => 'setPersonalEmail',
        'otherEmail' => 'setOtherEmail',
        'address' => 'setAddress',
        'twitterId' => 'setTwitterId',
        'lineId' => 'setLineId',
        'whatsAppId' => 'setWhatsAppId',
        'facebookId' => 'setFacebookId',
        'modifyDate' => 'setModifyDate',
        'createDate' => 'setCreateDate',
        'externalOrganization' => 'setExternalOrganization',
        'surveyOptOut' => 'setSurveyOptOut',
        'externalSystemUrl' => 'setExternalSystemUrl',
        'externalDataSources' => 'setExternalDataSources',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'firstName' => 'getFirstName',
        'middleName' => 'getMiddleName',
        'lastName' => 'getLastName',
        'salutation' => 'getSalutation',
        'title' => 'getTitle',
        'workPhone' => 'getWorkPhone',
        'cellPhone' => 'getCellPhone',
        'homePhone' => 'getHomePhone',
        'otherPhone' => 'getOtherPhone',
        'workEmail' => 'getWorkEmail',
        'personalEmail' => 'getPersonalEmail',
        'otherEmail' => 'getOtherEmail',
        'address' => 'getAddress',
        'twitterId' => 'getTwitterId',
        'lineId' => 'getLineId',
        'whatsAppId' => 'getWhatsAppId',
        'facebookId' => 'getFacebookId',
        'modifyDate' => 'getModifyDate',
        'createDate' => 'getCreateDate',
        'externalOrganization' => 'getExternalOrganization',
        'surveyOptOut' => 'getSurveyOptOut',
        'externalSystemUrl' => 'getExternalSystemUrl',
        'externalDataSources' => 'getExternalDataSources',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['firstName'] = isset($data['firstName']) ? $data['firstName'] : null;
        $this->container['middleName'] = isset($data['middleName']) ? $data['middleName'] : null;
        $this->container['lastName'] = isset($data['lastName']) ? $data['lastName'] : null;
        $this->container['salutation'] = isset($data['salutation']) ? $data['salutation'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['workPhone'] = isset($data['workPhone']) ? $data['workPhone'] : null;
        $this->container['cellPhone'] = isset($data['cellPhone']) ? $data['cellPhone'] : null;
        $this->container['homePhone'] = isset($data['homePhone']) ? $data['homePhone'] : null;
        $this->container['otherPhone'] = isset($data['otherPhone']) ? $data['otherPhone'] : null;
        $this->container['workEmail'] = isset($data['workEmail']) ? $data['workEmail'] : null;
        $this->container['personalEmail'] = isset($data['personalEmail']) ? $data['personalEmail'] : null;
        $this->container['otherEmail'] = isset($data['otherEmail']) ? $data['otherEmail'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['twitterId'] = isset($data['twitterId']) ? $data['twitterId'] : null;
        $this->container['lineId'] = isset($data['lineId']) ? $data['lineId'] : null;
        $this->container['whatsAppId'] = isset($data['whatsAppId']) ? $data['whatsAppId'] : null;
        $this->container['facebookId'] = isset($data['facebookId']) ? $data['facebookId'] : null;
        $this->container['modifyDate'] = isset($data['modifyDate']) ? $data['modifyDate'] : null;
        $this->container['createDate'] = isset($data['createDate']) ? $data['createDate'] : null;
        $this->container['externalOrganization'] = isset($data['externalOrganization']) ? $data['externalOrganization'] : null;
        $this->container['surveyOptOut'] = isset($data['surveyOptOut']) ? $data['surveyOptOut'] : null;
        $this->container['externalSystemUrl'] = isset($data['externalSystemUrl']) ? $data['externalSystemUrl'] : null;
        $this->container['externalDataSources'] = isset($data['externalDataSources']) ? $data['externalDataSources'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['firstName'] === null) {
            $invalid_properties[] = "'firstName' can't be null";
        }
        if ($this->container['lastName'] === null) {
            $invalid_properties[] = "'lastName' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['firstName'] === null) {
            return false;
        }
        if ($this->container['lastName'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets firstName
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['firstName'];
    }

    /**
     * Sets firstName
     * @param string $firstName The first name of the contact.
     * @return $this
     */
    public function setFirstName($firstName)
    {
        $this->container['firstName'] = $firstName;

        return $this;
    }

    /**
     * Gets middleName
     * @return string
     */
    public function getMiddleName()
    {
        return $this->container['middleName'];
    }

    /**
     * Sets middleName
     * @param string $middleName
     * @return $this
     */
    public function setMiddleName($middleName)
    {
        $this->container['middleName'] = $middleName;

        return $this;
    }

    /**
     * Gets lastName
     * @return string
     */
    public function getLastName()
    {
        return $this->container['lastName'];
    }

    /**
     * Sets lastName
     * @param string $lastName The last name of the contact.
     * @return $this
     */
    public function setLastName($lastName)
    {
        $this->container['lastName'] = $lastName;

        return $this;
    }

    /**
     * Gets salutation
     * @return string
     */
    public function getSalutation()
    {
        return $this->container['salutation'];
    }

    /**
     * Sets salutation
     * @param string $salutation
     * @return $this
     */
    public function setSalutation($salutation)
    {
        $this->container['salutation'] = $salutation;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets workPhone
     * @return \PureCloudSDK\PhoneNumber
     */
    public function getWorkPhone()
    {
        return $this->container['workPhone'];
    }

    /**
     * Sets workPhone
     * @param \PureCloudSDK\PhoneNumber $workPhone
     * @return $this
     */
    public function setWorkPhone($workPhone)
    {
        $this->container['workPhone'] = $workPhone;

        return $this;
    }

    /**
     * Gets cellPhone
     * @return \PureCloudSDK\PhoneNumber
     */
    public function getCellPhone()
    {
        return $this->container['cellPhone'];
    }

    /**
     * Sets cellPhone
     * @param \PureCloudSDK\PhoneNumber $cellPhone
     * @return $this
     */
    public function setCellPhone($cellPhone)
    {
        $this->container['cellPhone'] = $cellPhone;

        return $this;
    }

    /**
     * Gets homePhone
     * @return \PureCloudSDK\PhoneNumber
     */
    public function getHomePhone()
    {
        return $this->container['homePhone'];
    }

    /**
     * Sets homePhone
     * @param \PureCloudSDK\PhoneNumber $homePhone
     * @return $this
     */
    public function setHomePhone($homePhone)
    {
        $this->container['homePhone'] = $homePhone;

        return $this;
    }

    /**
     * Gets otherPhone
     * @return \PureCloudSDK\PhoneNumber
     */
    public function getOtherPhone()
    {
        return $this->container['otherPhone'];
    }

    /**
     * Sets otherPhone
     * @param \PureCloudSDK\PhoneNumber $otherPhone
     * @return $this
     */
    public function setOtherPhone($otherPhone)
    {
        $this->container['otherPhone'] = $otherPhone;

        return $this;
    }

    /**
     * Gets workEmail
     * @return string
     */
    public function getWorkEmail()
    {
        return $this->container['workEmail'];
    }

    /**
     * Sets workEmail
     * @param string $workEmail
     * @return $this
     */
    public function setWorkEmail($workEmail)
    {
        $this->container['workEmail'] = $workEmail;

        return $this;
    }

    /**
     * Gets personalEmail
     * @return string
     */
    public function getPersonalEmail()
    {
        return $this->container['personalEmail'];
    }

    /**
     * Sets personalEmail
     * @param string $personalEmail
     * @return $this
     */
    public function setPersonalEmail($personalEmail)
    {
        $this->container['personalEmail'] = $personalEmail;

        return $this;
    }

    /**
     * Gets otherEmail
     * @return string
     */
    public function getOtherEmail()
    {
        return $this->container['otherEmail'];
    }

    /**
     * Sets otherEmail
     * @param string $otherEmail
     * @return $this
     */
    public function setOtherEmail($otherEmail)
    {
        $this->container['otherEmail'] = $otherEmail;

        return $this;
    }

    /**
     * Gets address
     * @return \PureCloudSDK\ContactAddress
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param \PureCloudSDK\ContactAddress $address
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets twitterId
     * @return \PureCloudSDK\TwitterId
     */
    public function getTwitterId()
    {
        return $this->container['twitterId'];
    }

    /**
     * Sets twitterId
     * @param \PureCloudSDK\TwitterId $twitterId
     * @return $this
     */
    public function setTwitterId($twitterId)
    {
        $this->container['twitterId'] = $twitterId;

        return $this;
    }

    /**
     * Gets lineId
     * @return \PureCloudSDK\LineId
     */
    public function getLineId()
    {
        return $this->container['lineId'];
    }

    /**
     * Sets lineId
     * @param \PureCloudSDK\LineId $lineId
     * @return $this
     */
    public function setLineId($lineId)
    {
        $this->container['lineId'] = $lineId;

        return $this;
    }

    /**
     * Gets whatsAppId
     * @return \PureCloudSDK\WhatsAppId
     */
    public function getWhatsAppId()
    {
        return $this->container['whatsAppId'];
    }

    /**
     * Sets whatsAppId
     * @param \PureCloudSDK\WhatsAppId $whatsAppId
     * @return $this
     */
    public function setWhatsAppId($whatsAppId)
    {
        $this->container['whatsAppId'] = $whatsAppId;

        return $this;
    }

    /**
     * Gets facebookId
     * @return \PureCloudSDK\FacebookId
     */
    public function getFacebookId()
    {
        return $this->container['facebookId'];
    }

    /**
     * Sets facebookId
     * @param \PureCloudSDK\FacebookId $facebookId
     * @return $this
     */
    public function setFacebookId($facebookId)
    {
        $this->container['facebookId'] = $facebookId;

        return $this;
    }

    /**
     * Gets modifyDate
     * @return \DateTime
     */
    public function getModifyDate()
    {
        return $this->container['modifyDate'];
    }

    /**
     * Sets modifyDate
     * @param \DateTime $modifyDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifyDate($modifyDate)
    {
        $this->container['modifyDate'] = $modifyDate;

        return $this;
    }

    /**
     * Gets createDate
     * @return \DateTime
     */
    public function getCreateDate()
    {
        return $this->container['createDate'];
    }

    /**
     * Sets createDate
     * @param \DateTime $createDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreateDate($createDate)
    {
        $this->container['createDate'] = $createDate;

        return $this;
    }

    /**
     * Gets externalOrganization
     * @return \PureCloudSDK\ExternalOrganization
     */
    public function getExternalOrganization()
    {
        return $this->container['externalOrganization'];
    }

    /**
     * Sets externalOrganization
     * @param \PureCloudSDK\ExternalOrganization $externalOrganization
     * @return $this
     */
    public function setExternalOrganization($externalOrganization)
    {
        $this->container['externalOrganization'] = $externalOrganization;

        return $this;
    }

    /**
     * Gets surveyOptOut
     * @return bool
     */
    public function getSurveyOptOut()
    {
        return $this->container['surveyOptOut'];
    }

    /**
     * Sets surveyOptOut
     * @param bool $surveyOptOut
     * @return $this
     */
    public function setSurveyOptOut($surveyOptOut)
    {
        $this->container['surveyOptOut'] = $surveyOptOut;

        return $this;
    }

    /**
     * Gets externalSystemUrl
     * @return string
     */
    public function getExternalSystemUrl()
    {
        return $this->container['externalSystemUrl'];
    }

    /**
     * Sets externalSystemUrl
     * @param string $externalSystemUrl A string that identifies an external system-of-record resource that may have more detailed information on the contact. It should be a valid URL (including the http/https protocol, port, and path [if any]). The value is automatically trimmed of any leading and trailing whitespace.
     * @return $this
     */
    public function setExternalSystemUrl($externalSystemUrl)
    {
        $this->container['externalSystemUrl'] = $externalSystemUrl;

        return $this;
    }

    /**
     * Gets externalDataSources
     * @return \PureCloudSDK\ExternalDataSource[]
     */
    public function getExternalDataSources()
    {
        return $this->container['externalDataSources'];
    }

    /**
     * Sets externalDataSources
     * @param \PureCloudSDK\ExternalDataSource[] $externalDataSources Links to the sources of data (e.g. one source might be a CRM) that contributed data to this record.  Read-only, and only populated when requested via expand param.
     * @return $this
     */
    public function setExternalDataSources($externalDataSources)
    {
        $this->container['externalDataSources'] = $externalDataSources;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


