<?php

/**
 * ReportSchedule
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ReportSchedule Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReportSchedule implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReportSchedule';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'quartzCronExpression' => 'string',
        'nextFireTime' => '\DateTime',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'description' => 'string',
        'timeZone' => 'string',
        'timePeriod' => 'string',
        'interval' => 'string',
        'reportFormat' => 'string',
        'locale' => 'string',
        'enabled' => 'bool',
        'reportId' => 'string',
        'parameters' => 'map[string,object]',
        'lastRun' => '\PureCloudSDK\ReportRunEntry',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'quartzCronExpression' => 'quartzCronExpression',
        'nextFireTime' => 'nextFireTime',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'description' => 'description',
        'timeZone' => 'timeZone',
        'timePeriod' => 'timePeriod',
        'interval' => 'interval',
        'reportFormat' => 'reportFormat',
        'locale' => 'locale',
        'enabled' => 'enabled',
        'reportId' => 'reportId',
        'parameters' => 'parameters',
        'lastRun' => 'lastRun',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'quartzCronExpression' => 'setQuartzCronExpression',
        'nextFireTime' => 'setNextFireTime',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'description' => 'setDescription',
        'timeZone' => 'setTimeZone',
        'timePeriod' => 'setTimePeriod',
        'interval' => 'setInterval',
        'reportFormat' => 'setReportFormat',
        'locale' => 'setLocale',
        'enabled' => 'setEnabled',
        'reportId' => 'setReportId',
        'parameters' => 'setParameters',
        'lastRun' => 'setLastRun',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'quartzCronExpression' => 'getQuartzCronExpression',
        'nextFireTime' => 'getNextFireTime',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'description' => 'getDescription',
        'timeZone' => 'getTimeZone',
        'timePeriod' => 'getTimePeriod',
        'interval' => 'getInterval',
        'reportFormat' => 'getReportFormat',
        'locale' => 'getLocale',
        'enabled' => 'getEnabled',
        'reportId' => 'getReportId',
        'parameters' => 'getParameters',
        'lastRun' => 'getLastRun',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['quartzCronExpression'] = isset($data['quartzCronExpression']) ? $data['quartzCronExpression'] : null;
        $this->container['nextFireTime'] = isset($data['nextFireTime']) ? $data['nextFireTime'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['timePeriod'] = isset($data['timePeriod']) ? $data['timePeriod'] : null;
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['reportFormat'] = isset($data['reportFormat']) ? $data['reportFormat'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['reportId'] = isset($data['reportId']) ? $data['reportId'] : null;
        $this->container['parameters'] = isset($data['parameters']) ? $data['parameters'] : null;
        $this->container['lastRun'] = isset($data['lastRun']) ? $data['lastRun'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['quartzCronExpression'] === null) {
            $invalid_properties[] = "'quartzCronExpression' can't be null";
        }
        if ($this->container['reportId'] === null) {
            $invalid_properties[] = "'reportId' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['quartzCronExpression'] === null) {
            return false;
        }
        if ($this->container['reportId'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets quartzCronExpression
     * @return string
     */
    public function getQuartzCronExpression()
    {
        return $this->container['quartzCronExpression'];
    }

    /**
     * Sets quartzCronExpression
     * @param string $quartzCronExpression Quartz Cron Expression
     * @return $this
     */
    public function setQuartzCronExpression($quartzCronExpression)
    {
        $this->container['quartzCronExpression'] = $quartzCronExpression;

        return $this;
    }

    /**
     * Gets nextFireTime
     * @return \DateTime
     */
    public function getNextFireTime()
    {
        return $this->container['nextFireTime'];
    }

    /**
     * Sets nextFireTime
     * @param \DateTime $nextFireTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setNextFireTime($nextFireTime)
    {
        $this->container['nextFireTime'] = $nextFireTime;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets timePeriod
     * @return string
     */
    public function getTimePeriod()
    {
        return $this->container['timePeriod'];
    }

    /**
     * Sets timePeriod
     * @param string $timePeriod
     * @return $this
     */
    public function setTimePeriod($timePeriod)
    {
        $this->container['timePeriod'] = $timePeriod;

        return $this;
    }

    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets reportFormat
     * @return string
     */
    public function getReportFormat()
    {
        return $this->container['reportFormat'];
    }

    /**
     * Sets reportFormat
     * @param string $reportFormat
     * @return $this
     */
    public function setReportFormat($reportFormat)
    {
        $this->container['reportFormat'] = $reportFormat;

        return $this;
    }

    /**
     * Gets locale
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param string $locale
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets reportId
     * @return string
     */
    public function getReportId()
    {
        return $this->container['reportId'];
    }

    /**
     * Sets reportId
     * @param string $reportId Report ID
     * @return $this
     */
    public function setReportId($reportId)
    {
        $this->container['reportId'] = $reportId;

        return $this;
    }

    /**
     * Gets parameters
     * @return map[string,object]
     */
    public function getParameters()
    {
        return $this->container['parameters'];
    }

    /**
     * Sets parameters
     * @param map[string,object] $parameters
     * @return $this
     */
    public function setParameters($parameters)
    {
        $this->container['parameters'] = $parameters;

        return $this;
    }

    /**
     * Gets lastRun
     * @return \PureCloudSDK\ReportRunEntry
     */
    public function getLastRun()
    {
        return $this->container['lastRun'];
    }

    /**
     * Sets lastRun
     * @param \PureCloudSDK\ReportRunEntry $lastRun
     * @return $this
     */
    public function setLastRun($lastRun)
    {
        $this->container['lastRun'] = $lastRun;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


