<?php
/**
 * CampaignInteractions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignInteractions Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignInteractions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignInteractions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'campaign' => '\PureCloudSDK\UriReference',
        'pendingInteractions' => '\PureCloudSDK\CampaignInteraction[]',
        'proceedingInteractions' => '\PureCloudSDK\CampaignInteraction[]',
        'previewingInteractions' => '\PureCloudSDK\CampaignInteraction[]',
        'interactingInteractions' => '\PureCloudSDK\CampaignInteraction[]',
        'scheduledInteractions' => '\PureCloudSDK\CampaignInteraction[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'campaign' => 'campaign',
        'pendingInteractions' => 'pendingInteractions',
        'proceedingInteractions' => 'proceedingInteractions',
        'previewingInteractions' => 'previewingInteractions',
        'interactingInteractions' => 'interactingInteractions',
        'scheduledInteractions' => 'scheduledInteractions'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'campaign' => 'setCampaign',
        'pendingInteractions' => 'setPendingInteractions',
        'proceedingInteractions' => 'setProceedingInteractions',
        'previewingInteractions' => 'setPreviewingInteractions',
        'interactingInteractions' => 'setInteractingInteractions',
        'scheduledInteractions' => 'setScheduledInteractions'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'campaign' => 'getCampaign',
        'pendingInteractions' => 'getPendingInteractions',
        'proceedingInteractions' => 'getProceedingInteractions',
        'previewingInteractions' => 'getPreviewingInteractions',
        'interactingInteractions' => 'getInteractingInteractions',
        'scheduledInteractions' => 'getScheduledInteractions'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['campaign'] = isset($data['campaign']) ? $data['campaign'] : null;
        $this->container['pendingInteractions'] = isset($data['pendingInteractions']) ? $data['pendingInteractions'] : null;
        $this->container['proceedingInteractions'] = isset($data['proceedingInteractions']) ? $data['proceedingInteractions'] : null;
        $this->container['previewingInteractions'] = isset($data['previewingInteractions']) ? $data['previewingInteractions'] : null;
        $this->container['interactingInteractions'] = isset($data['interactingInteractions']) ? $data['interactingInteractions'] : null;
        $this->container['scheduledInteractions'] = isset($data['scheduledInteractions']) ? $data['scheduledInteractions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets campaign
     * @return \PureCloudSDK\UriReference
     */
    public function getCampaign()
    {
        return $this->container['campaign'];
    }

    /**
     * Sets campaign
     * @param \PureCloudSDK\UriReference $campaign
     * @return $this
     */
    public function setCampaign($campaign)
    {
        $this->container['campaign'] = $campaign;

        return $this;
    }

    /**
     * Gets pendingInteractions
     * @return \PureCloudSDK\CampaignInteraction[]
     */
    public function getPendingInteractions()
    {
        return $this->container['pendingInteractions'];
    }

    /**
     * Sets pendingInteractions
     * @param \PureCloudSDK\CampaignInteraction[] $pendingInteractions
     * @return $this
     */
    public function setPendingInteractions($pendingInteractions)
    {
        $this->container['pendingInteractions'] = $pendingInteractions;

        return $this;
    }

    /**
     * Gets proceedingInteractions
     * @return \PureCloudSDK\CampaignInteraction[]
     */
    public function getProceedingInteractions()
    {
        return $this->container['proceedingInteractions'];
    }

    /**
     * Sets proceedingInteractions
     * @param \PureCloudSDK\CampaignInteraction[] $proceedingInteractions
     * @return $this
     */
    public function setProceedingInteractions($proceedingInteractions)
    {
        $this->container['proceedingInteractions'] = $proceedingInteractions;

        return $this;
    }

    /**
     * Gets previewingInteractions
     * @return \PureCloudSDK\CampaignInteraction[]
     */
    public function getPreviewingInteractions()
    {
        return $this->container['previewingInteractions'];
    }

    /**
     * Sets previewingInteractions
     * @param \PureCloudSDK\CampaignInteraction[] $previewingInteractions
     * @return $this
     */
    public function setPreviewingInteractions($previewingInteractions)
    {
        $this->container['previewingInteractions'] = $previewingInteractions;

        return $this;
    }

    /**
     * Gets interactingInteractions
     * @return \PureCloudSDK\CampaignInteraction[]
     */
    public function getInteractingInteractions()
    {
        return $this->container['interactingInteractions'];
    }

    /**
     * Sets interactingInteractions
     * @param \PureCloudSDK\CampaignInteraction[] $interactingInteractions
     * @return $this
     */
    public function setInteractingInteractions($interactingInteractions)
    {
        $this->container['interactingInteractions'] = $interactingInteractions;

        return $this;
    }

    /**
     * Gets scheduledInteractions
     * @return \PureCloudSDK\CampaignInteraction[]
     */
    public function getScheduledInteractions()
    {
        return $this->container['scheduledInteractions'];
    }

    /**
     * Sets scheduledInteractions
     * @param \PureCloudSDK\CampaignInteraction[] $scheduledInteractions
     * @return $this
     */
    public function setScheduledInteractions($scheduledInteractions)
    {
        $this->container['scheduledInteractions'] = $scheduledInteractions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


