<?php
/**
 * FieldList
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FieldList Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FieldList implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FieldList';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'customLabels' => 'bool',
        'instructionText' => 'string',
        'key' => 'string',
        'labelKeys' => 'string[]',
        'params' => 'map[string,object]',
        'repeatable' => 'bool',
        'state' => 'string',
        'type' => 'string',
        'required' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'customLabels' => 'customLabels',
        'instructionText' => 'instructionText',
        'key' => 'key',
        'labelKeys' => 'labelKeys',
        'params' => 'params',
        'repeatable' => 'repeatable',
        'state' => 'state',
        'type' => 'type',
        'required' => 'required'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'customLabels' => 'setCustomLabels',
        'instructionText' => 'setInstructionText',
        'key' => 'setKey',
        'labelKeys' => 'setLabelKeys',
        'params' => 'setParams',
        'repeatable' => 'setRepeatable',
        'state' => 'setState',
        'type' => 'setType',
        'required' => 'setRequired'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'customLabels' => 'getCustomLabels',
        'instructionText' => 'getInstructionText',
        'key' => 'getKey',
        'labelKeys' => 'getLabelKeys',
        'params' => 'getParams',
        'repeatable' => 'getRepeatable',
        'state' => 'getState',
        'type' => 'getType',
        'required' => 'getRequired'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['customLabels'] = isset($data['customLabels']) ? $data['customLabels'] : null;
        $this->container['instructionText'] = isset($data['instructionText']) ? $data['instructionText'] : null;
        $this->container['key'] = isset($data['key']) ? $data['key'] : null;
        $this->container['labelKeys'] = isset($data['labelKeys']) ? $data['labelKeys'] : null;
        $this->container['params'] = isset($data['params']) ? $data['params'] : null;
        $this->container['repeatable'] = isset($data['repeatable']) ? $data['repeatable'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['required'] = isset($data['required']) ? $data['required'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets customLabels
     * @return bool
     */
    public function getCustomLabels()
    {
        return $this->container['customLabels'];
    }

    /**
     * Sets customLabels
     * @param bool $customLabels
     * @return $this
     */
    public function setCustomLabels($customLabels)
    {
        $this->container['customLabels'] = $customLabels;

        return $this;
    }

    /**
     * Gets instructionText
     * @return string
     */
    public function getInstructionText()
    {
        return $this->container['instructionText'];
    }

    /**
     * Sets instructionText
     * @param string $instructionText
     * @return $this
     */
    public function setInstructionText($instructionText)
    {
        $this->container['instructionText'] = $instructionText;

        return $this;
    }

    /**
     * Gets key
     * @return string
     */
    public function getKey()
    {
        return $this->container['key'];
    }

    /**
     * Sets key
     * @param string $key
     * @return $this
     */
    public function setKey($key)
    {
        $this->container['key'] = $key;

        return $this;
    }

    /**
     * Gets labelKeys
     * @return string[]
     */
    public function getLabelKeys()
    {
        return $this->container['labelKeys'];
    }

    /**
     * Sets labelKeys
     * @param string[] $labelKeys
     * @return $this
     */
    public function setLabelKeys($labelKeys)
    {
        $this->container['labelKeys'] = $labelKeys;

        return $this;
    }

    /**
     * Gets params
     * @return map[string,object]
     */
    public function getParams()
    {
        return $this->container['params'];
    }

    /**
     * Sets params
     * @param map[string,object] $params
     * @return $this
     */
    public function setParams($params)
    {
        $this->container['params'] = $params;

        return $this;
    }

    /**
     * Gets repeatable
     * @return bool
     */
    public function getRepeatable()
    {
        return $this->container['repeatable'];
    }

    /**
     * Sets repeatable
     * @param bool $repeatable
     * @return $this
     */
    public function setRepeatable($repeatable)
    {
        $this->container['repeatable'] = $repeatable;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets required
     * @return bool
     */
    public function getRequired()
    {
        return $this->container['required'];
    }

    /**
     * Sets required
     * @param bool $required
     * @return $this
     */
    public function setRequired($required)
    {
        $this->container['required'] = $required;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


