<?php
/**
 * Keyword
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Keyword Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Keyword implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Keyword';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'phrase' => 'string',
        'confidence' => 'int',
        'agentScoreModifier' => 'int',
        'customerScoreModifier' => 'int',
        'alternateSpellings' => 'string[]',
        'pronunciations' => 'string[]',
        'antiWords' => 'string[]',
        'antiPronunciations' => 'string[]',
        'spotabilityIndex' => 'double',
        'marginOfError' => 'double',
        'pronunciation' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'phrase' => 'phrase',
        'confidence' => 'confidence',
        'agentScoreModifier' => 'agentScoreModifier',
        'customerScoreModifier' => 'customerScoreModifier',
        'alternateSpellings' => 'alternateSpellings',
        'pronunciations' => 'pronunciations',
        'antiWords' => 'antiWords',
        'antiPronunciations' => 'antiPronunciations',
        'spotabilityIndex' => 'spotabilityIndex',
        'marginOfError' => 'marginOfError',
        'pronunciation' => 'pronunciation'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'phrase' => 'setPhrase',
        'confidence' => 'setConfidence',
        'agentScoreModifier' => 'setAgentScoreModifier',
        'customerScoreModifier' => 'setCustomerScoreModifier',
        'alternateSpellings' => 'setAlternateSpellings',
        'pronunciations' => 'setPronunciations',
        'antiWords' => 'setAntiWords',
        'antiPronunciations' => 'setAntiPronunciations',
        'spotabilityIndex' => 'setSpotabilityIndex',
        'marginOfError' => 'setMarginOfError',
        'pronunciation' => 'setPronunciation'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'phrase' => 'getPhrase',
        'confidence' => 'getConfidence',
        'agentScoreModifier' => 'getAgentScoreModifier',
        'customerScoreModifier' => 'getCustomerScoreModifier',
        'alternateSpellings' => 'getAlternateSpellings',
        'pronunciations' => 'getPronunciations',
        'antiWords' => 'getAntiWords',
        'antiPronunciations' => 'getAntiPronunciations',
        'spotabilityIndex' => 'getSpotabilityIndex',
        'marginOfError' => 'getMarginOfError',
        'pronunciation' => 'getPronunciation'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['phrase'] = isset($data['phrase']) ? $data['phrase'] : null;
        $this->container['confidence'] = isset($data['confidence']) ? $data['confidence'] : null;
        $this->container['agentScoreModifier'] = isset($data['agentScoreModifier']) ? $data['agentScoreModifier'] : null;
        $this->container['customerScoreModifier'] = isset($data['customerScoreModifier']) ? $data['customerScoreModifier'] : null;
        $this->container['alternateSpellings'] = isset($data['alternateSpellings']) ? $data['alternateSpellings'] : null;
        $this->container['pronunciations'] = isset($data['pronunciations']) ? $data['pronunciations'] : null;
        $this->container['antiWords'] = isset($data['antiWords']) ? $data['antiWords'] : null;
        $this->container['antiPronunciations'] = isset($data['antiPronunciations']) ? $data['antiPronunciations'] : null;
        $this->container['spotabilityIndex'] = isset($data['spotabilityIndex']) ? $data['spotabilityIndex'] : null;
        $this->container['marginOfError'] = isset($data['marginOfError']) ? $data['marginOfError'] : null;
        $this->container['pronunciation'] = isset($data['pronunciation']) ? $data['pronunciation'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['phrase'] === null) {
            $invalid_properties[] = "'phrase' can't be null";
        }
        if ($this->container['confidence'] === null) {
            $invalid_properties[] = "'confidence' can't be null";
        }
        if ($this->container['agentScoreModifier'] === null) {
            $invalid_properties[] = "'agentScoreModifier' can't be null";
        }
        if ($this->container['customerScoreModifier'] === null) {
            $invalid_properties[] = "'customerScoreModifier' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['phrase'] === null) {
            return false;
        }
        if ($this->container['confidence'] === null) {
            return false;
        }
        if ($this->container['agentScoreModifier'] === null) {
            return false;
        }
        if ($this->container['customerScoreModifier'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets phrase
     * @return string
     */
    public function getPhrase()
    {
        return $this->container['phrase'];
    }

    /**
     * Sets phrase
     * @param string $phrase The word or phrase which is being looked for with speech recognition.
     * @return $this
     */
    public function setPhrase($phrase)
    {
        $this->container['phrase'] = $phrase;

        return $this;
    }

    /**
     * Gets confidence
     * @return int
     */
    public function getConfidence()
    {
        return $this->container['confidence'];
    }

    /**
     * Sets confidence
     * @param int $confidence A sensitivity threshold that can be increased to lower false positives or decreased to reduce false negatives.
     * @return $this
     */
    public function setConfidence($confidence)
    {
        $this->container['confidence'] = $confidence;

        return $this;
    }

    /**
     * Gets agentScoreModifier
     * @return int
     */
    public function getAgentScoreModifier()
    {
        return $this->container['agentScoreModifier'];
    }

    /**
     * Sets agentScoreModifier
     * @param int $agentScoreModifier A modifier to the evaluation score when the phrase is spotted in the agent channel
     * @return $this
     */
    public function setAgentScoreModifier($agentScoreModifier)
    {
        $this->container['agentScoreModifier'] = $agentScoreModifier;

        return $this;
    }

    /**
     * Gets customerScoreModifier
     * @return int
     */
    public function getCustomerScoreModifier()
    {
        return $this->container['customerScoreModifier'];
    }

    /**
     * Sets customerScoreModifier
     * @param int $customerScoreModifier A modifier to the evaluation score when the phrase is spotted in the customer channel
     * @return $this
     */
    public function setCustomerScoreModifier($customerScoreModifier)
    {
        $this->container['customerScoreModifier'] = $customerScoreModifier;

        return $this;
    }

    /**
     * Gets alternateSpellings
     * @return string[]
     */
    public function getAlternateSpellings()
    {
        return $this->container['alternateSpellings'];
    }

    /**
     * Sets alternateSpellings
     * @param string[] $alternateSpellings Other spellings of the phrase that can be added to reduce missed spots (false negatives).
     * @return $this
     */
    public function setAlternateSpellings($alternateSpellings)
    {
        $this->container['alternateSpellings'] = $alternateSpellings;

        return $this;
    }

    /**
     * Gets pronunciations
     * @return string[]
     */
    public function getPronunciations()
    {
        return $this->container['pronunciations'];
    }

    /**
     * Sets pronunciations
     * @param string[] $pronunciations The phonetic spellings for the phrase and alternate spellings.
     * @return $this
     */
    public function setPronunciations($pronunciations)
    {
        $this->container['pronunciations'] = $pronunciations;

        return $this;
    }

    /**
     * Gets antiWords
     * @return string[]
     */
    public function getAntiWords()
    {
        return $this->container['antiWords'];
    }

    /**
     * Sets antiWords
     * @param string[] $antiWords Words that are similar to the phrase but not desired. Added to reduce incorrect spots (false positives).
     * @return $this
     */
    public function setAntiWords($antiWords)
    {
        $this->container['antiWords'] = $antiWords;

        return $this;
    }

    /**
     * Gets antiPronunciations
     * @return string[]
     */
    public function getAntiPronunciations()
    {
        return $this->container['antiPronunciations'];
    }

    /**
     * Sets antiPronunciations
     * @param string[] $antiPronunciations The phonetic spellings for the antiWords.
     * @return $this
     */
    public function setAntiPronunciations($antiPronunciations)
    {
        $this->container['antiPronunciations'] = $antiPronunciations;

        return $this;
    }

    /**
     * Gets spotabilityIndex
     * @return double
     */
    public function getSpotabilityIndex()
    {
        return $this->container['spotabilityIndex'];
    }

    /**
     * Sets spotabilityIndex
     * @param double $spotabilityIndex A prediction of how easy it is to unambiguously spot the keyword within its language based on spelling.
     * @return $this
     */
    public function setSpotabilityIndex($spotabilityIndex)
    {
        $this->container['spotabilityIndex'] = $spotabilityIndex;

        return $this;
    }

    /**
     * Gets marginOfError
     * @return double
     */
    public function getMarginOfError()
    {
        return $this->container['marginOfError'];
    }

    /**
     * Sets marginOfError
     * @param double $marginOfError
     * @return $this
     */
    public function setMarginOfError($marginOfError)
    {
        $this->container['marginOfError'] = $marginOfError;

        return $this;
    }

    /**
     * Gets pronunciation
     * @return string
     */
    public function getPronunciation()
    {
        return $this->container['pronunciation'];
    }

    /**
     * Sets pronunciation
     * @param string $pronunciation
     * @return $this
     */
    public function setPronunciation($pronunciation)
    {
        $this->container['pronunciation'] = $pronunciation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


