<?php
/**
 * UserDetailsQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserDetailsQuery Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserDetailsQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserDetailsQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'userFilters' => '\PureCloudSDK\AnalyticsQueryFilter[]',
        'presenceFilters' => '\PureCloudSDK\AnalyticsQueryFilter[]',
        'routingStatusFilters' => '\PureCloudSDK\AnalyticsQueryFilter[]',
        'presenceAggregations' => '\PureCloudSDK\AnalyticsQueryAggregation[]',
        'routingStatusAggregations' => '\PureCloudSDK\AnalyticsQueryAggregation[]',
        'paging' => '\PureCloudSDK\PagingSpec',
        'order' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'userFilters' => 'userFilters',
        'presenceFilters' => 'presenceFilters',
        'routingStatusFilters' => 'routingStatusFilters',
        'presenceAggregations' => 'presenceAggregations',
        'routingStatusAggregations' => 'routingStatusAggregations',
        'paging' => 'paging',
        'order' => 'order'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'userFilters' => 'setUserFilters',
        'presenceFilters' => 'setPresenceFilters',
        'routingStatusFilters' => 'setRoutingStatusFilters',
        'presenceAggregations' => 'setPresenceAggregations',
        'routingStatusAggregations' => 'setRoutingStatusAggregations',
        'paging' => 'setPaging',
        'order' => 'setOrder'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'userFilters' => 'getUserFilters',
        'presenceFilters' => 'getPresenceFilters',
        'routingStatusFilters' => 'getRoutingStatusFilters',
        'presenceAggregations' => 'getPresenceAggregations',
        'routingStatusAggregations' => 'getRoutingStatusAggregations',
        'paging' => 'getPaging',
        'order' => 'getOrder'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ORDER_ASC = 'asc';
    const ORDER_DESC = 'desc';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOrderAllowableValues()
    {
        return [
            self::ORDER_ASC,
            self::ORDER_DESC,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['userFilters'] = isset($data['userFilters']) ? $data['userFilters'] : null;
        $this->container['presenceFilters'] = isset($data['presenceFilters']) ? $data['presenceFilters'] : null;
        $this->container['routingStatusFilters'] = isset($data['routingStatusFilters']) ? $data['routingStatusFilters'] : null;
        $this->container['presenceAggregations'] = isset($data['presenceAggregations']) ? $data['presenceAggregations'] : null;
        $this->container['routingStatusAggregations'] = isset($data['routingStatusAggregations']) ? $data['routingStatusAggregations'] : null;
        $this->container['paging'] = isset($data['paging']) ? $data['paging'] : null;
        $this->container['order'] = isset($data['order']) ? $data['order'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("asc", "desc");
        if (!in_array($this->container['order'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'order', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("asc", "desc");
        if (!in_array($this->container['order'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Specifies the date and time range of data being queried. Conversations MUST have started within this time range to potentially be included within the result set. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets userFilters
     * @return \PureCloudSDK\AnalyticsQueryFilter[]
     */
    public function getUserFilters()
    {
        return $this->container['userFilters'];
    }

    /**
     * Sets userFilters
     * @param \PureCloudSDK\AnalyticsQueryFilter[] $userFilters Filters that target the users to retrieve data for
     * @return $this
     */
    public function setUserFilters($userFilters)
    {
        $this->container['userFilters'] = $userFilters;

        return $this;
    }

    /**
     * Gets presenceFilters
     * @return \PureCloudSDK\AnalyticsQueryFilter[]
     */
    public function getPresenceFilters()
    {
        return $this->container['presenceFilters'];
    }

    /**
     * Sets presenceFilters
     * @param \PureCloudSDK\AnalyticsQueryFilter[] $presenceFilters Filters that target system and organization presence-level data
     * @return $this
     */
    public function setPresenceFilters($presenceFilters)
    {
        $this->container['presenceFilters'] = $presenceFilters;

        return $this;
    }

    /**
     * Gets routingStatusFilters
     * @return \PureCloudSDK\AnalyticsQueryFilter[]
     */
    public function getRoutingStatusFilters()
    {
        return $this->container['routingStatusFilters'];
    }

    /**
     * Sets routingStatusFilters
     * @param \PureCloudSDK\AnalyticsQueryFilter[] $routingStatusFilters Filters that target agent routing status-level data
     * @return $this
     */
    public function setRoutingStatusFilters($routingStatusFilters)
    {
        $this->container['routingStatusFilters'] = $routingStatusFilters;

        return $this;
    }

    /**
     * Gets presenceAggregations
     * @return \PureCloudSDK\AnalyticsQueryAggregation[]
     */
    public function getPresenceAggregations()
    {
        return $this->container['presenceAggregations'];
    }

    /**
     * Sets presenceAggregations
     * @param \PureCloudSDK\AnalyticsQueryAggregation[] $presenceAggregations Include faceted search and aggregate roll-ups of presence data in your search results. This does not function as a filter, but rather, summary data about the presence results matching your filters
     * @return $this
     */
    public function setPresenceAggregations($presenceAggregations)
    {
        $this->container['presenceAggregations'] = $presenceAggregations;

        return $this;
    }

    /**
     * Gets routingStatusAggregations
     * @return \PureCloudSDK\AnalyticsQueryAggregation[]
     */
    public function getRoutingStatusAggregations()
    {
        return $this->container['routingStatusAggregations'];
    }

    /**
     * Sets routingStatusAggregations
     * @param \PureCloudSDK\AnalyticsQueryAggregation[] $routingStatusAggregations Include faceted search and aggregate roll-ups of agent routing status data in your search results. This does not function as a filter, but rather, summary data about the agent routing status results matching your filters
     * @return $this
     */
    public function setRoutingStatusAggregations($routingStatusAggregations)
    {
        $this->container['routingStatusAggregations'] = $routingStatusAggregations;

        return $this;
    }

    /**
     * Gets paging
     * @return \PureCloudSDK\PagingSpec
     */
    public function getPaging()
    {
        return $this->container['paging'];
    }

    /**
     * Sets paging
     * @param \PureCloudSDK\PagingSpec $paging Page size and number to control iterating through large result sets. Default page size is 25
     * @return $this
     */
    public function setPaging($paging)
    {
        $this->container['paging'] = $paging;

        return $this;
    }

    /**
     * Gets order
     * @return string
     */
    public function getOrder()
    {
        return $this->container['order'];
    }

    /**
     * Sets order
     * @param string $order Sort the result set in ascending/descending order. Default is ascending
     * @return $this
     */
    public function setOrder($order)
    {
        $allowed_values = array('asc', 'desc');
        if (!in_array($order, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'order', must be one of 'asc', 'desc'");
        }
        $this->container['order'] = $order;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


