# PureCloudSDK\ConversationsApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConversationsCallsConversationIdParticipantsParticipantIdConsult**](ConversationsApi.md#deleteConversationsCallsConversationIdParticipantsParticipantIdConsult) | **DELETE** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/consult | Cancel the transfer
[**deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode**](ConversationsApi.md#deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode) | **DELETE** /api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode} | Delete a code used to add a communication to this participant
[**deleteConversationsEmailsConversationIdMessagesDraftAttachmentsAttachmentId**](ConversationsApi.md#deleteConversationsEmailsConversationIdMessagesDraftAttachmentsAttachmentId) | **DELETE** /api/v2/conversations/emails/{conversationId}/messages/draft/attachments/{attachmentId} | Delete attachment from draft
[**getAnalyticsConversationsConversationIdDetails**](ConversationsApi.md#getAnalyticsConversationsConversationIdDetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
[**getConversations**](ConversationsApi.md#getConversations) | **GET** /api/v2/conversations | Get conversations
[**getConversationsCallbacks**](ConversationsApi.md#getConversationsCallbacks) | **GET** /api/v2/conversations/callbacks | Get callback conversations
[**getConversationsCallbacksConversationId**](ConversationsApi.md#getConversationsCallbacksConversationId) | **GET** /api/v2/conversations/callbacks/{conversationId} | Get callback conversation
[**getConversationsCallbacksConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsCallbacksConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/callbacks/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsCallbacksConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsCallbacksConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/callbacks/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsCalls**](ConversationsApi.md#getConversationsCalls) | **GET** /api/v2/conversations/calls | Get recent conversations
[**getConversationsCallsConversationId**](ConversationsApi.md#getConversationsCallsConversationId) | **GET** /api/v2/conversations/calls/{conversationId} | Get call conversation
[**getConversationsCallsConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsCallsConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsCallsConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsCallsConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsCallsHistory**](ConversationsApi.md#getConversationsCallsHistory) | **GET** /api/v2/conversations/calls/history | Get call history
[**getConversationsCallsMaximumconferenceparties**](ConversationsApi.md#getConversationsCallsMaximumconferenceparties) | **GET** /api/v2/conversations/calls/maximumconferenceparties | Get the maximum number of participants that this user can have on a conference
[**getConversationsChats**](ConversationsApi.md#getConversationsChats) | **GET** /api/v2/conversations/chats | Get recent chat conversations
[**getConversationsChatsConversationId**](ConversationsApi.md#getConversationsChatsConversationId) | **GET** /api/v2/conversations/chats/{conversationId} | Get chat conversation
[**getConversationsChatsConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsChatsConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/chats/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsChatsConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsChatsConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/chats/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsCobrowsesessions**](ConversationsApi.md#getConversationsCobrowsesessions) | **GET** /api/v2/conversations/cobrowsesessions | Get recent cobrowse conversations
[**getConversationsCobrowsesessionsConversationId**](ConversationsApi.md#getConversationsCobrowsesessionsConversationId) | **GET** /api/v2/conversations/cobrowsesessions/{conversationId} | Get cobrowse conversation
[**getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/cobrowsesessions/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/cobrowsesessions/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsConversationId**](ConversationsApi.md#getConversationsConversationId) | **GET** /api/v2/conversations/{conversationId} | Get conversation
[**getConversationsConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationsEmails**](ConversationsApi.md#getConversationsEmails) | **GET** /api/v2/conversations/emails | Get recent email conversations
[**getConversationsEmailsConversationId**](ConversationsApi.md#getConversationsEmailsConversationId) | **GET** /api/v2/conversations/emails/{conversationId} | Get email conversation
[**getConversationsEmailsConversationIdMessages**](ConversationsApi.md#getConversationsEmailsConversationIdMessages) | **GET** /api/v2/conversations/emails/{conversationId}/messages | Get conversation messages
[**getConversationsEmailsConversationIdMessagesDraft**](ConversationsApi.md#getConversationsEmailsConversationIdMessagesDraft) | **GET** /api/v2/conversations/emails/{conversationId}/messages/draft | Get conversation draft reply
[**getConversationsEmailsConversationIdMessagesMessageId**](ConversationsApi.md#getConversationsEmailsConversationIdMessagesMessageId) | **GET** /api/v2/conversations/emails/{conversationId}/messages/{messageId} | Get conversation message
[**getConversationsEmailsConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationsEmailsConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/emails/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationsEmailsConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationsEmailsConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/emails/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**patchConversationsCallbacksConversationId**](ConversationsApi.md#patchConversationsCallbacksConversationId) | **PATCH** /api/v2/conversations/callbacks/{conversationId} | Update a conversation by disconnecting all of the participants
[**patchConversationsCallbacksConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsCallbacksConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/callbacks/{conversationId}/participants/{participantId} | Update conversation participant
[**patchConversationsCallbacksConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsCallbacksConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/callbacks/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsCallbacksConversationIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsCallbacksConversationIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/callbacks/{conversationId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsCallsConversationId**](ConversationsApi.md#patchConversationsCallsConversationId) | **PATCH** /api/v2/conversations/calls/{conversationId} | Update a conversation by setting it&#39;s recording state, merging in other conversations to create a conference, or disconnecting all of the participants
[**patchConversationsCallsConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsCallsConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/calls/{conversationId}/participants/{participantId} | Update conversation participant
[**patchConversationsCallsConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsCallsConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsCallsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsCallsConversationIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsCallsConversationIdParticipantsParticipantIdConsult**](ConversationsApi.md#patchConversationsCallsConversationIdParticipantsParticipantIdConsult) | **PATCH** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/consult | Change who can speak
[**patchConversationsChatsConversationId**](ConversationsApi.md#patchConversationsChatsConversationId) | **PATCH** /api/v2/conversations/chats/{conversationId} | Update a conversation by disconnecting all of the participants
[**patchConversationsChatsConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsChatsConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/chats/{conversationId}/participants/{participantId} | Update conversation participant
[**patchConversationsChatsConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsChatsConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/chats/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsChatsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsChatsConversationIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/chats/{conversationId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsCobrowsesessionsConversationId**](ConversationsApi.md#patchConversationsCobrowsesessionsConversationId) | **PATCH** /api/v2/conversations/cobrowsesessions/{conversationId} | Update a conversation by disconnecting all of the participants
[**patchConversationsCobrowsesessionsConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsCobrowsesessionsConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/cobrowsesessions/{conversationId}/participants/{participantId} | Update conversation participant
[**patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/cobrowsesessions/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/cobrowsesessions/{conversationId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationsConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId} | Update a participant.
[**patchConversationsConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsEmailsConversationId**](ConversationsApi.md#patchConversationsEmailsConversationId) | **PATCH** /api/v2/conversations/emails/{conversationId} | Update a conversation by disconnecting all of the participants
[**patchConversationsEmailsConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationsEmailsConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/emails/{conversationId}/participants/{participantId} | Update conversation participant
[**patchConversationsEmailsConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationsEmailsConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/emails/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchConversationsEmailsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchConversationsEmailsConversationIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/emails/{conversationId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**postAnalyticsConversationsAggregatesQuery**](ConversationsApi.md#postAnalyticsConversationsAggregatesQuery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
[**postAnalyticsConversationsConversationIdDetailsProperties**](ConversationsApi.md#postAnalyticsConversationsConversationIdDetailsProperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
[**postAnalyticsConversationsDetailsQuery**](ConversationsApi.md#postAnalyticsConversationsDetailsQuery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
[**postConversationsCallbacks**](ConversationsApi.md#postConversationsCallbacks) | **POST** /api/v2/conversations/callbacks | Create a Callback
[**postConversationsCallbacksConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsCallbacksConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/callbacks/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsCalls**](ConversationsApi.md#postConversationsCalls) | **POST** /api/v2/conversations/calls | Create a call conversation
[**postConversationsCallsConversationId**](ConversationsApi.md#postConversationsCallsConversationId) | **POST** /api/v2/conversations/calls/{conversationId} | Add a new call to a conversation
[**postConversationsCallsConversationIdParticipants**](ConversationsApi.md#postConversationsCallsConversationIdParticipants) | **POST** /api/v2/conversations/calls/{conversationId}/participants | Add participants to a conversation
[**postConversationsCallsConversationIdParticipantsParticipantIdConsult**](ConversationsApi.md#postConversationsCallsConversationIdParticipantsParticipantIdConsult) | **POST** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/consult | Initiate and update consult transfer
[**postConversationsCallsConversationIdParticipantsParticipantIdMonitor**](ConversationsApi.md#postConversationsCallsConversationIdParticipantsParticipantIdMonitor) | **POST** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/monitor | Listen in on the conversation from the point of view of a given participant.
[**postConversationsCallsConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsCallsConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/calls/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsChats**](ConversationsApi.md#postConversationsChats) | **POST** /api/v2/conversations/chats | Create a web chat conversation
[**postConversationsChatsConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsChatsConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/chats/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsCobrowsesessionsConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsCobrowsesessionsConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/cobrowsesessions/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsConversationIdParticipantsParticipantIdCallbacks**](ConversationsApi.md#postConversationsConversationIdParticipantsParticipantIdCallbacks) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/callbacks | Create a new callback for the specified participant on the conversation.
[**postConversationsConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsEmails**](ConversationsApi.md#postConversationsEmails) | **POST** /api/v2/conversations/emails | Create an email conversation
[**postConversationsEmailsConversationIdMessages**](ConversationsApi.md#postConversationsEmailsConversationIdMessages) | **POST** /api/v2/conversations/emails/{conversationId}/messages | Send an email reply
[**postConversationsEmailsConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationsEmailsConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/emails/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsFaxes**](ConversationsApi.md#postConversationsFaxes) | **POST** /api/v2/conversations/faxes | Create Fax Conversation
[**putConversationsEmailsConversationIdMessagesDraft**](ConversationsApi.md#putConversationsEmailsConversationIdMessagesDraft) | **PUT** /api/v2/conversations/emails/{conversationId}/messages/draft | Update conversation draft reply


# **deleteConversationsCallsConversationIdParticipantsParticipantIdConsult**
> deleteConversationsCallsConversationIdParticipantsParticipantIdConsult($conversationId, $participantId)

Cancel the transfer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId

try {
    $api_instance->deleteConversationsCallsConversationIdParticipantsParticipantIdConsult($conversationId, $participantId);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteConversationsCallsConversationIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode**
> deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversationId, $participantId, $addCommunicationCode)

Delete a code used to add a communication to this participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$addCommunicationCode = "addCommunicationCode_example"; // string | addCommunicationCode

try {
    $api_instance->deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversationId, $participantId, $addCommunicationCode);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteConversationsConversationIdParticipantsParticipantIdCodesAddcommunicationcode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **addCommunicationCode** | **string**| addCommunicationCode |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConversationsEmailsConversationIdMessagesDraftAttachmentsAttachmentId**
> deleteConversationsEmailsConversationIdMessagesDraftAttachmentsAttachmentId($conversationId, $attachmentId)

Delete attachment from draft



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$attachmentId = "attachmentId_example"; // string | attachmentId

try {
    $api_instance->deleteConversationsEmailsConversationIdMessagesDraftAttachmentsAttachmentId($conversationId, $attachmentId);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteConversationsEmailsConversationIdMessagesDraftAttachmentsAttachmentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **attachmentId** | **string**| attachmentId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAnalyticsConversationsConversationIdDetails**
> \PureCloudSDK\AnalyticsConversation getAnalyticsConversationsConversationIdDetails($conversationId)

Get a conversation by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getAnalyticsConversationsConversationIdDetails($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getAnalyticsConversationsConversationIdDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\AnalyticsConversation**](../Model/AnalyticsConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversations**
> \PureCloudSDK\ConversationEntityListing getConversations($communicationType)

Get conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$communicationType = "communicationType_example"; // string | Call or Chat communication filtering

try {
    $result = $api_instance->getConversations($communicationType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **communicationType** | **string**| Call or Chat communication filtering | [optional]

### Return type

[**\PureCloudSDK\ConversationEntityListing**](../Model/ConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacks**
> \PureCloudSDK\CallbackConversationEntityListing getConversationsCallbacks()

Get callback conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCallbacks();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CallbackConversationEntityListing**](../Model/CallbackConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacksConversationId**
> \PureCloudSDK\CallbackConversation getConversationsCallbacksConversationId($conversationId)

Get callback conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsCallbacksConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacksConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\CallbackConversation**](../Model/CallbackConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacksConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsCallbacksConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsCallbacksConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacksConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallbacksConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsCallbacksConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsCallbacksConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallbacksConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCalls**
> \PureCloudSDK\CallConversationEntityListing getConversationsCalls()

Get recent conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCalls();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCalls: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CallConversationEntityListing**](../Model/CallConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsConversationId**
> \PureCloudSDK\CallConversation getConversationsCallsConversationId($conversationId)

Get call conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsCallsConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\CallConversation**](../Model/CallConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsCallsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsCallsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsCallsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsCallsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsHistory**
> \PureCloudSDK\CallConversationEntityListing getConversationsCallsHistory($pageSize, $pageNumber, $interval)

Get call history



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$interval = "interval_example"; // string | Interval string; format is ISO-8601. Separate start and end times with forward slash '/'

try {
    $result = $api_instance->getConversationsCallsHistory($pageSize, $pageNumber, $interval);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsHistory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **interval** | **string**| Interval string; format is ISO-8601. Separate start and end times with forward slash &#39;/&#39; | [optional]

### Return type

[**\PureCloudSDK\CallConversationEntityListing**](../Model/CallConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCallsMaximumconferenceparties**
> \PureCloudSDK\MaxParticipants getConversationsCallsMaximumconferenceparties()

Get the maximum number of participants that this user can have on a conference



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCallsMaximumconferenceparties();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCallsMaximumconferenceparties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\MaxParticipants**](../Model/MaxParticipants.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChats**
> \PureCloudSDK\ChatConversationEntityListing getConversationsChats()

Get recent chat conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsChats();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ChatConversationEntityListing**](../Model/ChatConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChatsConversationId**
> \PureCloudSDK\ChatConversation getConversationsChatsConversationId($conversationId)

Get chat conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsChatsConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChatsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\ChatConversation**](../Model/ChatConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChatsConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsChatsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsChatsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChatsConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsChatsConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsChatsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsChatsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsChatsConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessions**
> \PureCloudSDK\CobrowseConversationEntityListing getConversationsCobrowsesessions()

Get recent cobrowse conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsCobrowsesessions();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CobrowseConversationEntityListing**](../Model/CobrowseConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessionsConversationId**
> \PureCloudSDK\CobrowseConversation getConversationsCobrowsesessionsConversationId($conversationId)

Get cobrowse conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsCobrowsesessionsConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessionsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\CobrowseConversation**](../Model/CobrowseConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsCobrowsesessionsConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationId**
> \PureCloudSDK\Conversation getConversationsConversationId($conversationId)

Get conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID

try {
    $result = $api_instance->getConversationsConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\WrapupCode getConversationsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID

try {
    $result = $api_instance->getConversationsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmails**
> \PureCloudSDK\EmailConversationEntityListing getConversationsEmails()

Get recent email conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getConversationsEmails();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EmailConversationEntityListing**](../Model/EmailConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsConversationId**
> \PureCloudSDK\EmailConversation getConversationsEmailsConversationId($conversationId)

Get email conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsEmailsConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\EmailConversation**](../Model/EmailConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsConversationIdMessages**
> \PureCloudSDK\EmailMessageListing getConversationsEmailsConversationIdMessages($conversationId)

Get conversation messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsEmailsConversationIdMessages($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsConversationIdMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\EmailMessageListing**](../Model/EmailMessageListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsConversationIdMessagesDraft**
> \PureCloudSDK\EmailMessage getConversationsEmailsConversationIdMessagesDraft($conversationId)

Get conversation draft reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsEmailsConversationIdMessagesDraft($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsConversationIdMessagesDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsConversationIdMessagesMessageId**
> \PureCloudSDK\EmailMessage getConversationsEmailsConversationIdMessagesMessageId($conversationId, $messageId)

Get conversation message



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$messageId = "messageId_example"; // string | messageId

try {
    $result = $api_instance->getConversationsEmailsConversationIdMessagesMessageId($conversationId, $messageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsConversationIdMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **messageId** | **string**| messageId |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getConversationsEmailsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationsEmailsConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsEmailsConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationsEmailsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getConversationsEmailsConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsEmailsConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksConversationId**
> \PureCloudSDK\Conversation patchConversationsCallbacksConversationId($conversationId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsCallbacksConversationId($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksConversationIdParticipantsParticipantId**
> patchConversationsCallbacksConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchConversationsCallbacksConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksConversationIdParticipantsParticipantIdAttributes**
> patchConversationsCallbacksConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Attributes

try {
    $api_instance->patchConversationsCallbacksConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallbacksConversationIdParticipantsParticipantIdCommunicationsCommunicationId**
> \PureCloudSDK\ModelEmpty patchConversationsCallbacksConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $result = $api_instance->patchConversationsCallbacksConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallbacksConversationIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsConversationId**
> \PureCloudSDK\Conversation patchConversationsCallsConversationId($conversationId, $body)

Update a conversation by setting it's recording state, merging in other conversations to create a conference, or disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsCallsConversationId($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsConversationIdParticipantsParticipantId**
> patchConversationsCallsConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant request

try {
    $api_instance->patchConversationsCallsConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsConversationIdParticipantsParticipantIdAttributes**
> patchConversationsCallsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsCallsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**
> \PureCloudSDK\ModelEmpty patchConversationsCallsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $result = $api_instance->patchConversationsCallsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsConversationIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCallsConversationIdParticipantsParticipantIdConsult**
> \PureCloudSDK\ConsultTransferResponse patchConversationsCallsConversationIdParticipantsParticipantIdConsult($conversationId, $participantId, $body)

Change who can speak



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ConsultTransferUpdate(); // \PureCloudSDK\ConsultTransferUpdate | new speak to

try {
    $result = $api_instance->patchConversationsCallsConversationIdParticipantsParticipantIdConsult($conversationId, $participantId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCallsConversationIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ConsultTransferUpdate**](../Model/\PureCloudSDK\ConsultTransferUpdate.md)| new speak to |

### Return type

[**\PureCloudSDK\ConsultTransferResponse**](../Model/ConsultTransferResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsConversationId**
> \PureCloudSDK\Conversation patchConversationsChatsConversationId($conversationId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsChatsConversationId($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsConversationIdParticipantsParticipantId**
> patchConversationsChatsConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchConversationsChatsConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsConversationIdParticipantsParticipantIdAttributes**
> patchConversationsChatsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsChatsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsChatsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**
> \PureCloudSDK\ModelEmpty patchConversationsChatsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $result = $api_instance->patchConversationsChatsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsChatsConversationIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsConversationId**
> \PureCloudSDK\Conversation patchConversationsCobrowsesessionsConversationId($conversationId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsCobrowsesessionsConversationId($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsConversationIdParticipantsParticipantId**
> patchConversationsCobrowsesessionsConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | 

try {
    $api_instance->patchConversationsCobrowsesessionsConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdAttributes**
> patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | 

try {
    $api_instance->patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**
> \PureCloudSDK\ModelEmpty patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $result = $api_instance->patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsCobrowsesessionsConversationIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsConversationIdParticipantsParticipantId**
> patchConversationsConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update a participant.

Update conversation participant.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchConversationsConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsConversationIdParticipantsParticipantIdAttributes**
> patchConversationsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsConversationId**
> \PureCloudSDK\Conversation patchConversationsEmailsConversationId($conversationId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchConversationsEmailsConversationId($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsConversationIdParticipantsParticipantId**
> patchConversationsEmailsConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchConversationsEmailsConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsConversationIdParticipantsParticipantIdAttributes**
> patchConversationsEmailsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationsEmailsConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationsEmailsConversationIdParticipantsParticipantIdCommunicationsCommunicationId**
> \PureCloudSDK\ModelEmpty patchConversationsEmailsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $result = $api_instance->patchConversationsEmailsConversationIdParticipantsParticipantIdCommunicationsCommunicationId($conversationId, $participantId, $communicationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationsEmailsConversationIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postAnalyticsConversationsAggregatesQuery($body)

Query for conversation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postAnalyticsConversationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postAnalyticsConversationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsConversationIdDetailsProperties**
> \PureCloudSDK\PropertyIndexRequest postAnalyticsConversationsConversationIdDetailsProperties($conversationId, $body)

Index conversation properties



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\PropertyIndexRequest(); // \PureCloudSDK\PropertyIndexRequest | request

try {
    $result = $api_instance->postAnalyticsConversationsConversationIdDetailsProperties($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postAnalyticsConversationsConversationIdDetailsProperties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\PropertyIndexRequest**](../Model/\PureCloudSDK\PropertyIndexRequest.md)| request |

### Return type

[**\PureCloudSDK\PropertyIndexRequest**](../Model/PropertyIndexRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsConversationsDetailsQuery**
> \PureCloudSDK\AnalyticsConversationQueryResponse postAnalyticsConversationsDetailsQuery($body)

Query for conversation details



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\ConversationQuery(); // \PureCloudSDK\ConversationQuery | query

try {
    $result = $api_instance->postAnalyticsConversationsDetailsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postAnalyticsConversationsDetailsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ConversationQuery**](../Model/\PureCloudSDK\ConversationQuery.md)| query |

### Return type

[**\PureCloudSDK\AnalyticsConversationQueryResponse**](../Model/AnalyticsConversationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallbacks**
> \PureCloudSDK\CreateCallbackResponse postConversationsCallbacks($body)

Create a Callback



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateCallbackCommand(); // \PureCloudSDK\CreateCallbackCommand | Callback

try {
    $result = $api_instance->postConversationsCallbacks($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateCallbackCommand**](../Model/\PureCloudSDK\CreateCallbackCommand.md)| Callback |

### Return type

[**\PureCloudSDK\CreateCallbackResponse**](../Model/CreateCallbackResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallbacksConversationIdParticipantsParticipantIdReplace**
> postConversationsCallbacksConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsCallbacksConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallbacksConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCalls**
> \PureCloudSDK\CreateCallResponse postConversationsCalls($body)

Create a call conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateCallRequest(); // \PureCloudSDK\CreateCallRequest | Call request

try {
    $result = $api_instance->postConversationsCalls($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCalls: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateCallRequest**](../Model/\PureCloudSDK\CreateCallRequest.md)| Call request |

### Return type

[**\PureCloudSDK\CreateCallResponse**](../Model/CreateCallResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsConversationId**
> \PureCloudSDK\Conversation postConversationsCallsConversationId($conversationId, $body)

Add a new call to a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\CallCommand(); // \PureCloudSDK\CallCommand | Conversation

try {
    $result = $api_instance->postConversationsCallsConversationId($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\CallCommand**](../Model/\PureCloudSDK\CallCommand.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsConversationIdParticipants**
> \PureCloudSDK\Conversation postConversationsCallsConversationIdParticipants($conversationId, $body)

Add participants to a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->postConversationsCallsConversationIdParticipants($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsConversationIdParticipants: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsConversationIdParticipantsParticipantIdConsult**
> \PureCloudSDK\ConsultTransferResponse postConversationsCallsConversationIdParticipantsParticipantIdConsult($conversationId, $participantId, $body)

Initiate and update consult transfer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ConsultTransfer(); // \PureCloudSDK\ConsultTransfer | Destination address & initial speak to

try {
    $result = $api_instance->postConversationsCallsConversationIdParticipantsParticipantIdConsult($conversationId, $participantId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsConversationIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ConsultTransfer**](../Model/\PureCloudSDK\ConsultTransfer.md)| Destination address &amp; initial speak to |

### Return type

[**\PureCloudSDK\ConsultTransferResponse**](../Model/ConsultTransferResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsConversationIdParticipantsParticipantIdMonitor**
> postConversationsCallsConversationIdParticipantsParticipantIdMonitor($conversationId, $participantId)

Listen in on the conversation from the point of view of a given participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId

try {
    $api_instance->postConversationsCallsConversationIdParticipantsParticipantIdMonitor($conversationId, $participantId);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsConversationIdParticipantsParticipantIdMonitor: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCallsConversationIdParticipantsParticipantIdReplace**
> postConversationsCallsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsCallsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCallsConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsChats**
> \PureCloudSDK\ChatConversation postConversationsChats($body)

Create a web chat conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateWebChatRequest(); // \PureCloudSDK\CreateWebChatRequest | Create web chat request

try {
    $result = $api_instance->postConversationsChats($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsChats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateWebChatRequest**](../Model/\PureCloudSDK\CreateWebChatRequest.md)| Create web chat request |

### Return type

[**\PureCloudSDK\ChatConversation**](../Model/ChatConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsChatsConversationIdParticipantsParticipantIdReplace**
> postConversationsChatsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsChatsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsChatsConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsCobrowsesessionsConversationIdParticipantsParticipantIdReplace**
> postConversationsCobrowsesessionsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | 

try {
    $api_instance->postConversationsCobrowsesessionsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsCobrowsesessionsConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdParticipantsParticipantIdCallbacks**
> postConversationsConversationIdParticipantsParticipantIdCallbacks($conversationId, $participantId, $body)

Create a new callback for the specified participant on the conversation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\CreateCallbackCommand(); // \PureCloudSDK\CreateCallbackCommand | 

try {
    $api_instance->postConversationsConversationIdParticipantsParticipantIdCallbacks($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsConversationIdParticipantsParticipantIdCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\CreateCallbackCommand**](../Model/\PureCloudSDK\CreateCallbackCommand.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdParticipantsParticipantIdReplace**
> postConversationsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsEmails**
> \PureCloudSDK\EmailConversation postConversationsEmails($body)

Create an email conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateEmailRequest(); // \PureCloudSDK\CreateEmailRequest | Create email request

try {
    $result = $api_instance->postConversationsEmails($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsEmails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateEmailRequest**](../Model/\PureCloudSDK\CreateEmailRequest.md)| Create email request |

### Return type

[**\PureCloudSDK\EmailConversation**](../Model/EmailConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsEmailsConversationIdMessages**
> \PureCloudSDK\EmailMessage postConversationsEmailsConversationIdMessages($conversationId, $body)

Send an email reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\EmailMessage(); // \PureCloudSDK\EmailMessage | Reply

try {
    $result = $api_instance->postConversationsEmailsConversationIdMessages($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsEmailsConversationIdMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\EmailMessage**](../Model/\PureCloudSDK\EmailMessage.md)| Reply |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsEmailsConversationIdParticipantsParticipantIdReplace**
> postConversationsEmailsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationsEmailsConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsEmailsConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsFaxes**
> \PureCloudSDK\FaxSendResponse postConversationsFaxes($body)

Create Fax Conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\FaxSendRequest(); // \PureCloudSDK\FaxSendRequest | Fax

try {
    $result = $api_instance->postConversationsFaxes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsFaxes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\FaxSendRequest**](../Model/\PureCloudSDK\FaxSendRequest.md)| Fax |

### Return type

[**\PureCloudSDK\FaxSendResponse**](../Model/FaxSendResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putConversationsEmailsConversationIdMessagesDraft**
> \PureCloudSDK\EmailMessage putConversationsEmailsConversationIdMessagesDraft($conversationId, $body)

Update conversation draft reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\EmailMessage(); // \PureCloudSDK\EmailMessage | Draft

try {
    $result = $api_instance->putConversationsEmailsConversationIdMessagesDraft($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->putConversationsEmailsConversationIdMessagesDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\EmailMessage**](../Model/\PureCloudSDK\EmailMessage.md)| Draft |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

