# PureCloudSDK\OrganizationApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getFieldconfig**](OrganizationApi.md#getFieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
[**getOrganizationsMe**](OrganizationApi.md#getOrganizationsMe) | **GET** /api/v2/organizations/me | Get organization.
[**patchOrganizationsFeaturesFeaturename**](OrganizationApi.md#patchOrganizationsFeaturesFeaturename) | **PATCH** /api/v2/organizations/features/{featureName} | Update organization
[**putOrganizationsMe**](OrganizationApi.md#putOrganizationsMe) | **PUT** /api/v2/organizations/me | Update organization.


# **getFieldconfig**
> \PureCloudSDK\FieldConfig getFieldconfig($type)

Fetch field config for an entity type



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OrganizationApi();
$type = "type_example"; // string | Field type

try {
    $result = $api_instance->getFieldconfig($type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationApi->getFieldconfig: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| Field type |

### Return type

[**\PureCloudSDK\FieldConfig**](../Model/FieldConfig.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getOrganizationsMe**
> \PureCloudSDK\Organization getOrganizationsMe()

Get organization.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OrganizationApi();

try {
    $result = $api_instance->getOrganizationsMe();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationApi->getOrganizationsMe: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchOrganizationsFeaturesFeaturename**
> \PureCloudSDK\OrganizationFeatures patchOrganizationsFeaturesFeaturename($featureName, $enabled)

Update organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OrganizationApi();
$featureName = "featureName_example"; // string | Organization feature
$enabled = new \PureCloudSDK\FeatureState(); // \PureCloudSDK\FeatureState | New state of feature

try {
    $result = $api_instance->patchOrganizationsFeaturesFeaturename($featureName, $enabled);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationApi->patchOrganizationsFeaturesFeaturename: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **featureName** | **string**| Organization feature |
 **enabled** | [**\PureCloudSDK\FeatureState**](../Model/\PureCloudSDK\FeatureState.md)| New state of feature |

### Return type

[**\PureCloudSDK\OrganizationFeatures**](../Model/OrganizationFeatures.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putOrganizationsMe**
> \PureCloudSDK\Organization putOrganizationsMe($body)

Update organization.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OrganizationApi();
$body = new \PureCloudSDK\Organization(); // \PureCloudSDK\Organization | Organization

try {
    $result = $api_instance->putOrganizationsMe($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrganizationApi->putOrganizationsMe: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Organization**](../Model/\PureCloudSDK\Organization.md)| Organization | [optional]

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

