# PureCloudSDK\SuggestApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getSearch**](SuggestApi.md#getSearch) | **GET** /api/v2/search | Search using the q64 value returned from a previous search.
[**getSearchSuggest**](SuggestApi.md#getSearchSuggest) | **GET** /api/v2/search/suggest | Suggest resources using the q64 value returned from a previous suggest query.
[**postSearch**](SuggestApi.md#postSearch) | **POST** /api/v2/search | Search resources.
[**postSearchSuggest**](SuggestApi.md#postSearchSuggest) | **POST** /api/v2/search/suggest | Suggest resources.


# **getSearch**
> \PureCloudSDK\JsonNodeSearchResponse getSearch($q64, $expand, $profile)

Search using the q64 value returned from a previous search.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SuggestApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | Which fields, if any, to expand
$profile = true; // bool | profile

try {
    $result = $api_instance->getSearch($q64, $expand, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuggestApi->getSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearchSuggest**
> \PureCloudSDK\JsonNodeSearchResponse getSearchSuggest($q64, $expand, $profile)

Suggest resources using the q64 value returned from a previous suggest query.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SuggestApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | Which fields, if any, to expand
$profile = true; // bool | profile

try {
    $result = $api_instance->getSearchSuggest($q64, $expand, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuggestApi->getSearchSuggest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch**
> \PureCloudSDK\JsonNodeSearchResponse postSearch($body, $profile)

Search resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SuggestApi();
$body = new \PureCloudSDK\SearchRequest(); // \PureCloudSDK\SearchRequest | Search request options
$profile = true; // bool | profile

try {
    $result = $api_instance->postSearch($body, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuggestApi->postSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\SearchRequest**](../Model/\PureCloudSDK\SearchRequest.md)| Search request options |
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearchSuggest**
> \PureCloudSDK\JsonNodeSearchResponse postSearchSuggest($body, $profile)

Suggest resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SuggestApi();
$body = new \PureCloudSDK\SuggestSearchRequest(); // \PureCloudSDK\SuggestSearchRequest | Search request options
$profile = true; // bool | profile

try {
    $result = $api_instance->postSearchSuggest($body, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuggestApi->postSearchSuggest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\SuggestSearchRequest**](../Model/\PureCloudSDK\SuggestSearchRequest.md)| Search request options |
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

