# ModelCase

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**title** | **string** | Brief title of a Case | 
**category** | [**\PureCloudSDK\CaseCategory**](CaseCategory.md) | Predefined category for a case. A list of case categories will be managed by Case Admin | 
**status** | [**\PureCloudSDK\CaseStatus**](CaseStatus.md) | Predefined status to be assigned to a case. A list of case statuses will be managed by Case Admin | 
**type** | [**\PureCloudSDK\CaseType**](CaseType.md) | Predefined type to be assigned to a case. A list of case types will be managed by Case Admin | 
**priority** | [**\PureCloudSDK\CasePriority**](CasePriority.md) | Predefined priority to be assigned to a case. A list of case priorities will be managed by Case Admin | 
**assignedUser** | [**\PureCloudSDK\User**](User.md) | Agent/user who is assigned to a case. | [optional] 
**description** | **string** | Detailed description of a case | 
**comments** | [**\PureCloudSDK\CaseComment[]**](CaseComment.md) | Comments associated to a case. Holds both internal comments added by Agent/Admin and external comments added by Customers. | [optional] 
**dateCreated** | [**\DateTime**](\DateTime.md) | Date when case is created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**dateModified** | [**\DateTime**](\DateTime.md) | Date when case is updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**selfUri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


