# Participant

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | A globally unique identifier for this conversation. | [optional] 
**startTime** | [**\DateTime**](\DateTime.md) | The timestamp when this participant joined the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**endTime** | [**\DateTime**](\DateTime.md) | The timestamp when this participant disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**connectedTime** | [**\DateTime**](\DateTime.md) | The timestamp when this participant was connected to the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**name** | **string** | A human readable name identifying the participant. | [optional] 
**userUri** | **string** | If this participant represents a user, then this will be an URI that can be used to fetch the user. | [optional] 
**userId** | **string** | If this participant represents a user, then this will be the globally unique identifier for the user. | [optional] 
**externalContactId** | **string** | If this participant represents an external contact, then this will be the globally unique identifier for the external contact. | [optional] 
**externalOrganizationId** | **string** | If this participant represents an external org, then this will be the globally unique identifier for the external org. | [optional] 
**queueId** | **string** | If present, the queue id that the communication channel came in on. | [optional] 
**groupId** | **string** | If present, group of users the participant represents. | [optional] 
**queueName** | **string** | If present, the queue name that the communication channel came in on. | [optional] 
**purpose** | **string** | A well known string that specifies the purpose of this participant. | [optional] 
**participantType** | **string** | A well known string that specifies the type of this participant. | [optional] 
**consultParticipantId** | **string** | If this participant is part of a consult transfer, then this will be the participant id of the participant being transferred. | [optional] 
**address** | **string** | The address for the this participant. For a phone call this will be the ANI. | [optional] 
**ani** | **string** | The address for the this participant. For a phone call this will be the ANI. | [optional] 
**aniName** | **string** | The ani-based name for this participant. | [optional] 
**dnis** | **string** | The address for the this participant. For a phone call this will be the ANI. | [optional] 
**locale** | **string** | An ISO 639 language code specifying the locale for this participant | [optional] 
**wrapupRequired** | **bool** | True iff this participant is required to enter wrapup for this conversation. | [optional] 
**wrapupPrompt** | **string** | This field controls how the UI prompts the agent for a wrapup. | [optional] 
**wrapupTimeoutMs** | **int** | Specifies how long a timed ACW session will last. | [optional] 
**wrapupSkipped** | **bool** | The UI sets this field when the agent chooses to skip entering a wrapup for this participant. | [optional] 
**wrapup** | [**\PureCloudSDK\Wrapup**](Wrapup.md) | Call wrap up or disposition data. | [optional] 
**monitoredParticipantId** | **string** | If this participant is a monitor, then this will be the id of the participant that is being monitored. | [optional] 
**attributes** | **map[string,string]** | Additional participant attributes | [optional] 
**calls** | [**\PureCloudSDK\Call[]**](Call.md) |  | [optional] 
**callbacks** | [**\PureCloudSDK\Callback[]**](Callback.md) |  | [optional] 
**chats** | [**\PureCloudSDK\ConversationChat[]**](ConversationChat.md) |  | [optional] 
**cobrowsesessions** | [**\PureCloudSDK\Cobrowsesession[]**](Cobrowsesession.md) |  | [optional] 
**emails** | [**\PureCloudSDK\Email[]**](Email.md) |  | [optional] 
**screenshares** | [**\PureCloudSDK\Screenshare[]**](Screenshare.md) |  | [optional] 
**socialExpressions** | [**\PureCloudSDK\SocialExpression[]**](SocialExpression.md) |  | [optional] 
**videos** | [**\PureCloudSDK\Video[]**](Video.md) |  | [optional] 
**evaluations** | [**\PureCloudSDK\Evaluation[]**](Evaluation.md) |  | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


