# WorkItemDetails

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**workItemDefinition** | [**\PureCloudSDK\WorkItemDefinition**](WorkItemDefinition.md) |  | [optional] 
**flowExecId** | [**\PureCloudSDK\FlowExecId**](FlowExecId.md) | The flow instance ID that created this WorkItem | 
**flowConfigId** | [**\PureCloudSDK\FlowConfigId**](FlowConfigId.md) | The flow config ID that this workitem was created from. | 
**flowCreateTime** | [**\DateTime**](\DateTime.md) | The time the flow was started. (that created this workitem). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | 
**createTime** | [**\DateTime**](\DateTime.md) | The time this workitem was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | 
**owner** | [**\PureCloudSDK\User**](User.md) | The user currently working on/has responsibility for this WorkItem.  May be null if no owner. | [optional] 
**offeredToUsers** | [**\PureCloudSDK\User[]**](User.md) | List of users that this workItem is offered to.  May be null if only offered to queues. | [optional] 
**offeredToQueues** | [**\PureCloudSDK\Queue[]**](Queue.md) | List of queues that this workItem is offered to.  May be null if only offered to users. | [optional] 
**title** | **string** | The work item title | [optional] 
**subtitle** | **string** | The work item&#39;s subtitle - 2nd line/description | [optional] 
**associatedDocuments** | [**\PureCloudSDK\AssociatedDocument[]**](AssociatedDocument.md) | The documents associated with this workitem | [optional] 
**availableActions** | [**\PureCloudSDK\WorkItemActions**](WorkItemActions.md) | The actions that the user can take on this workitem (submit, transfer, etc). | [optional] 
**dataValueInfo** | [**\PureCloudSDK\DataValueInfo**](DataValueInfo.md) | The data items that provide values for any work item form elements, if applicable. | [optional] 
**workItemCache** | [**\PureCloudSDK\WorkItemCache**](WorkItemCache.md) | The data items in the current work item cache, if one exists. | [optional] 
**lastOfferedTime** | [**\DateTime**](\DateTime.md) | The time this work item was last offered to a user or queue. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**lastOwnershipUpdateTime** | [**\DateTime**](\DateTime.md) | The most recent time a user assumed ownership of a work item. This may be blank if the work item has no owner. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**currentTaskStartTime** | [**\DateTime**](\DateTime.md) | This is the time when the current task that started the work item was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**selfUri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


