<?php

/**
 * BuForecastResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuForecastResult Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuForecastResult implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuForecastResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'referenceStartDate' => '\DateTime',
        'planningGroups' => '\PureCloudSDK\ForecastPlanningGroupData[]',
        'weekNumber' => 'int',
        'weekCount' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'referenceStartDate' => 'referenceStartDate',
        'planningGroups' => 'planningGroups',
        'weekNumber' => 'weekNumber',
        'weekCount' => 'weekCount'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'referenceStartDate' => 'setReferenceStartDate',
        'planningGroups' => 'setPlanningGroups',
        'weekNumber' => 'setWeekNumber',
        'weekCount' => 'setWeekCount'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'referenceStartDate' => 'getReferenceStartDate',
        'planningGroups' => 'getPlanningGroups',
        'weekNumber' => 'getWeekNumber',
        'weekCount' => 'getWeekCount'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['referenceStartDate'] = isset($data['referenceStartDate']) ? $data['referenceStartDate'] : null;
        $this->container['planningGroups'] = isset($data['planningGroups']) ? $data['planningGroups'] : null;
        $this->container['weekNumber'] = isset($data['weekNumber']) ? $data['weekNumber'] : null;
        $this->container['weekCount'] = isset($data['weekCount']) ? $data['weekCount'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets referenceStartDate
     * @return \DateTime
     */
    public function getReferenceStartDate()
    {
        return $this->container['referenceStartDate'];
    }

    /**
     * Sets referenceStartDate
     * @param \DateTime $referenceStartDate The reference start date for interval-based data for this forecast. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setReferenceStartDate($referenceStartDate)
    {
        $this->container['referenceStartDate'] = $referenceStartDate;

        return $this;
    }

    /**
     * Gets planningGroups
     * @return \PureCloudSDK\ForecastPlanningGroupData[]
     */
    public function getPlanningGroups()
    {
        return $this->container['planningGroups'];
    }

    /**
     * Sets planningGroups
     * @param \PureCloudSDK\ForecastPlanningGroupData[] $planningGroups The forecast data broken up by planning group
     * @return $this
     */
    public function setPlanningGroups($planningGroups)
    {
        $this->container['planningGroups'] = $planningGroups;

        return $this;
    }

    /**
     * Gets weekNumber
     * @return int
     */
    public function getWeekNumber()
    {
        return $this->container['weekNumber'];
    }

    /**
     * Sets weekNumber
     * @param int $weekNumber The week number represented by this response
     * @return $this
     */
    public function setWeekNumber($weekNumber)
    {
        $this->container['weekNumber'] = $weekNumber;

        return $this;
    }

    /**
     * Gets weekCount
     * @return int
     */
    public function getWeekCount()
    {
        return $this->container['weekCount'];
    }

    /**
     * Sets weekCount
     * @param int $weekCount The number of weeks in this forecast
     * @return $this
     */
    public function setWeekCount($weekCount)
    {
        $this->container['weekCount'] = $weekCount;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
