<?php

/**
 * BuScheduleRun
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuScheduleRun Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuScheduleRun implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuScheduleRun';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'schedulerRunId' => 'string',
        'intradayRescheduling' => 'bool',
        'state' => 'string',
        'weekCount' => 'int',
        'percentComplete' => 'double',
        'targetWeek' => '\DateTime',
        'schedule' => '\PureCloudSDK\BuScheduleReference',
        'scheduleDescription' => 'string',
        'schedulingStartTime' => '\DateTime',
        'schedulingStartedBy' => '\PureCloudSDK\UserReference',
        'schedulingCanceledBy' => '\PureCloudSDK\UserReference',
        'schedulingCompletedTime' => '\DateTime',
        'messageCount' => 'int',
        'reschedulingOptions' => '\PureCloudSDK\ReschedulingOptionsRunResponse',
        'reschedulingResultExpiration' => '\DateTime',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'schedulerRunId' => 'schedulerRunId',
        'intradayRescheduling' => 'intradayRescheduling',
        'state' => 'state',
        'weekCount' => 'weekCount',
        'percentComplete' => 'percentComplete',
        'targetWeek' => 'targetWeek',
        'schedule' => 'schedule',
        'scheduleDescription' => 'scheduleDescription',
        'schedulingStartTime' => 'schedulingStartTime',
        'schedulingStartedBy' => 'schedulingStartedBy',
        'schedulingCanceledBy' => 'schedulingCanceledBy',
        'schedulingCompletedTime' => 'schedulingCompletedTime',
        'messageCount' => 'messageCount',
        'reschedulingOptions' => 'reschedulingOptions',
        'reschedulingResultExpiration' => 'reschedulingResultExpiration',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'schedulerRunId' => 'setSchedulerRunId',
        'intradayRescheduling' => 'setIntradayRescheduling',
        'state' => 'setState',
        'weekCount' => 'setWeekCount',
        'percentComplete' => 'setPercentComplete',
        'targetWeek' => 'setTargetWeek',
        'schedule' => 'setSchedule',
        'scheduleDescription' => 'setScheduleDescription',
        'schedulingStartTime' => 'setSchedulingStartTime',
        'schedulingStartedBy' => 'setSchedulingStartedBy',
        'schedulingCanceledBy' => 'setSchedulingCanceledBy',
        'schedulingCompletedTime' => 'setSchedulingCompletedTime',
        'messageCount' => 'setMessageCount',
        'reschedulingOptions' => 'setReschedulingOptions',
        'reschedulingResultExpiration' => 'setReschedulingResultExpiration',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'schedulerRunId' => 'getSchedulerRunId',
        'intradayRescheduling' => 'getIntradayRescheduling',
        'state' => 'getState',
        'weekCount' => 'getWeekCount',
        'percentComplete' => 'getPercentComplete',
        'targetWeek' => 'getTargetWeek',
        'schedule' => 'getSchedule',
        'scheduleDescription' => 'getScheduleDescription',
        'schedulingStartTime' => 'getSchedulingStartTime',
        'schedulingStartedBy' => 'getSchedulingStartedBy',
        'schedulingCanceledBy' => 'getSchedulingCanceledBy',
        'schedulingCompletedTime' => 'getSchedulingCompletedTime',
        'messageCount' => 'getMessageCount',
        'reschedulingOptions' => 'getReschedulingOptions',
        'reschedulingResultExpiration' => 'getReschedulingResultExpiration',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_NONE = 'None';
    public const STATE_QUEUED = 'Queued';
    public const STATE_SCHEDULING = 'Scheduling';
    public const STATE_CANCELED = 'Canceled';
    public const STATE_FAILED = 'Failed';
    public const STATE_COMPLETE = 'Complete';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_NONE,
            self::STATE_QUEUED,
            self::STATE_SCHEDULING,
            self::STATE_CANCELED,
            self::STATE_FAILED,
            self::STATE_COMPLETE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['schedulerRunId'] = isset($data['schedulerRunId']) ? $data['schedulerRunId'] : null;
        $this->container['intradayRescheduling'] = isset($data['intradayRescheduling']) ? $data['intradayRescheduling'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['weekCount'] = isset($data['weekCount']) ? $data['weekCount'] : null;
        $this->container['percentComplete'] = isset($data['percentComplete']) ? $data['percentComplete'] : null;
        $this->container['targetWeek'] = isset($data['targetWeek']) ? $data['targetWeek'] : null;
        $this->container['schedule'] = isset($data['schedule']) ? $data['schedule'] : null;
        $this->container['scheduleDescription'] = isset($data['scheduleDescription']) ? $data['scheduleDescription'] : null;
        $this->container['schedulingStartTime'] = isset($data['schedulingStartTime']) ? $data['schedulingStartTime'] : null;
        $this->container['schedulingStartedBy'] = isset($data['schedulingStartedBy']) ? $data['schedulingStartedBy'] : null;
        $this->container['schedulingCanceledBy'] = isset($data['schedulingCanceledBy']) ? $data['schedulingCanceledBy'] : null;
        $this->container['schedulingCompletedTime'] = isset($data['schedulingCompletedTime']) ? $data['schedulingCompletedTime'] : null;
        $this->container['messageCount'] = isset($data['messageCount']) ? $data['messageCount'] : null;
        $this->container['reschedulingOptions'] = isset($data['reschedulingOptions']) ? $data['reschedulingOptions'] : null;
        $this->container['reschedulingResultExpiration'] = isset($data['reschedulingResultExpiration']) ? $data['reschedulingResultExpiration'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("None", "Queued", "Scheduling", "Canceled", "Failed", "Complete");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("None", "Queued", "Scheduling", "Canceled", "Failed", "Complete");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets schedulerRunId
     * @return string
     */
    public function getSchedulerRunId()
    {
        return $this->container['schedulerRunId'];
    }

    /**
     * Sets schedulerRunId
     * @param string $schedulerRunId The scheduler run ID.  Reference this value for support
     * @return $this
     */
    public function setSchedulerRunId($schedulerRunId)
    {
        $this->container['schedulerRunId'] = $schedulerRunId;

        return $this;
    }

    /**
     * Gets intradayRescheduling
     * @return bool
     */
    public function getIntradayRescheduling()
    {
        return $this->container['intradayRescheduling'];
    }

    /**
     * Sets intradayRescheduling
     * @param bool $intradayRescheduling Whether this is an intraday rescheduling run
     * @return $this
     */
    public function setIntradayRescheduling($intradayRescheduling)
    {
        $this->container['intradayRescheduling'] = $intradayRescheduling;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The state of the generation run
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('None', 'Queued', 'Scheduling', 'Canceled', 'Failed', 'Complete');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'None', 'Queued', 'Scheduling', 'Canceled', 'Failed', 'Complete'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets weekCount
     * @return int
     */
    public function getWeekCount()
    {
        return $this->container['weekCount'];
    }

    /**
     * Sets weekCount
     * @param int $weekCount The number of weeks spanned by the schedule
     * @return $this
     */
    public function setWeekCount($weekCount)
    {
        $this->container['weekCount'] = $weekCount;

        return $this;
    }

    /**
     * Gets percentComplete
     * @return double
     */
    public function getPercentComplete()
    {
        return $this->container['percentComplete'];
    }

    /**
     * Sets percentComplete
     * @param double $percentComplete Percent completion of the schedule run
     * @return $this
     */
    public function setPercentComplete($percentComplete)
    {
        $this->container['percentComplete'] = $percentComplete;

        return $this;
    }

    /**
     * Gets targetWeek
     * @return \DateTime
     */
    public function getTargetWeek()
    {
        return $this->container['targetWeek'];
    }

    /**
     * Sets targetWeek
     * @param \DateTime $targetWeek The start date of the target week. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
     * @return $this
     */
    public function setTargetWeek($targetWeek)
    {
        $this->container['targetWeek'] = $targetWeek;

        return $this;
    }

    /**
     * Gets schedule
     * @return \PureCloudSDK\BuScheduleReference
     */
    public function getSchedule()
    {
        return $this->container['schedule'];
    }

    /**
     * Sets schedule
     * @param \PureCloudSDK\BuScheduleReference $schedule The generated schedule.  Null unless the schedule run is complete
     * @return $this
     */
    public function setSchedule($schedule)
    {
        $this->container['schedule'] = $schedule;

        return $this;
    }

    /**
     * Gets scheduleDescription
     * @return string
     */
    public function getScheduleDescription()
    {
        return $this->container['scheduleDescription'];
    }

    /**
     * Sets scheduleDescription
     * @param string $scheduleDescription The description of the generated schedule
     * @return $this
     */
    public function setScheduleDescription($scheduleDescription)
    {
        $this->container['scheduleDescription'] = $scheduleDescription;

        return $this;
    }

    /**
     * Gets schedulingStartTime
     * @return \DateTime
     */
    public function getSchedulingStartTime()
    {
        return $this->container['schedulingStartTime'];
    }

    /**
     * Sets schedulingStartTime
     * @param \DateTime $schedulingStartTime When the schedule generation run started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSchedulingStartTime($schedulingStartTime)
    {
        $this->container['schedulingStartTime'] = $schedulingStartTime;

        return $this;
    }

    /**
     * Gets schedulingStartedBy
     * @return \PureCloudSDK\UserReference
     */
    public function getSchedulingStartedBy()
    {
        return $this->container['schedulingStartedBy'];
    }

    /**
     * Sets schedulingStartedBy
     * @param \PureCloudSDK\UserReference $schedulingStartedBy The user who started the scheduling run
     * @return $this
     */
    public function setSchedulingStartedBy($schedulingStartedBy)
    {
        $this->container['schedulingStartedBy'] = $schedulingStartedBy;

        return $this;
    }

    /**
     * Gets schedulingCanceledBy
     * @return \PureCloudSDK\UserReference
     */
    public function getSchedulingCanceledBy()
    {
        return $this->container['schedulingCanceledBy'];
    }

    /**
     * Sets schedulingCanceledBy
     * @param \PureCloudSDK\UserReference $schedulingCanceledBy The user who canceled the scheduling run, if applicable
     * @return $this
     */
    public function setSchedulingCanceledBy($schedulingCanceledBy)
    {
        $this->container['schedulingCanceledBy'] = $schedulingCanceledBy;

        return $this;
    }

    /**
     * Gets schedulingCompletedTime
     * @return \DateTime
     */
    public function getSchedulingCompletedTime()
    {
        return $this->container['schedulingCompletedTime'];
    }

    /**
     * Sets schedulingCompletedTime
     * @param \DateTime $schedulingCompletedTime When the scheduling run was completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSchedulingCompletedTime($schedulingCompletedTime)
    {
        $this->container['schedulingCompletedTime'] = $schedulingCompletedTime;

        return $this;
    }

    /**
     * Gets messageCount
     * @return int
     */
    public function getMessageCount()
    {
        return $this->container['messageCount'];
    }

    /**
     * Sets messageCount
     * @param int $messageCount The number of schedule generation messages for this schedule generation run
     * @return $this
     */
    public function setMessageCount($messageCount)
    {
        $this->container['messageCount'] = $messageCount;

        return $this;
    }

    /**
     * Gets reschedulingOptions
     * @return \PureCloudSDK\ReschedulingOptionsRunResponse
     */
    public function getReschedulingOptions()
    {
        return $this->container['reschedulingOptions'];
    }

    /**
     * Sets reschedulingOptions
     * @param \PureCloudSDK\ReschedulingOptionsRunResponse $reschedulingOptions Rescheduling options for this run.  Null unless intradayRescheduling is true
     * @return $this
     */
    public function setReschedulingOptions($reschedulingOptions)
    {
        $this->container['reschedulingOptions'] = $reschedulingOptions;

        return $this;
    }

    /**
     * Gets reschedulingResultExpiration
     * @return \DateTime
     */
    public function getReschedulingResultExpiration()
    {
        return $this->container['reschedulingResultExpiration'];
    }

    /**
     * Sets reschedulingResultExpiration
     * @param \DateTime $reschedulingResultExpiration When the reschedule result will expire.  Null unless intradayRescheduling is true. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setReschedulingResultExpiration($reschedulingResultExpiration)
    {
        $this->container['reschedulingResultExpiration'] = $reschedulingResultExpiration;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
