<?php

/**
 * IntradayHistoricalQueueData
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * IntradayHistoricalQueueData Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class IntradayHistoricalQueueData implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'IntradayHistoricalQueueData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'offered' => 'int',
        'completed' => 'int',
        'answered' => 'int',
        'abandoned' => 'int',
        'averageTalkTimeSeconds' => 'double',
        'averageAfterCallWorkSeconds' => 'double',
        'serviceLevelPercent' => 'double',
        'averageSpeedOfAnswerSeconds' => 'double'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'offered' => 'offered',
        'completed' => 'completed',
        'answered' => 'answered',
        'abandoned' => 'abandoned',
        'averageTalkTimeSeconds' => 'averageTalkTimeSeconds',
        'averageAfterCallWorkSeconds' => 'averageAfterCallWorkSeconds',
        'serviceLevelPercent' => 'serviceLevelPercent',
        'averageSpeedOfAnswerSeconds' => 'averageSpeedOfAnswerSeconds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'offered' => 'setOffered',
        'completed' => 'setCompleted',
        'answered' => 'setAnswered',
        'abandoned' => 'setAbandoned',
        'averageTalkTimeSeconds' => 'setAverageTalkTimeSeconds',
        'averageAfterCallWorkSeconds' => 'setAverageAfterCallWorkSeconds',
        'serviceLevelPercent' => 'setServiceLevelPercent',
        'averageSpeedOfAnswerSeconds' => 'setAverageSpeedOfAnswerSeconds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'offered' => 'getOffered',
        'completed' => 'getCompleted',
        'answered' => 'getAnswered',
        'abandoned' => 'getAbandoned',
        'averageTalkTimeSeconds' => 'getAverageTalkTimeSeconds',
        'averageAfterCallWorkSeconds' => 'getAverageAfterCallWorkSeconds',
        'serviceLevelPercent' => 'getServiceLevelPercent',
        'averageSpeedOfAnswerSeconds' => 'getAverageSpeedOfAnswerSeconds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['offered'] = isset($data['offered']) ? $data['offered'] : null;
        $this->container['completed'] = isset($data['completed']) ? $data['completed'] : null;
        $this->container['answered'] = isset($data['answered']) ? $data['answered'] : null;
        $this->container['abandoned'] = isset($data['abandoned']) ? $data['abandoned'] : null;
        $this->container['averageTalkTimeSeconds'] = isset($data['averageTalkTimeSeconds']) ? $data['averageTalkTimeSeconds'] : null;
        $this->container['averageAfterCallWorkSeconds'] = isset($data['averageAfterCallWorkSeconds']) ? $data['averageAfterCallWorkSeconds'] : null;
        $this->container['serviceLevelPercent'] = isset($data['serviceLevelPercent']) ? $data['serviceLevelPercent'] : null;
        $this->container['averageSpeedOfAnswerSeconds'] = isset($data['averageSpeedOfAnswerSeconds']) ? $data['averageSpeedOfAnswerSeconds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets offered
     * @return int
     */
    public function getOffered()
    {
        return $this->container['offered'];
    }

    /**
     * Sets offered
     * @param int $offered The number of interactions routed into the queue for the given media type(s) for an agent to answer
     * @return $this
     */
    public function setOffered($offered)
    {
        $this->container['offered'] = $offered;

        return $this;
    }

    /**
     * Gets completed
     * @return int
     */
    public function getCompleted()
    {
        return $this->container['completed'];
    }

    /**
     * Sets completed
     * @param int $completed The number of interactions completed
     * @return $this
     */
    public function setCompleted($completed)
    {
        $this->container['completed'] = $completed;

        return $this;
    }

    /**
     * Gets answered
     * @return int
     */
    public function getAnswered()
    {
        return $this->container['answered'];
    }

    /**
     * Sets answered
     * @param int $answered The number of interactions answered by an agent in a given period
     * @return $this
     */
    public function setAnswered($answered)
    {
        $this->container['answered'] = $answered;

        return $this;
    }

    /**
     * Gets abandoned
     * @return int
     */
    public function getAbandoned()
    {
        return $this->container['abandoned'];
    }

    /**
     * Sets abandoned
     * @param int $abandoned The number of customers who disconnect before connecting with an agent
     * @return $this
     */
    public function setAbandoned($abandoned)
    {
        $this->container['abandoned'] = $abandoned;

        return $this;
    }

    /**
     * Gets averageTalkTimeSeconds
     * @return double
     */
    public function getAverageTalkTimeSeconds()
    {
        return $this->container['averageTalkTimeSeconds'];
    }

    /**
     * Sets averageTalkTimeSeconds
     * @param double $averageTalkTimeSeconds The average time in seconds an agent spends interacting with a customer per talk segment for a defined period of time
     * @return $this
     */
    public function setAverageTalkTimeSeconds($averageTalkTimeSeconds)
    {
        $this->container['averageTalkTimeSeconds'] = $averageTalkTimeSeconds;

        return $this;
    }

    /**
     * Gets averageAfterCallWorkSeconds
     * @return double
     */
    public function getAverageAfterCallWorkSeconds()
    {
        return $this->container['averageAfterCallWorkSeconds'];
    }

    /**
     * Sets averageAfterCallWorkSeconds
     * @param double $averageAfterCallWorkSeconds The average time in seconds spent in after-call work. After-call work is the work that an agent performs immediately following an interaction
     * @return $this
     */
    public function setAverageAfterCallWorkSeconds($averageAfterCallWorkSeconds)
    {
        $this->container['averageAfterCallWorkSeconds'] = $averageAfterCallWorkSeconds;

        return $this;
    }

    /**
     * Gets serviceLevelPercent
     * @return double
     */
    public function getServiceLevelPercent()
    {
        return $this->container['serviceLevelPercent'];
    }

    /**
     * Sets serviceLevelPercent
     * @param double $serviceLevelPercent Percent of interactions answered in X seconds, where X is the service level objective configured in the service goal group matching this intraday group
     * @return $this
     */
    public function setServiceLevelPercent($serviceLevelPercent)
    {
        $this->container['serviceLevelPercent'] = $serviceLevelPercent;

        return $this;
    }

    /**
     * Gets averageSpeedOfAnswerSeconds
     * @return double
     */
    public function getAverageSpeedOfAnswerSeconds()
    {
        return $this->container['averageSpeedOfAnswerSeconds'];
    }

    /**
     * Sets averageSpeedOfAnswerSeconds
     * @param double $averageSpeedOfAnswerSeconds The average time in seconds it takes to answer an interaction once the interaction becomes available to be routed
     * @return $this
     */
    public function setAverageSpeedOfAnswerSeconds($averageSpeedOfAnswerSeconds)
    {
        $this->container['averageSpeedOfAnswerSeconds'] = $averageSpeedOfAnswerSeconds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
