<?php

/**
 * IntradayPlanningGroupRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * IntradayPlanningGroupRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class IntradayPlanningGroupRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'IntradayPlanningGroupRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'businessUnitDate' => '\DateTime',
        'categories' => 'string[]',
        'planningGroupIds' => 'string[]',
        'intervalLengthMinutes' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'businessUnitDate' => 'businessUnitDate',
        'categories' => 'categories',
        'planningGroupIds' => 'planningGroupIds',
        'intervalLengthMinutes' => 'intervalLengthMinutes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'businessUnitDate' => 'setBusinessUnitDate',
        'categories' => 'setCategories',
        'planningGroupIds' => 'setPlanningGroupIds',
        'intervalLengthMinutes' => 'setIntervalLengthMinutes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'businessUnitDate' => 'getBusinessUnitDate',
        'categories' => 'getCategories',
        'planningGroupIds' => 'getPlanningGroupIds',
        'intervalLengthMinutes' => 'getIntervalLengthMinutes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const CATEGORIES_FORECAST_DATA = 'ForecastData';
    public const CATEGORIES_SCHEDULE_DATA = 'ScheduleData';
    public const CATEGORIES_PERFORMANCE_PREDICTION_DATA = 'PerformancePredictionData';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCategoriesAllowableValues()
    {
        return [
            self::CATEGORIES_FORECAST_DATA,
            self::CATEGORIES_SCHEDULE_DATA,
            self::CATEGORIES_PERFORMANCE_PREDICTION_DATA,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['businessUnitDate'] = isset($data['businessUnitDate']) ? $data['businessUnitDate'] : null;
        $this->container['categories'] = isset($data['categories']) ? $data['categories'] : null;
        $this->container['planningGroupIds'] = isset($data['planningGroupIds']) ? $data['planningGroupIds'] : null;
        $this->container['intervalLengthMinutes'] = isset($data['intervalLengthMinutes']) ? $data['intervalLengthMinutes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['businessUnitDate'] === null) {
            $invalid_properties[] = "'businessUnitDate' can't be null";
        }
        if ($this->container['categories'] === null) {
            $invalid_properties[] = "'categories' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['businessUnitDate'] === null) {
            return false;
        }
        if ($this->container['categories'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets businessUnitDate
     * @return \DateTime
     */
    public function getBusinessUnitDate()
    {
        return $this->container['businessUnitDate'];
    }

    /**
     * Sets businessUnitDate
     * @param \DateTime $businessUnitDate Requested date in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd
     * @return $this
     */
    public function setBusinessUnitDate($businessUnitDate)
    {
        $this->container['businessUnitDate'] = $businessUnitDate;

        return $this;
    }

    /**
     * Gets categories
     * @return string[]
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     * @param string[] $categories The metric categories
     * @return $this
     */
    public function setCategories($categories)
    {
        $allowed_values = array('ForecastData', 'ScheduleData', 'PerformancePredictionData');
        if (!in_array($categories, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'categories', must be one of 'ForecastData', 'ScheduleData', 'PerformancePredictionData'");
        }
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets planningGroupIds
     * @return string[]
     */
    public function getPlanningGroupIds()
    {
        return $this->container['planningGroupIds'];
    }

    /**
     * Sets planningGroupIds
     * @param string[] $planningGroupIds The IDs of the planning groups for which to fetch data.  Omitting or passing an empty list will return all available planning groups
     * @return $this
     */
    public function setPlanningGroupIds($planningGroupIds)
    {
        $this->container['planningGroupIds'] = $planningGroupIds;

        return $this;
    }

    /**
     * Gets intervalLengthMinutes
     * @return int
     */
    public function getIntervalLengthMinutes()
    {
        return $this->container['intervalLengthMinutes'];
    }

    /**
     * Sets intervalLengthMinutes
     * @param int $intervalLengthMinutes The period/interval in minutes for which to aggregate the data. Required, defaults to 15
     * @return $this
     */
    public function setIntervalLengthMinutes($intervalLengthMinutes)
    {
        $this->container['intervalLengthMinutes'] = $intervalLengthMinutes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
